/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.jwt.domain.JWT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.primeframework.mvc.security.BaseJWTRefreshTokenCookiesUserLoginSecurityContext;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.security.oauth.OAuthConfiguration;
import org.primeframework.mvc.security.oauth.TokenAuthenticationMethod;
import org.primeframework.mvc.security.oauth.Tokens;

public class MockOAuthUserLoginSecurityContext
extends BaseJWTRefreshTokenCookiesUserLoginSecurityContext {
    public static Object CurrentUser;
    public static Set<String> Roles;
    public static String TokenEndpoint;
    public static boolean ValidateJWTOnLogin;
    public static Map<String, List<String>> additionalParameters;
    public static String clientId;
    public static String clientSecret;
    public static TokenAuthenticationMethod tokenAuthenticationMethod;

    @Inject
    public MockOAuthUserLoginSecurityContext(HTTPRequest hTTPRequest, HTTPResponse hTTPResponse, VerifierProvider verifierProvider) {
        super(hTTPRequest, hTTPResponse, verifierProvider);
    }

    public static void reset() {
        TokenEndpoint = "http://localhost:8000/oauth/token";
        ValidateJWTOnLogin = true;
        tokenAuthenticationMethod = TokenAuthenticationMethod.none;
    }

    public Set<String> getCurrentUsersRoles() {
        return Roles;
    }

    public String getSessionId() {
        return CurrentUser != null ? Integer.toString(CurrentUser.hashCode()) : null;
    }

    public void login(Object object) {
        if (ValidateJWTOnLogin) {
            super.login(object);
        }
        if (!(object instanceof Tokens)) {
            throw new IllegalArgumentException("The login context for [BaseJWTRefreshTokenCookiesUserLoginSecurityContext] is expected to be of type [" + Tokens.class.getCanonicalName() + "] but an object of type [" + object.getClass().getCanonicalName() + "] was provided. This is a development time error.");
        }
        Tokens tokens = (Tokens)object;
        if (tokens.jwt != null) {
            this.jwtCookie.add(this.request, this.response, tokens.jwt);
        }
        if (tokens.refreshToken != null) {
            this.refreshTokenCookie.add(this.request, this.response, tokens.refreshToken);
        }
    }

    protected String jwtCookieName() {
        return "prime-jwt";
    }

    protected OAuthConfiguration oauthConfiguration() {
        return (OAuthConfiguration)((OAuthConfiguration)((OAuthConfiguration)((OAuthConfiguration)((OAuthConfiguration)new OAuthConfiguration().with(oAuthConfiguration -> {
            oAuthConfiguration.authenticationMethod = tokenAuthenticationMethod;
        })).with(oAuthConfiguration -> {
            oAuthConfiguration.clientId = clientId;
        })).with(oAuthConfiguration -> {
            oAuthConfiguration.clientSecret = clientSecret;
        })).with(oAuthConfiguration -> {
            oAuthConfiguration.tokenEndpoint = TokenEndpoint;
        })).with(oAuthConfiguration -> oAuthConfiguration.additionalParameters.putAll(additionalParameters));
    }

    protected String refreshTokenCookieName() {
        return "prime-refresh-token";
    }

    protected Object retrieveUserForJWT(JWT jWT, String string) {
        return CurrentUser;
    }

    static {
        Roles = new HashSet<String>();
        TokenEndpoint = "http://localhost:8000/oauth/token";
        ValidateJWTOnLogin = true;
        additionalParameters = new HashMap<String, List<String>>();
    }
}

