/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primeframework.mvc.TestPrimeMain;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.security.BaseUserIdCookieSecurityContext;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.MockBaseUserIdCookieSecurityContext;
import org.primeframework.mvc.security.MockUserIdSessionContext;
import org.primeframework.mvc.security.SessionCookieKeyChanger;
import org.primeframework.mvc.security.SessionTestModule;
import org.primeframework.mvc.test.RequestResult;
import org.primeframework.mvc.test.RequestSimulator;
import org.primeframework.mvc.util.CookieTools;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class BaseUserIdCookieSecurityContextTest {
    private static final String UserKey = "primeCurrentUser";
    private static Clock mockClock;
    private static ZonedDateTime mockClockNow;
    private static RequestSimulator simulator;
    @Inject
    private SessionCookieKeyChanger cookieKeyChanger;
    @Inject
    private Encryptor encryptor;
    @Inject
    private ObjectMapper objectMapper;

    private static RequestSimulator buildSimulator(SessionTestModule sessionTestModule) {
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withListener(new HTTPListenerConfiguration(9081));
        TestPrimeMain testPrimeMain = new TestPrimeMain(new HTTPServerConfiguration[]{hTTPServerConfiguration}, new Module[]{sessionTestModule, new MVCModule()});
        return new RequestSimulator(testPrimeMain, new TestMessageObserver());
    }

    private static String getSessionID(RequestResult requestResult) {
        Pattern pattern = Pattern.compile(".*the session ID is (\\S+).*", 40);
        Matcher matcher = pattern.matcher(requestResult.getBodyAsString());
        Assert.assertTrue((boolean)matcher.matches());
        return matcher.group(1);
    }

    private static void resetMockClock() {
        mockClock = Clock.fixed(Instant.ofEpochSecond(42L), ZoneId.of("UTC"));
        mockClockNow = mockClock.instant().atZone(ZoneId.of("UTC"));
    }

    @AfterMethod
    public void afterMethod() {
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.clearResponse();
    }

    @Test
    public void cookie_encryption_key_changed() {
        this.doLogin();
        Cookie cookie = BaseUserIdCookieSecurityContextTest.simulator.userAgent.getCookie(UserKey);
        this.cookieKeyChanger.changeIt(cookie);
        this.getSessionInfo().assertBodyContains("the session ID is (no session)").assertBodyContains("logged in no").assertBodyContains("the current user is (no user)");
    }

    @DataProvider(name="cookieActionData")
    public Object[][] extendCookieData() {
        return new Object[][]{{"less_than_halfway_through_timeout", mockClockNow, Duration.ofDays(1L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Keep}, {"halfway_through_timeout", mockClockNow.minusMinutes(15L), Duration.ofDays(1L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Keep}, {"more_than_halfway_through_timeout", mockClockNow.minusMinutes(16L), Duration.ofDays(1L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Extend}, {"almost_max_age", mockClockNow.minusMinutes(10L), Duration.ofMinutes(30L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Keep}, {"equals_max_age", mockClockNow.minusMinutes(30L), Duration.ofMinutes(30L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Keep}, {"past_max_age", mockClockNow.minusMinutes(60L), Duration.ofMinutes(30L), Duration.ofMinutes(30L), BaseUserIdCookieSecurityContext.CookieExtendResult.Invalid}};
    }

    @Test
    public void getCurrentUser_extend() {
        this.doLogin();
        ZonedDateTime zonedDateTime = mockClockNow.plusMinutes(4L);
        mockClock = Clock.fixed(zonedDateTime.toInstant(), ZoneId.of("UTC"));
        RequestResult requestResult = this.getSessionInfo();
        requestResult.assertContainsCookie(UserKey);
    }

    @Test
    public void getCurrentUser_has_session() {
        this.doLogin();
        this.getSessionInfo().assertBodyContains("the current user is bob");
    }

    @Test
    public void getCurrentUser_has_session_caches_in_request() {
        this.doLogin();
        this.getSessionInfo().assertBodyContains("the user in the request is bob");
    }

    @Test
    public void getCurrentUser_no_extend() {
        this.doLogin();
        ZonedDateTime zonedDateTime = mockClockNow.plusMinutes(31L);
        mockClock = Clock.fixed(zonedDateTime.toInstant(), ZoneId.of("UTC"));
        RequestResult requestResult = this.getSessionInfo();
        requestResult.assertBodyContains("the current user is (no user)");
        Assert.assertEquals((String)requestResult.getCookie((String)UserKey).value, (String)"");
    }

    @Test
    public void getCurrentUser_no_session() {
        this.getSessionInfo().assertBodyContains("the current user is (no user)");
    }

    @Test
    public void getSessionId_has_session() {
        this.doLogin();
        this.getSessionInfo().assertBodyDoesNotContain("the session ID is (no session)");
    }

    @Test
    public void getSessionId_no_session() {
        this.getSessionInfo().assertBodyContains("the session ID is (no session)");
    }

    @Test
    public void isLoggedIn_has_session() {
        this.doLogin();
        this.getSessionInfo().assertBodyContains("logged in yes");
    }

    @Test
    public void isLoggedIn_no_session() {
        this.getSessionInfo().assertBodyContains("logged in no");
    }

    @Test
    public void login() {
        RequestResult requestResult = this.doLogin();
        requestResult.assertStatusCode(200).assertContainsNoGeneralErrors().assertContainsCookie(UserKey);
    }

    @Test
    public void logout() {
        this.doLogin();
        simulator.test("/security/cookiesession/do-logout").get();
        this.getSessionInfo().assertBodyContains("the session ID is (no session)").assertBodyContains("logged in no").assertBodyContains("the current user is (no user)");
    }

    @Test(dataProvider="cookieActionData")
    public void shouldExtendCookie(String string, ZonedDateTime zonedDateTime, Duration duration, Duration duration2, BaseUserIdCookieSecurityContext.CookieExtendResult cookieExtendResult) {
        MockBaseUserIdCookieSecurityContext mockBaseUserIdCookieSecurityContext = new MockBaseUserIdCookieSecurityContext(null, null, null, null, mockClock, duration2, duration);
        BaseUserIdCookieSecurityContext.CookieExtendResult cookieExtendResult2 = mockBaseUserIdCookieSecurityContext.shouldExtendCookie(zonedDateTime);
        Assert.assertEquals((Object)cookieExtendResult2, (Object)cookieExtendResult);
    }

    @AfterClass
    public void shutdown() {
        simulator.shutdown();
    }

    @BeforeClass
    public void startItUp() {
        BaseUserIdCookieSecurityContextTest.resetMockClock();
        simulator = BaseUserIdCookieSecurityContextTest.buildSimulator(new SessionTestModule((Provider<Clock>)((Provider)() -> mockClock)));
        simulator.getInjector().injectMembers((Object)this);
    }

    @Test
    public void unencrypted_cookie_presented() throws Exception {
        this.doLogin();
        Cookie cookie = BaseUserIdCookieSecurityContextTest.simulator.userAgent.getCookie(UserKey);
        MockUserIdSessionContext mockUserIdSessionContext = (MockUserIdSessionContext)CookieTools.fromJSONCookie((String)cookie.value, MockUserIdSessionContext.class, (boolean)true, (boolean)true, (Encryptor)this.encryptor, (ObjectMapper)this.objectMapper);
        cookie.value = CookieTools.toJSONCookie((Object)mockUserIdSessionContext, (boolean)true, (boolean)false, (Encryptor)this.encryptor, (ObjectMapper)this.objectMapper);
        this.getSessionInfo().assertBodyContains("the session ID is (no session)");
    }

    @Test
    public void updateUser() {
        this.doLogin();
        RequestResult requestResult = this.getSessionInfo();
        String string = BaseUserIdCookieSecurityContextTest.getSessionID(requestResult);
        RequestResult requestResult2 = simulator.test("/security/cookiesession/get-session-info").withURLParameter("update", "yes").withURLParameter("updateNewUserEmail", "alice").get();
        requestResult2.assertBodyContains("the current user is alice").assertBodyContains("the session ID is " + string);
        this.getSessionInfo().assertBodyContains("the session ID is " + string).assertBodyContains("the current user is bob");
    }

    @BeforeMethod
    void cleanup() {
        simulator.reset();
        BaseUserIdCookieSecurityContextTest.resetMockClock();
    }

    private RequestResult doLogin() {
        return simulator.test("/security/cookiesession/do-login").get().assertStatusCode(200);
    }

    private RequestResult getSessionInfo() {
        return simulator.test("/security/cookiesession/get-session-info").get();
    }
}

