/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Hidden;
import org.testng.annotations.Test;

public class HiddenTest
extends ControlBaseTest {
    @Inject
    public Hidden hidden;

    @Test
    public void action_boolean_default() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/hidden", null, null));
        editAction.user = new User();
        this.testAction("user.male", false);
    }

    @Test
    public void action_boolean_false() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/hidden", null, null));
        editAction.user = new User();
        editAction.user.setMale(false);
        this.testAction("user.male", false);
    }

    @Test
    public void action_boolean_true() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/hidden", null, null));
        editAction.user = new User();
        editAction.user.setMale(true);
        this.testAction("user.male", true);
    }

    protected void testAction(String string, boolean bl) {
        new ControlBaseTest.ControlTester((Control)this.hidden).attr("name", string).attr("value", bl).go("<input type=\"hidden\" name=\"" + string + "@param\" value=\"param-value\"/>\n<input type=\"hidden\" id=\"" + string.replace(".", "_") + "\" name=\"" + string + "\" value=\"" + bl + "\"/>");
    }
}

