/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import com.google.inject.Inject;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.example.action.user.EditAction;
import org.example.domain.Action;
import org.example.domain.ActionField;
import org.example.domain.PreAndPostAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.config.AbstractMVCConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.parameter.DefaultParameterHandler;
import org.primeframework.mvc.parameter.DefaultParameterParser;
import org.primeframework.mvc.parameter.DefaultParameterWorkflow;
import org.primeframework.mvc.parameter.DefaultPostParameterHandler;
import org.primeframework.mvc.parameter.DefaultPostParameterWorkflow;
import org.primeframework.mvc.parameter.ParameterHandler;
import org.primeframework.mvc.parameter.ParameterParser;
import org.primeframework.mvc.parameter.PostParameterHandler;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.parameter.fileupload.annotation.FileUpload;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultParameterWorkflowTest
extends PrimeBaseTest {
    @Inject
    public CSRFProvider csrfProvider;
    @Inject
    public ExpressionEvaluator expressionEvaluator;

    public <T> T assertFile() {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(this){

            public void appendTo(StringBuffer stringBuffer) {
            }

            public boolean matches(Object object) {
                List list = (List)object;
                Assert.assertNotNull((Object)list);
                Assert.assertEquals((int)list.size(), (int)1);
                Assert.assertNotNull(list.getFirst());
                Assert.assertEquals((String)((FileInfo)list.getFirst()).contentType, (String)"text/plain");
                Assert.assertEquals((String)((FileInfo)list.getFirst()).fileName, (String)"test-file-upload.txt");
                Assert.assertEquals((String)((FileInfo)list.getFirst()).name, (String)"userfile");
                try {
                    Assert.assertEquals((String)Files.readString(((FileInfo)list.getFirst()).file), (String)"1234\n");
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return true;
            }
        });
        return null;
    }

    public <T> T captureMultiple() {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(this){

            public void appendTo(StringBuffer stringBuffer) {
            }

            public boolean matches(Object object) {
                List list = (List)object;
                Assert.assertNotNull((Object)list);
                Assert.assertEquals((int)list.size(), (int)2);
                Assert.assertNotNull(list.get(0));
                Assert.assertNotNull(list.get(1));
                Assert.assertEquals((String)((FileInfo)list.get((int)0)).contentType, (String)"text/plain");
                Assert.assertEquals((String)((FileInfo)list.get((int)1)).contentType, (String)"text/plain");
                Assert.assertEquals((String)((FileInfo)list.get((int)0)).fileName, (String)"test-file-upload.txt");
                Assert.assertEquals((String)((FileInfo)list.get((int)1)).fileName, (String)"test-file-upload2.txt");
                Assert.assertEquals((String)((FileInfo)list.get((int)0)).name, (String)"userfiles");
                Assert.assertEquals((String)((FileInfo)list.get((int)1)).name, (String)"userfiles");
                try {
                    Assert.assertEquals((String)Files.readString(((FileInfo)list.get((int)0)).file), (String)"1234\n");
                    Assert.assertEquals((String)Files.readString(((FileInfo)list.get((int)1)).file), (String)"1234\n");
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return true;
            }
        });
        return null;
    }

    @Test
    public void filesAnnotationContentTypeError() throws Exception {
        List<FileInfo> list = List.of(new FileInfo(Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]), "test-file-upload.txt", "userfile", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)0x100000L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn((Object)AbstractMVCConfiguration.ALLOWED_TYPES);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        final String[] stringArray = new String[]{"text/xml"};
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        actionInvocation.configuration.fileUploadMembers.put("userfile", new FileUpload(){

            public Class<? extends Annotation> annotationType() {
                return FileUpload.class;
            }

            public String[] contentTypes() {
                return stringArray;
            }

            public long maxSize() {
                return 10L;
            }
        });
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[fileUploadBadContentType]userfile", new Object[]{"userfile", "text/plain", stringArray})).andReturn((Object)"bar");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "userfile", "[fileUploadBadContentType]userfile", "bar");
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void filesAnnotationSizeError() throws Exception {
        List<FileInfo> list = List.of(new FileInfo(Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]), "test-file-upload.txt", "userfile", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)0x100000L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn((Object)AbstractMVCConfiguration.ALLOWED_TYPES);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        actionInvocation.configuration.fileUploadMembers.put("userfile", new FileUpload(this){

            public Class<? extends Annotation> annotationType() {
                return FileUpload.class;
            }

            public String[] contentTypes() {
                return new String[0];
            }

            public long maxSize() {
                return 1L;
            }
        });
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[fileUploadTooBig]userfile", new Object[]{"userfile", 5L, 1L})).andReturn((Object)"bar");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "userfile", "[fileUploadTooBig]userfile", "bar");
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void filesNoAnnotation() throws Exception {
        List<FileInfo> list = List.of(new FileInfo(Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]), "test-file-upload.txt", "userfile", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)1024000L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn(Set.of("text/plain"));
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"userfile"), EasyMock.same((Object)editAction), this.assertFile());
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void filesNoAnnotationContentTypeError() throws Exception {
        List<FileInfo> list = List.of(new FileInfo(Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]), "test-file-upload.txt", "userfile", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.POST);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        Set<String> set = Set.of("test/xml");
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)10L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn(set);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[fileUploadBadContentType]userfile", new Object[]{"userfile", "text/plain", set.toArray(new String[0])})).andReturn((Object)"bar");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "userfile", "[fileUploadBadContentType]userfile", "bar");
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void filesNoAnnotationSizeError() throws Exception {
        List<FileInfo> list = List.of(new FileInfo(Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]), "test-file-upload.txt", "userfile", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)1L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn((Object)AbstractMVCConfiguration.ALLOWED_TYPES);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[fileUploadTooBig]userfile", new Object[]{"userfile", 5L, 1L})).andReturn((Object)"bar");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "userfile", "[fileUploadTooBig]userfile", "bar");
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void imageSubmitButton() throws Exception {
        Action action = new Action();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("submit.x", List.of("1"));
        hashMap.put("submit.y", List.of("2"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(hashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createNiceMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"submit.x"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"1"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.expectLastCall().andThrow((Throwable)new ExpressionException("Not property x"));
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"submit.y"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"2"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.expectLastCall().andThrow((Throwable)new ExpressionException("Not property y"));
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(action, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, null, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, expressionEvaluator, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }

    @Test
    public void invalidParametersDev() throws Exception {
        Action action = new Action();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("user.age", List.of("32"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.age"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"32"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.expectLastCall().andThrow((Throwable)new ExpressionException());
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(action, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        try {
            defaultParameterWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{hTTPRequest, expressionEvaluator, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }

    @Test
    public void invalidParametersProduction() throws Exception {
        Action action = new Action();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("user.age", List.of("32"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.age"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"32"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.expectLastCall().andThrow((Throwable)new ExpressionException());
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(action, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, expressionEvaluator, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }

    @Test
    public void multipleFilesNoAnnotation() throws Exception {
        Path path = Paths.get("src/test/java/org/primeframework/mvc/parameter/test-file-upload.txt", new String[0]);
        List<FileInfo> list = List.of(new FileInfo(path, "test-file-upload.txt", "userfiles", "text/plain", StandardCharsets.UTF_8), new FileInfo(path, "test-file-upload2.txt", "userfiles", "text/plain", StandardCharsets.UTF_8));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(new HashMap());
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(list);
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.expect((Object)hTTPRequest.isMultipart()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.expect((Object)mVCConfiguration.fileUploadMaxSize()).andReturn((Object)1024000L);
        EasyMock.expect((Object)mVCConfiguration.fileUploadAllowedTypes()).andReturn(Set.of("text/plain"));
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        EditAction editAction = new EditAction();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"userfiles"), EasyMock.same((Object)editAction), this.captureMultiple());
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(editAction, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, mVCConfiguration, workflowChain, actionInvocationStore, expressionEvaluator, messageStore, messageProvider});
    }

    @Test
    public void preAndPost() throws Exception {
        PreAndPostAction preAndPostAction = new PreAndPostAction();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("preField", List.of("1"));
        hashMap.put("preProperty", List.of("Pre property"));
        hashMap.put("notPre", List.of("Not pre"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(hashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.expect((Object)hTTPRequest.getMethod()).andReturn((Object)HTTPMethod.GET);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ActionInvocation actionInvocation = this.makeActionInvocation(preAndPostAction, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(3);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, this.expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)preAndPostAction.preCalled);
        Assert.assertFalse((boolean)preAndPostAction.postCalled);
        DefaultPostParameterHandler defaultPostParameterHandler = new DefaultPostParameterHandler();
        DefaultPostParameterWorkflow defaultPostParameterWorkflow = new DefaultPostParameterWorkflow(actionInvocationStore, (PostParameterHandler)defaultPostParameterHandler);
        defaultPostParameterWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)preAndPostAction.postCalled);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }

    @Test
    public void radioButtonsCheckBoxes() throws Exception {
        Action action = new Action();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("__cb_user.checkbox['null']", List.of(""));
        hashMap.put("__cb_user.checkbox['default']", List.of("false"));
        hashMap.put("__rb_user.radio['null']", List.of(""));
        hashMap.put("__rb_user.radio['default']", List.of("false"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(hashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createNiceMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.checkbox['default']"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"false"}))), (Map)EasyMock.eq(new HashMap()));
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.radio['default']"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"false"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(action, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, expressionEvaluator, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }

    @Test
    public void simpleParameter_boolean() throws Exception {
        ActionField actionField = new ActionField();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("foo", List.of("true"));
        linkedHashMap.put("bar", List.of("false"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ActionInvocation actionInvocation = this.makeActionInvocation(actionField, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, this.expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
        Assert.assertTrue((boolean)actionField.foo);
        Assert.assertFalse((boolean)actionField.bar);
    }

    @Test
    public void simpleParameter_boolean_default() throws Exception {
        ActionField actionField = new ActionField();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ActionInvocation actionInvocation = this.makeActionInvocation(actionField, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, this.expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
        Assert.assertFalse((boolean)actionField.foo);
        Assert.assertFalse((boolean)actionField.bar);
    }

    @Test
    public void simpleParameter_boolean_in_baseClass() throws Exception {
        ActionField actionField = new ActionField();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("superFoo", List.of("true"));
        linkedHashMap.put("superBar", List.of("false"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ActionInvocation actionInvocation = this.makeActionInvocation(actionField, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, this.expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
        Assert.assertTrue((boolean)actionField.superFoo);
        Assert.assertFalse((boolean)actionField.superBar);
    }

    @Test
    public void simpleParameter_boolean_model_object() throws Exception {
        ActionField actionField = new ActionField();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("user.active", List.of("true"));
        linkedHashMap.put("user.bar", List.of("false"));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ActionInvocation actionInvocation = this.makeActionInvocation(actionField, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, this.expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
        Assert.assertTrue((boolean)actionField.user.active);
        Assert.assertFalse((boolean)actionField.user.bar);
    }

    @Test
    public void simpleParameters() throws Exception {
        Action action = new Action();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("user.addresses['home'].city", List.of("Boulder"));
        linkedHashMap.put("user.age", List.of("32"));
        linkedHashMap.put("user.age@dateFormat", List.of("MM/dd/yyyy"));
        linkedHashMap.put("user.inches", List.of("tall"));
        linkedHashMap.put("user.name", List.of(""));
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getParameters()).andReturn(linkedHashMap);
        EasyMock.expect((Object)hTTPRequest.getFiles()).andReturn(List.of());
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.addresses['home'].city"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"Boulder"}))), (Map)EasyMock.eq(new HashMap()));
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.age"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"32"}))), (Map)EasyMock.eq(Map.of("dateFormat", "MM/dd/yyyy")));
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.inches"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{"tall"}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.expectLastCall().andThrow((Throwable)new ConversionException());
        expressionEvaluator.setValue((String)EasyMock.eq((Object)"user.name"), EasyMock.same((Object)action), (String[])EasyMock.aryEq((Object[])((String[])ArrayUtils.toArray((Object[])new String[]{""}))), (Map)EasyMock.eq(new HashMap()));
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ActionInvocation actionInvocation = this.makeActionInvocation(action, HTTPMethod.POST, "");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.ignoreEmptyParameters()).andReturn((Object)false).times(4);
        EasyMock.expect((Object)mVCConfiguration.allowUnknownParameters()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[couldNotConvert]user.inches", new Object[]{"user.inches", "tall"})).andReturn((Object)"bar");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "user.inches", "[couldNotConvert]user.inches", "bar");
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{messageStore});
        DefaultParameterWorkflow defaultParameterWorkflow = new DefaultParameterWorkflow(actionInvocationStore, (ParameterParser)new DefaultParameterParser(mVCConfiguration, actionInvocationStore, this.csrfProvider, hTTPRequest), (ParameterHandler)new DefaultParameterHandler(mVCConfiguration, actionInvocationStore, expressionEvaluator, messageProvider, messageStore, hTTPRequest));
        defaultParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{hTTPRequest, expressionEvaluator, actionInvocationStore, messageStore, mVCConfiguration, workflowChain, messageProvider});
    }
}

