/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.example.action.user.EditAction;
import org.example.domain.Address;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Pair;
import org.primeframework.mvc.control.form.RadioList;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.util.MapBuilder;
import org.testng.annotations.Test;

public class RadioListTest
extends ControlBaseTest {
    @Inject
    public RadioList radioList;

    @Test
    public void action() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/radio-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"radio-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">Germany</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_user.addresses[&#39;work&#39;].country\" value=\"\"/>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/radio-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "test").attr("class", "css-class").attr("items", Arrays.asList("one", "two", "three")).go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-radio-list css-class-input css-class-control radio-list input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"one\" class=\"css-class\" name=\"test\"/><span class=\"radio-text\">one</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"two\" class=\"css-class\" name=\"test\"/><span class=\"radio-text\">two</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"three\" class=\"css-class\" name=\"test\"/><span class=\"radio-text\">three</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_test\" value=\"\"/>\n");
    }

    @Test
    public void expressions() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/radio-list", null, null));
        Pair pair = new Pair("US", "United States");
        Pair pair2 = new Pair("DE", "Germany");
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "user.addresses['work'].country").attr("valueExpr", "left").attr("textExpr", "right").attr("items", ArrayUtils.toArray((Object[])new Pair[]{pair, pair2})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"radio-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">Germany</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_user.addresses[&#39;work&#39;].country\" value=\"\"/>\n");
    }

    @Test
    public void fieldErrors() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/radio-list", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"radio-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\"><span class=\"error\">Country (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">Germany</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_user.addresses[&#39;work&#39;].country\" value=\"\"/>\n");
    }

    @Test
    public void html() {
        Address address = new Address();
        address.setCountry("<US>");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/radio-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"<US>", "<United States>", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"radio-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" checked=\"checked\" value=\"&lt;US&gt;\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">&lt;United States&gt;</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">Germany</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_user.addresses[&#39;work&#39;].country\" value=\"\"/>\n");
    }

    @Test
    public void uncheckedValue() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/radio-list", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.radioList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).attr("uncheckedValue", "US").go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"radio-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\"><span class=\"error\">Country (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"radio\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"radio\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"radio-text\">Germany</span>\n</div>\n</div>\n</div>\n<input type=\"hidden\" name=\"__rb_user.addresses[&#39;work&#39;].country\" value=\"US\"/>\n");
    }
}

