/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.example.action.user.EditAction;
import org.example.action.user.IndexAction;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Form;
import org.primeframework.mvc.util.MapBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FormTest
extends ControlBaseTest {
    @Inject
    Form form;

    @Test
    public void actionIsDifferentURI() {
        this.request.setPath("/user/");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, null));
        StringWriter stringWriter = new StringWriter();
        this.form.renderStart((Writer)stringWriter, MapBuilder.map((Object)"action", (Object)"/user/edit").put((Object)"method", (Object)"POST").done(), MapBuilder.map((Object)"param", (Object)"param-value").done());
        EditAction editAction = (EditAction)this.ais.getCurrent().action;
        Assert.assertTrue((boolean)editAction.formPrepared);
        this.form.renderEnd((Writer)stringWriter);
        Assert.assertSame(IndexAction.class, this.ais.getCurrent().action.getClass());
        Assert.assertEquals((String)stringWriter.toString(), (String)"<div class=\"form\">\n<form action=\"/user/edit\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void fullyQualifiedContextPath() {
        this.request.setPath("/context/user/");
        this.request.setContextPath("/context");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, new ActionConfiguration(IndexAction.class, false, null, null, null, new ArrayList(), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, null, "/user/", null, null, null, null)));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "https://www.google.com").attr("method", "POST").go("<div class=\"form\">\n<form action=\"https://www.google.com\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void noPrepare() {
        this.request.setPath("/user/");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, new ActionConfiguration(IndexAction.class, false, null, null, null, new ArrayList(), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, null, "/user/", null, null, null, null)));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "/user/").attr("method", "POST").go("<div class=\"form\">\n<form action=\"/user/\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void noPrepareContextPath() {
        this.request.setPath("/context/user/");
        this.request.setContextPath("/context");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, new ActionConfiguration(IndexAction.class, false, null, null, null, new ArrayList(), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, null, "/user/", null, null, null, null)));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "/user/").attr("method", "POST").go("<div class=\"form\">\n<form action=\"/context/user/\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void noPrepareFullyQualified() {
        this.request.setPath("/user/");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, new ActionConfiguration(IndexAction.class, false, null, null, null, new ArrayList(), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, null, "/user/", null, null, null, null)));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "https://www.google.com").attr("method", "POST").go("<div class=\"form\">\n<form action=\"https://www.google.com\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void noPrepareRelative() {
        this.request.setPath("/user/");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, null));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "edit").attr("method", "POST").go("<div class=\"form\">\n<form action=\"/user/edit\" method=\"POST\">\n</form>\n</div>\n");
    }

    @Test
    public void prepare() throws NoSuchMethodException {
        this.request.setPath("/user/edit");
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/user/edit", null, new ActionConfiguration(IndexAction.class, false, null, null, null, List.of(EditAction.class.getMethod("formPrepare", new Class[0])), null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, null, "/user/", null, null, null, null)));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "/user/edit").attr("method", "POST").go("<div class=\"form\">\n<form action=\"/user/edit\" method=\"POST\">\n</form>\n</div>\n");
        Assert.assertTrue((boolean)editAction.formPrepared);
    }

    @Test
    public void relativeContextPath() {
        this.request.setPath("/context/user/");
        this.request.setContextPath("/context");
        IndexAction indexAction = new IndexAction();
        this.ais.setCurrent(new ActionInvocation((Object)indexAction, null, "/user/", null, null));
        new ControlBaseTest.ControlTester((Control)this.form).attr("action", "edit").attr("method", "POST").go("<div class=\"form\">\n<form action=\"/context/user/edit\" method=\"POST\">\n</form>\n</div>\n");
    }
}

