/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Checkbox;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.testng.annotations.Test;

public class CheckboxTest
extends ControlBaseTest {
    @Inject
    public Checkbox checkbox;

    @Test
    public void action() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox", null, null));
        editAction.user = new User();
        editAction.user.setMale(true);
        this.testAction("user.male", true, "true");
        editAction.user.setMale(false);
        this.testAction("user.male", false, "true");
        editAction.user.setIntIDs(new int[]{1, 2, 3});
        this.testAction("user.intIDs", true, "1");
        this.testAction("user.intIDs", true, "2");
        this.testAction("user.intIDs", true, "3");
        this.testAction("user.intIDs", false, "4");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1");
        hashSet.add("2");
        hashSet.add("3");
        editAction.user.setSetIDs(hashSet);
        this.testAction("user.setIDs", true, "1");
        this.testAction("user.setIDs", true, "2");
        this.testAction("user.setIDs", true, "3");
        this.testAction("user.setIDs", false, "4");
        hashSet = new HashSet();
        hashSet.add("<br>");
        hashSet.add("<li>");
        hashSet.add("<td>");
        editAction.user.setSetIDs(hashSet);
        this.testAction("user.setIDs", true, "<br>");
        this.testAction("user.setIDs", true, "<li>");
        this.testAction("user.setIDs", true, "<td>");
        this.testAction("user.setIDs", false, "<table>");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.add(2);
        arrayList.add(3);
        editAction.user.setListIDs(arrayList);
        this.testAction("user.listIDs", true, "1");
        this.testAction("user.listIDs", true, "2");
        this.testAction("user.listIDs", true, "3");
        this.testAction("user.listIDs", false, "4");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/checkbox", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", "test").attr("value", "test-value").attr("required", true).attr("class", "css-class").go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-checkbox css-class-input css-class-control checkbox input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test<span class=\"required\">*</span></label></div>\n<div class=\"control-container\"><input type=\"checkbox\" class=\"css-class\" id=\"test\" name=\"test\" value=\"test-value\"/><input type=\"hidden\" name=\"__cb_test\" value=\"\"/></div>\n</div>\n");
    }

    @Test
    public void defaultChecked() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", "user.maleWrapper").attr("defaultChecked", true).attr("value", true).go("<input type=\"hidden\" name=\"user.maleWrapper@param\" value=\"param-value\"/>\n<div class=\"checkbox input control\">\n<div class=\"label-container\"><label for=\"user_maleWrapper\" class=\"label\">Male?</label></div>\n<div class=\"control-container\"><input type=\"checkbox\" checked=\"checked\" id=\"user_maleWrapper\" name=\"user.maleWrapper\" value=\"true\"/><input type=\"hidden\" name=\"__cb_user.maleWrapper\" value=\"\"/></div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.male", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.male", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", "user.male").attr("value", "true").go("<input type=\"hidden\" name=\"user.male@param\" value=\"param-value\"/>\n<div class=\"checkbox input control\">\n<div class=\"label-container\"><label for=\"user_male\" class=\"label\"><span class=\"error\">Male? (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\"><input type=\"checkbox\" id=\"user_male\" name=\"user.male\" value=\"true\"/><input type=\"hidden\" name=\"__cb_user.male\" value=\"\"/></div>\n</div>\n");
    }

    @Test
    public void hardCodedChecked() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", "user.male").attr("checked", true).attr("value", "true").go("<input type=\"hidden\" name=\"user.male@param\" value=\"param-value\"/>\n<div class=\"checkbox input control\">\n<div class=\"label-container\"><label for=\"user_male\" class=\"label\">Male?</label></div>\n<div class=\"control-container\"><input type=\"checkbox\" checked=\"checked\" id=\"user_male\" name=\"user.male\" value=\"true\"/><input type=\"hidden\" name=\"__cb_user.male\" value=\"\"/></div>\n</div>\n");
    }

    @Test
    public void uncheckedValue() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", "user.maleWrapper").attr("value", "true").attr("uncheckedValue", "false").go("<input type=\"hidden\" name=\"user.maleWrapper@param\" value=\"param-value\"/>\n<div class=\"checkbox input control\">\n<div class=\"label-container\"><label for=\"user_maleWrapper\" class=\"label\">Male?</label></div>\n<div class=\"control-container\"><input type=\"checkbox\" id=\"user_maleWrapper\" name=\"user.maleWrapper\" value=\"true\"/><input type=\"hidden\" name=\"__cb_user.maleWrapper\" value=\"false\"/></div>\n</div>\n");
    }

    protected void testAction(String string, boolean bl, String string2) {
        new ControlBaseTest.ControlTester((Control)this.checkbox).attr("name", string).attr("value", string2).go("<input type=\"hidden\" name=\"" + string + "@param\" value=\"param-value\"/>\n<div class=\"checkbox input control\">\n<div class=\"label-container\"><label for=\"" + string.replace(".", "_") + "\" class=\"label\">Male?</label></div>\n<div class=\"control-container\"><input type=\"checkbox\" " + (bl ? "checked=\"checked\" " : "") + "id=\"" + string.replace(".", "_") + "\" name=\"" + string + "\" value=\"" + string2.replace("<", "&lt;").replace(">", "&gt;") + "\"/><input type=\"hidden\" name=\"__cb_" + string + "\" value=\"\"/></div>\n</div>\n");
    }
}

