/*
 * Copyright (c) 2025, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.primeframework.mvc.test;

import javax.annotation.Nullable;

import io.fusionauth.http.HTTPMethod;

/**
 * Interface for generating DPoP Proofs. Allows one to plug in their
 * own DPoP Proof generation to HTTP requests in a test framework.
 */
public interface DPoPProofProvider {
  /**
   * Generates a DPoP Proof.
   * @param httpMethod  The HTTP Method. To be provided as the htm claim.
   * @param htu         The HTTP URI. To be provided as the htu claim.
   * @param accessToken (Optional) The access token. To be provided as the hashed ath claim.
   * @return The DPoP Proof to be used in the DPoP header.
   */
  String generateDPoPProof(HTTPMethod httpMethod, String htu, @Nullable String accessToken);
}
