/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import org.primeframework.mvc.workflow.TypedExceptionHandler;

public class TypedExceptionHandlerFactory {
    private static final Map<Class<? extends Throwable>, Class<? extends TypedExceptionHandler<? extends Throwable>>> handlers = new HashMap<Class<? extends Throwable>, Class<? extends TypedExceptionHandler<? extends Throwable>>>();
    private final Injector injector;

    @Inject
    public TypedExceptionHandlerFactory(Injector injector) {
        this.injector = injector;
    }

    public static <T extends Throwable, U extends TypedExceptionHandler<T>> void addExceptionHandler(Binder binder, Class<T> exceptionType, Class<U> handlerType) {
        binder.bind(handlerType);
        handlers.put(exceptionType, handlerType);
    }

    public <T extends Throwable, U extends TypedExceptionHandler<T>> U build(Class<T> exceptionType) {
        Class<? extends TypedExceptionHandler<? extends Throwable>> type = handlers.get(exceptionType);
        if (type == null) {
            return null;
        }
        return (U)((TypedExceptionHandler)this.injector.getInstance(type));
    }
}

