/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import io.fusionauth.http.ContentTooLargeException;
import io.fusionauth.http.HTTPProcessingException;
import io.fusionauth.http.UnprocessableContentException;
import io.fusionauth.http.server.HTTPResponse;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.workflow.TypedExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPProcessingExceptionHandler
implements TypedExceptionHandler<HTTPProcessingException> {
    private static final Logger logger = LoggerFactory.getLogger(HTTPProcessingExceptionHandler.class);
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final HTTPResponse response;
    private final ResultStore resultStore;

    @Inject
    public HTTPProcessingExceptionHandler(ResultStore resultStore, MessageStore messageStore, MessageProvider messageProvider, HTTPResponse response) {
        this.resultStore = resultStore;
        this.messageStore = messageStore;
        this.messageProvider = messageProvider;
        this.response = response;
    }

    @Override
    public void handle(HTTPProcessingException exception) {
        String code = this.getResultCode(exception);
        this.resultStore.set(code);
        this.response.setStatus(exception.getStatus());
        try {
            String messageCode = "[" + exception.getClass().getSimpleName() + "]";
            Object[] args = new Object[]{exception.getMessage()};
            String message = this.messageProvider.getMessage(messageCode, args);
            this.messageStore.add(new SimpleMessage(MessageType.ERROR, messageCode, message));
        }
        catch (MissingMessageException missingMessageException) {
            // empty catch block
        }
    }

    private String getResultCode(HTTPProcessingException exception) {
        if (exception.getClass() == ContentTooLargeException.class) {
            return "content-too-large";
        }
        if (exception.getClass() == UnprocessableContentException.class) {
            return "unprocessable-content";
        }
        logger.debug("Unexpected exception [{}]. Using [error] result code as a default.", exception.getClass());
        return "error";
    }
}

