/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.primeframework.mvc.parameter.annotation.FieldName;
import org.primeframework.mvc.parameter.el.BeanExpressionException;
import org.primeframework.mvc.parameter.el.CollectionExpressionException;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.parameter.el.ReadExpressionException;
import org.primeframework.mvc.parameter.el.UpdateExpressionException;

public class ReflectionUtils {
    private static final Map<Class<?>, Map<String, Field>> fieldCache = new WeakHashMap();
    private static final Map<Class<?>, Method[]> methods = new WeakHashMap();
    private static final Map<String, Package> packageCache = new WeakHashMap<String, Package>();
    private static final Map<Class<?>, Map<String, PropertyInfo>> propertyCache = new WeakHashMap();
    private static final Map<String, MethodInformationExtractor> verifiers = new HashMap<String, MethodInformationExtractor>();

    public static boolean areAnyAnnotationsPresent(Field field, List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static List<Field> findAllFieldsWithAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        Map<String, Field> fields = ReflectionUtils.findFields(type);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields.values()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    public static List<Field> findAllFieldsWithAnnotations(Class<?> type, List<Class<? extends Annotation>> annotations) {
        Map<String, Field> fields = ReflectionUtils.findFields(type);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        block0: for (Field field : fields.values()) {
            for (Class<? extends Annotation> annotation : annotations) {
                if (!field.isAnnotationPresent(annotation)) continue;
                fieldList.add(field);
                continue block0;
            }
        }
        return fieldList;
    }

    public static Set<String> findAllMembers(Class<?> type) {
        Map<String, Field> fields = ReflectionUtils.findFields(type);
        Map<String, PropertyInfo> map = ReflectionUtils.findPropertyInfo(type);
        HashSet<String> names = new HashSet<String>(fields.keySet());
        names.addAll(map.keySet());
        return names;
    }

    public static <T extends Annotation> Map<String, T> findAllMembersWithAnnotation(Class<?> type, Class<T> annotation) {
        HashMap<String, T> annotations = new HashMap<String, T>();
        List<Field> fields = ReflectionUtils.findAllFieldsWithAnnotation(type, annotation);
        for (Field field : fields) {
            annotations.put(field.getName(), field.getAnnotation(annotation));
        }
        Map<String, PropertyInfo> properties = ReflectionUtils.findPropertyInfo(type);
        block1: for (String property : properties.keySet()) {
            Map<String, Method> methods = properties.get(property).getMethods();
            for (Method method : methods.values()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                annotations.put(property, method.getAnnotation(annotation));
                continue block1;
            }
        }
        return annotations;
    }

    public static List<Method> findAllMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        Method[] methods = ReflectionUtils.findMethods(type);
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methodList.add(method);
        }
        return methodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Field> findFields(Class<?> type) {
        Map<String, Field> fieldMap;
        Map<Class<?>, Map<String, Field>> map = fieldCache;
        synchronized (map) {
            fieldMap = fieldCache.get(type);
            if (fieldMap != null) {
                return fieldMap;
            }
            fieldMap = new HashMap<String, Field>();
            Field[] fields = type.getFields();
            ArrayList<Field> namedFields = new ArrayList<Field>(2);
            for (Field field : fields) {
                if (field.isAnnotationPresent(FieldName.class)) {
                    namedFields.add(field);
                    continue;
                }
                fieldMap.put(field.getName(), field);
            }
            for (Field field : namedFields) {
                String name = field.getAnnotation(FieldName.class).value();
                if (fieldMap.containsKey(name)) {
                    throw new BeanExpressionException("Invalid JavaBean class [" + String.valueOf(type) + "]. Errors are:\n[A field annotated with " + FieldName.class.getSimpleName() + "] and value of [" + name + "] effectively duplicates the existing field of the same name. Rename or remove the duplicate field.]");
                }
                fieldMap.put(name, field);
            }
            fieldCache.put(type, Collections.unmodifiableMap(fieldMap));
        }
        return fieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method[] findMethods(Class<?> type) {
        Map<Class<?>, Method[]> map = methods;
        synchronized (map) {
            Method[] array = methods.get(type);
            if (array == null) {
                array = type.getMethods();
                array = (Method[])Arrays.stream(array).map(m -> new SortableMethod((Method)m, type)).sorted().map(sm -> sm.method).toArray(Method[]::new);
                methods.put(type, array);
                return array;
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Package findPackageWithAnnotation(String packageName, Class<? extends Annotation> annotation) {
        Package pkg;
        Map<String, Package> map = packageCache;
        synchronized (map) {
            pkg = packageCache.get(packageName);
            if (pkg == null && (pkg = Package.getPackage(packageName)) != null) {
                packageCache.put(packageName, pkg);
            }
        }
        return pkg != null && pkg.isAnnotationPresent(annotation) ? pkg : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PropertyInfo> findPropertyInfo(Class<?> type) {
        Map<String, PropertyInfo> propMap;
        Map<Class<?>, Map<String, PropertyInfo>> map = propertyCache;
        synchronized (map) {
            propMap = propertyCache.get(type);
            if (propMap != null) {
                return propMap;
            }
            propMap = new HashMap<String, PropertyInfo>();
            HashSet<CallSite> errors = new HashSet<CallSite>();
            Method[] methods = ReflectionUtils.findMethods(type);
            for (Method method : methods) {
                Method existingMethod;
                String prefix;
                PropertyName name;
                if (method.isBridge()) continue;
                PropertyName propertyName = name = method.isAnnotationPresent(FieldName.class) ? new PropertyName("set", method.getAnnotation(FieldName.class).value()) : ReflectionUtils.getPropertyNames(method.getName());
                if (name == null) continue;
                PropertyInfo info = propMap.get(name.getName());
                boolean constructed = false;
                if (info == null) {
                    info = new PropertyInfo();
                    info.setName(name.getName());
                    info.setDeclaringClass(method.getDeclaringClass());
                    constructed = true;
                }
                if ((prefix = name.getPrefix()).equals("is")) {
                    prefix = "get";
                }
                if ((existingMethod = info.getMethods().get(prefix)) != null) {
                    errors.add((CallSite)((Object)("Two or more [" + prefix + "] methods named [" + existingMethod.getName() + "] exist. Rename or remove the duplicate method.")));
                    continue;
                }
                MethodInformationExtractor verifier = verifiers.get(prefix);
                if (verifier == null) continue;
                info.getMethods().put(prefix, method);
                info.setGenericType(verifier.determineGenericType(method));
                info.setType(verifier.determineType(method));
                info.setIndexed(verifier.isIndexed(method));
                if (!constructed) continue;
                propMap.put(name.getName(), info);
            }
            for (PropertyInfo info : propMap.values()) {
                Method read = info.getMethods().get("get");
                Method write = info.getMethods().get("set");
                if (read != null && ReflectionUtils.isValidGetter(read)) {
                    if (info.isIndexed()) {
                        errors.add((CallSite)((Object)("Invalid property named [" + info.getName() + "]. It mixes indexed and normal JavaBean methods.")));
                    }
                } else if (read != null && ReflectionUtils.isValidIndexedGetter(read)) {
                    if (!info.isIndexed() && write != null) {
                        errors.add((CallSite)((Object)("Invalid property named [" + info.getName() + "]. It mixes indexed and normal JavaBean methods.")));
                    }
                } else if (read != null) {
                    errors.add((CallSite)((Object)("Invalid getter method for property named [" + info.getName() + "]")));
                }
                if (write != null && ReflectionUtils.isValidSetter(write)) {
                    if (info.isIndexed()) {
                        errors.add((CallSite)((Object)("Invalid property named [" + info.getName() + "]. It mixes indexed and normal JavaBean methods.")));
                    }
                } else if (write != null && ReflectionUtils.isValidIndexedSetter(write)) {
                    if (!info.isIndexed() && read != null) {
                        errors.add((CallSite)((Object)("Invalid property named [" + info.getName() + "]. It mixes indexed and normal JavaBean methods.")));
                    }
                } else if (write != null) {
                    errors.add((CallSite)((Object)("Invalid setter method for property named [" + info.getName() + "]")));
                }
                if (read == null || write == null || (!info.isIndexed() || read.getReturnType() == write.getParameterTypes()[1]) && (info.isIndexed() || read.getReturnType() == write.getParameterTypes()[0])) continue;
                errors.add((CallSite)((Object)("Invalid getter/setter pair for JavaBean property named [" + info.getName() + "] in class [" + String.valueOf(write.getDeclaringClass()) + "]. The return type and parameter types must be identical")));
            }
            if (errors.size() > 0) {
                throw new BeanExpressionException("Invalid JavaBean class [" + String.valueOf(type) + "]. Errors are:\n" + String.valueOf(errors));
            }
            propertyCache.put(type, Collections.unmodifiableMap(propMap));
        }
        return propMap;
    }

    public static Object getField(Field field, Object object) throws ExpressionException {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException iae) {
            throw new ReadExpressionException("Illegal access for field [" + String.valueOf(field) + "]", iae);
        }
        catch (IllegalArgumentException iare) {
            throw new ReadExpressionException("Illegal argument for field [" + String.valueOf(field) + "]", iare);
        }
    }

    public static Class<?> getMemberType(Class<?> type, String member) {
        Field field = ReflectionUtils.findFields(type).get(member);
        if (field != null) {
            return field.getType();
        }
        PropertyInfo propertyInfo = ReflectionUtils.findPropertyInfo(type).get(member);
        if (propertyInfo != null) {
            return propertyInfo.getType();
        }
        return null;
    }

    public static <T> T invoke(Method method, Object obj, Object ... params) {
        try {
            return (T)method.invoke(obj, params);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "] because it isn't accessible", e);
        }
        catch (IllegalArgumentException e) {
            throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "] because the incorrect parameters were passed to it", e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "]", e);
        }
    }

    public static void invokeAll(Object obj, List<Method> methods) {
        for (Method method : methods) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "] because it isn't accessible", e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "]", e);
            }
        }
    }

    public static Object invokeGetter(Method method, Object object) throws RuntimeException, Error {
        return ReflectionUtils.invoke(method, object, new Object[0]);
    }

    public static void invokeSetter(Method method, Object object, Object value) throws RuntimeException, Error {
        Class<?>[] types = method.getParameterTypes();
        if (types.length != 1) {
            throw new UpdateExpressionException("Invalid method [" + String.valueOf(method) + "] it should take a single parameter");
        }
        Class<?> type = types[0];
        if (!type.isInstance(value) && value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.size() == 1) {
                value = c.iterator().next();
            } else {
                throw new ExpressionException("Cannot set a Collection that contains multiple values into the method [" + String.valueOf(method) + "] which is not a collection.");
            }
        }
        ReflectionUtils.invoke(method, object, value);
    }

    public static boolean isValidGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static boolean isValidIndexedGetter(Method method) {
        return method.getParameterTypes().length == 1 && method.getReturnType() != Void.TYPE;
    }

    public static boolean isValidIndexedSetter(Method method) {
        return method.getParameterTypes().length == 2;
    }

    public static boolean isValidSetter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    public static void setField(Field field, Object object, Object value) throws ExpressionException {
        boolean valueIsCollection;
        Class<?> fieldType = field.getType();
        boolean valueIsArray = value != null && value.getClass().isArray();
        boolean fieldIsCollection = Collection.class.isAssignableFrom(field.getType());
        boolean bl = valueIsCollection = value != null && Collection.class.isAssignableFrom(value.getClass());
        if (!fieldType.isInstance(value) && valueIsCollection && !fieldIsCollection) {
            Collection c = (Collection)value;
            if (c.size() == 1) {
                value = c.iterator().next();
            } else {
                throw new CollectionExpressionException("Cannot set a Collection that contains multiple values into the field [" + String.valueOf(field) + "] which is not a collection.");
            }
        }
        boolean coercionEligible = Modifier.isFinal(field.getModifiers()) || !fieldType.isInstance(value);
        boolean fieldAndValueAreCollectionCompatible = fieldIsCollection && (valueIsArray || valueIsCollection);
        try {
            if (coercionEligible && fieldAndValueAreCollectionCompatible) {
                Collection collection = (Collection)field.get(object);
                if (collection == null) {
                    collection = (Collection)fieldType.newInstance();
                } else {
                    collection.clear();
                }
                if (value.getClass().isArray()) {
                    collection.addAll(Arrays.asList((Object[])value));
                } else {
                    collection.addAll((Collection)value);
                }
            } else {
                field.set(object, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new UpdateExpressionException("Illegal access for field [" + String.valueOf(field) + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new UpdateExpressionException("Illegal argument for field [" + String.valueOf(field) + "]", e);
        }
        catch (InstantiationException e) {
            throw new UpdateExpressionException("Instantiation exception for field [" + String.valueOf(field) + "]", e);
        }
    }

    private static Set<Class<?>> allInterfaces(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        HashSet set = new HashSet(Arrays.asList(interfaces));
        for (Class<?> anInterface : interfaces) {
            set.addAll(ReflectionUtils.allInterfaces(anInterface));
        }
        return set;
    }

    private static boolean declaredOnImplementedInterface(Method method, Class<?> target) {
        if (!method.isDefault()) {
            return false;
        }
        Class<?> declaringType = method.getDeclaringClass();
        Set<Class<?>> interfaces = ReflectionUtils.allInterfaces(target);
        return interfaces.contains(declaringType);
    }

    private static PropertyName getPropertyNames(String name) {
        char c;
        char[] ca = name.toCharArray();
        int startIndex = -1;
        for (int i = 0; !(i >= ca.length || Character.isUpperCase(c = ca[i]) && i == 0); ++i) {
            if (!Character.isUpperCase(c)) continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            return null;
        }
        String propertyName = Introspector.decapitalize(name.substring(startIndex));
        String prefix = name.substring(0, startIndex);
        return new PropertyName(prefix, propertyName);
    }

    static {
        verifiers.put("is", new GetMethodInformationExtractor());
        verifiers.put("get", new GetMethodInformationExtractor());
        verifiers.put("set", new SetMethodInformationExtractor());
    }

    public static class PropertyInfo {
        private final Map<String, Method> methods = new HashMap<String, Method>();
        private Class<?> declaringClass;
        private Type genericType;
        private boolean indexed;
        private String name;
        private Class<?> type;

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public void setDeclaringClass(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public void setGenericType(Type genericType) {
            this.genericType = genericType;
        }

        public Map<String, Method> getMethods() {
            return this.methods;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public String toString() {
            return "Property named [" + this.name + "] in class [" + String.valueOf(this.declaringClass) + "]";
        }
    }

    public static class PropertyName {
        private final String name;
        private final String prefix;

        public PropertyName(String prefix, String name) {
            this.prefix = prefix;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static interface MethodInformationExtractor {
        public Type determineGenericType(Method var1);

        public Class<?> determineType(Method var1);

        public boolean isIndexed(Method var1);
    }

    public static class SortableMethod
    implements Comparable<SortableMethod> {
        private final int depth;
        private final Method method;

        public SortableMethod(Method method, Class<?> targetType) {
            this.method = method;
            int depth = 0;
            Class<?> declaringType = method.getDeclaringClass();
            while (declaringType != targetType && !ReflectionUtils.declaredOnImplementedInterface(method, targetType) && targetType != null) {
                targetType = targetType.getSuperclass();
                ++depth;
            }
            this.depth = depth;
        }

        @Override
        public int compareTo(SortableMethod o) {
            if (this.depth == o.depth) {
                return this.method.getName().compareTo(o.method.getName());
            }
            return o.depth - this.depth;
        }
    }

    public static class GetMethodInformationExtractor
    implements MethodInformationExtractor {
        @Override
        public Type determineGenericType(Method method) {
            return method.getGenericReturnType();
        }

        @Override
        public Class<?> determineType(Method method) {
            return method.getReturnType();
        }

        @Override
        public boolean isIndexed(Method method) {
            return ReflectionUtils.isValidIndexedGetter(method);
        }
    }

    public static class SetMethodInformationExtractor
    implements MethodInformationExtractor {
        @Override
        public Type determineGenericType(Method method) {
            Type[] types = method.getGenericParameterTypes();
            if (types.length == 0) {
                throw new ExpressionException("Unable to call method [" + String.valueOf(method) + "] because while the name indicates it is a setter, the method has 0 arguments. You need to add 1 or more arguments, or rename this method.");
            }
            if (types.length == 1) {
                return types[0];
            }
            return types[1];
        }

        @Override
        public Class<?> determineType(Method method) {
            return this.isIndexed(method) ? method.getParameterTypes()[1] : method.getParameterTypes()[0];
        }

        @Override
        public boolean isIndexed(Method method) {
            return ReflectionUtils.isValidIndexedSetter(method);
        }
    }
}

