/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.primeframework.mvc.action.annotation.URIModifier;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.util.URIBuilder;

public class DefaultURIBuilder
implements URIBuilder {
    @Override
    public String build(Class<?> type) {
        String rawURI = this.getURIFromActionClass(type);
        char[] ca = rawURI.toCharArray();
        StringBuilder build = new StringBuilder("" + ca[0]);
        boolean lower = true;
        boolean previousWasCharacter = false;
        for (int i = 1; i < ca.length; ++i) {
            char c = ca[i];
            if (Character.isUpperCase(c) && previousWasCharacter && lower) {
                build.append("-");
                lower = false;
            } else if (Character.isUpperCase(c) && previousWasCharacter) {
                if (i + 1 < ca.length && Character.isLowerCase(ca[i + 1])) {
                    build.append("-");
                }
            } else if (!Character.isUpperCase(c)) {
                lower = true;
            }
            build.append(c);
            previousWasCharacter = Character.isJavaIdentifierPart(c);
        }
        return build.toString().toLowerCase(Locale.ROOT);
    }

    private String getPackageName(String fqClassName, int index) {
        int lastDot = fqClassName.lastIndexOf(".");
        while (index > 0) {
            lastDot = fqClassName.lastIndexOf(46, lastDot - 1);
            --index;
        }
        return lastDot == -1 ? null : fqClassName.substring(0, lastDot);
    }

    private String getURIFromActionClass(Class<?> type) {
        int startIndex;
        String fullName = type.getName();
        if (fullName.endsWith("Action")) {
            fullName = fullName.substring(0, fullName.length() - 6);
        }
        int index = fullName.indexOf("action");
        String lessPackage = fullName.substring(index + 6).replace('.', '/');
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(lessPackage.substring(1).split("/")));
        for (int partIndex = startIndex = parts.size() - 2; partIndex >= 0; --partIndex) {
            int packageIndex = startIndex - partIndex;
            String packageName = this.getPackageName(fullName, packageIndex);
            Package pkg = ReflectionUtils.findPackageWithAnnotation(packageName, URIModifier.class);
            if (pkg == null) continue;
            URIModifier packageModifier = pkg.getAnnotation(URIModifier.class);
            parts.set(partIndex, packageModifier.value());
        }
        return "/" + String.join((CharSequence)"/", parts);
    }
}

