/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Base64;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.Compressor;
import org.primeframework.mvc.util.ThrowingFunction;

public final class CookieTools {
    public static final int HIGHEST_BIT_MASK = 3;

    @Deprecated(forRemoval=true, since="4.23.0")
    public static <T> T fromCookie(String value, boolean encryptedIfOld, Encryptor encryptor, ThrowingFunction<byte[], T> oldFunction, ThrowingFunction<byte[], T> newFunction) throws Exception {
        return CookieTools.fromCookie(value, false, encryptedIfOld, encryptor, oldFunction, newFunction);
    }

    public static <T> T fromCookie(String value, boolean encryptionRequired, boolean encryptedIfOld, Encryptor encryptor, ThrowingFunction<byte[], T> oldFunction, ThrowingFunction<byte[], T> newFunction) throws Exception {
        if (value == null || value.isBlank()) {
            return null;
        }
        byte[] result = Base64.getUrlDecoder().decode(value);
        if (result.length < 5) {
            if (encryptedIfOld) {
                result = encryptor.decrypt(result);
            }
            return oldFunction.apply(result);
        }
        if (result[0] != 66 || result[1] != 66 || result[2] != 66 || result[3] > 3) {
            if (encryptedIfOld) {
                result = encryptor.decrypt(result);
            }
            return oldFunction.apply(result);
        }
        boolean encrypt = (result[3] & 1) == 1;
        boolean compress = (result[3] & 2) == 2;
        result = Arrays.copyOfRange(result, 4, result.length);
        if (encryptionRequired && !encrypt) {
            throw new IllegalStateException("Encryption is required to decrypt cookie but a non-encrypted cookie was presented");
        }
        if (encrypt) {
            result = encryptor.decrypt(result);
        }
        if (compress) {
            result = Compressor.decompress(result);
        }
        return newFunction.apply(result);
    }

    @Deprecated(forRemoval=true, since="4.23.0")
    public static <T> T fromJSONCookie(String value, TypeReference<T> type, boolean encryptedIfOld, Encryptor encryptor, ObjectMapper objectMapper) throws Exception {
        ThrowingFunction<byte[], Object> read = r -> objectMapper.readerFor(type).readValue(r);
        return (T)CookieTools.fromCookie(value, false, encryptedIfOld, encryptor, read, read);
    }

    public static <T> T fromJSONCookie(String value, TypeReference<T> type, boolean encryptionRequired, boolean encryptedIfOld, Encryptor encryptor, ObjectMapper objectMapper) throws Exception {
        ThrowingFunction<byte[], Object> read = r -> objectMapper.readerFor(type).readValue(r);
        return (T)CookieTools.fromCookie(value, encryptionRequired, encryptedIfOld, encryptor, read, read);
    }

    @Deprecated(forRemoval=true, since="4.23.0")
    public static <T> T fromJSONCookie(String value, Class<T> type, boolean encryptedIfOld, Encryptor encryptor, ObjectMapper objectMapper) throws Exception {
        ThrowingFunction<byte[], Object> read = r -> objectMapper.readerFor(type).readValue(r);
        return (T)CookieTools.fromCookie(value, false, encryptedIfOld, encryptor, read, read);
    }

    public static <T> T fromJSONCookie(String value, Class<T> type, boolean encryptionRequired, boolean encryptedIfOld, Encryptor encryptor, ObjectMapper objectMapper) throws Exception {
        ThrowingFunction<byte[], Object> read = r -> objectMapper.readerFor(type).readValue(r);
        return (T)CookieTools.fromCookie(value, encryptionRequired, encryptedIfOld, encryptor, read, read);
    }

    public static String toCookie(byte[] value, boolean compress, boolean encrypt, Encryptor encryptor) throws Exception {
        byte[] header;
        if (compress) {
            value = Compressor.compress(value);
        }
        if (encrypt) {
            value = encryptor.encrypt(value);
        }
        header = new byte[]{66, 66, 66, (byte)(header[3] | (encrypt ? (byte)1 : 0))};
        header[3] = (byte)(header[3] | (compress ? 2 : 0));
        byte[] buf = new byte[value.length + 4];
        System.arraycopy(header, 0, buf, 0, header.length);
        System.arraycopy(value, 0, buf, 4, value.length);
        return Base64.getUrlEncoder().encodeToString(buf);
    }

    public static String toJSONCookie(Object value, boolean compress, boolean encrypt, Encryptor encryptor, ObjectMapper objectMapper) throws Exception {
        if (value == null) {
            return null;
        }
        byte[] result = objectMapper.writeValueAsBytes(value);
        return CookieTools.toCookie(result, compress, encrypt, encryptor);
    }
}

