/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.net.URI;
import java.util.Set;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.http.HTTPTools;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.UnauthorizedException;
import org.primeframework.mvc.security.UserLoginConstraintsValidator;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.csrf.CSRFProvider;

public class UserLoginSecurityScheme
implements SecurityScheme {
    protected Set<HTTPMethod> unsafeHttpMethods = Set.of(HTTPMethod.POST, HTTPMethod.PUT, HTTPMethod.PATCH, HTTPMethod.DELETE);
    private final MVCConfiguration configuration;
    private final UserLoginConstraintsValidator constraintsValidator;
    private final CSRFProvider csrfProvider;
    private final HTTPMethod method;
    private final HTTPRequest request;
    private UserLoginSecurityContext userLoginSecurityContext;

    @Inject
    public UserLoginSecurityScheme(MVCConfiguration configuration, UserLoginConstraintsValidator constraintsValidator, CSRFProvider csrfProvider, HTTPRequest request, HTTPMethod method) {
        this.configuration = configuration;
        this.constraintsValidator = constraintsValidator;
        this.csrfProvider = csrfProvider;
        this.request = request;
        this.method = method;
    }

    @Override
    public void handle(String[] constraints) {
        if (this.userLoginSecurityContext == null) {
            return;
        }
        if (!this.userLoginSecurityContext.isLoggedIn()) {
            throw new UnauthenticatedException();
        }
        if (!this.constraintsValidator.validate(constraints)) {
            throw new UnauthorizedException();
        }
        if (!this.configuration.csrfEnabled()) {
            return;
        }
        if (this.unsafeHttpMethods.contains(this.method)) {
            String source = HTTPTools.getOriginHeader(this.request);
            if (source == null) {
                throw new UnauthorizedException();
            }
            URI uri = URI.create(this.request.getBaseURL());
            URI sourceURI = URI.create(source);
            if (uri.getPort() != sourceURI.getPort() || !uri.getScheme().equalsIgnoreCase(sourceURI.getScheme()) || !uri.getHost().equalsIgnoreCase(sourceURI.getHost())) {
                throw new UnauthorizedException();
            }
            if (!this.csrfProvider.validateRequest(this.request)) {
                throw new UnauthorizedException();
            }
        }
    }

    @Inject(optional=true)
    public void setUserLoginSecurityContext(UserLoginSecurityContext userLoginSecurityContext) {
        this.userLoginSecurityContext = userLoginSecurityContext;
    }
}

