/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import org.primeframework.mvc.action.result.SavedRequestTools;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.SavedRequestWorkflow;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultSavedRequestWorkflow
implements SavedRequestWorkflow {
    private final MVCConfiguration configuration;
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;
    private final HTTPRequest request;
    private final HTTPResponse response;

    @Inject
    public DefaultSavedRequestWorkflow(MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper, HTTPRequest request, HTTPResponse response) {
        this.objectMapper = objectMapper;
        this.request = request;
        this.encryptor = encryptor;
        this.configuration = configuration;
        this.response = response;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        SavedRequestTools.SaveHttpRequestResult result = SavedRequestTools.getSaveRequestForWorkflow(this.configuration, this.encryptor, this.objectMapper, this.request, this.response);
        if (result != null) {
            this.request.setPath(result.savedHttpRequest.uri);
            this.request.setMethod(result.savedHttpRequest.method);
            this.request.getParameters().putAll(result.savedHttpRequest.parameters);
        }
        workflowChain.continueWorkflow();
    }
}

