/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.scope.Scope;
import org.primeframework.mvc.scope.ScopeField;
import org.primeframework.mvc.scope.ScopeProvider;
import org.primeframework.mvc.scope.ScopeStorageWorkflow;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultScopeStorageWorkflow
implements ScopeStorageWorkflow {
    private final ActionInvocationStore actionInvocationStore;
    private final ScopeProvider scopeProvider;

    @Inject
    public DefaultScopeStorageWorkflow(ActionInvocationStore actionInvocationStore, ScopeProvider scopeProvider) {
        this.actionInvocationStore = actionInvocationStore;
        this.scopeProvider = scopeProvider;
    }

    @Override
    public void perform(WorkflowChain chain) throws IOException {
        List<ScopeField> scopeFields;
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        List<ScopeField> list = scopeFields = actionConfiguration != null ? actionConfiguration.scopeFields : null;
        if (action != null && scopeFields != null && scopeFields.size() > 0) {
            this.storeScopedMembers(action, scopeFields);
        }
        chain.continueWorkflow();
    }

    protected void storeScopedMembers(Object action, List<ScopeField> scopeFields) {
        for (ScopeField scopeField : scopeFields) {
            Scope scope = this.scopeProvider.lookup(scopeField.annotationType);
            Object value = ReflectionUtils.getField(scopeField.field, action);
            scope.set(scopeField.field.getName(), value, scopeField.annotation);
        }
    }
}

