/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.util.Map;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.AbstractPrimitiveConverter;

@GlobalConverter
public class BooleanConverter
extends AbstractPrimitiveConverter {
    @Inject
    public BooleanConverter(MVCConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Object defaultPrimitive(Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        return Boolean.FALSE;
    }

    @Override
    protected String primitiveToString(Object value, Class convertFrom, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        return value.toString();
    }

    @Override
    protected Object stringToPrimitive(String value, Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        if (!(value.equals("true") || value.equals("false") || value.equals("on") || value.equals("off") || value.equals("yes") || value.equals("no"))) {
            throw new ConversionException("Unable to convert invalid boolean String [" + value + "]");
        }
        return value.equals("true") || value.equals("on") || value.equals("yes");
    }
}

