/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GuiceTools {
    public static <T> List<Key<? extends T>> getKeys(Injector injector, Class<T> type) {
        Map bindings = injector.getBindings();
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        for (Key key : bindings.keySet()) {
            Class bindingType;
            Type t = key.getTypeLiteral().getType();
            if (t instanceof ParameterizedType) {
                t = ((ParameterizedType)t).getRawType();
            }
            if (!(t instanceof Class) || !type.isAssignableFrom(bindingType = (Class)t)) continue;
            results.add(key);
        }
        return results;
    }

    public static <T> List<Class<? extends T>> getTypes(Injector injector, Class<T> type) {
        List<Key<T>> keys = GuiceTools.getKeys(injector, type);
        ArrayList<Class<T>> types = new ArrayList<Class<T>>();
        for (Key<T> key : keys) {
            types.add((Class)key.getTypeLiteral().getType());
        }
        return types;
    }
}

