/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import io.fusionauth.http.HTTPMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.content.json.annotation.JSONPatch;
import org.primeframework.mvc.content.json.annotation.JSONPropertyFilter;
import org.primeframework.mvc.content.json.annotation.JSONRequest;
import org.primeframework.mvc.content.json.annotation.JSONResponse;
import org.primeframework.mvc.util.ReflectionUtils;

public class JacksonActionConfigurator
implements ActionConfigurator {
    @Override
    public Object configure(Class<?> actionClass) {
        List<Method> jsonFilterMethods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, JSONPropertyFilter.class);
        Map<String, JSONRequest> jsonRequestMember = ReflectionUtils.findAllMembersWithAnnotation(actionClass, JSONRequest.class);
        Map<String, JSONPatch> jsonPatchRequestMember = ReflectionUtils.findAllMembersWithAnnotation(actionClass, JSONPatch.class);
        Map<String, JSONResponse> jsonResponseMembers = ReflectionUtils.findAllMembersWithAnnotation(actionClass, JSONResponse.class);
        if (jsonResponseMembers.size() > 1) {
            throw new IllegalArgumentException("Action class [" + String.valueOf(actionClass) + "] contains multiple fields with the @JSONResponse annotation. This annotation should only exist on a single field.");
        }
        if (jsonFilterMethods.size() > 1) {
            throw new IllegalArgumentException("Action class [" + String.valueOf(actionClass) + "] contains multiple fields with the @JSONPropertyFilter annotation. This annotation should only exist on a single method.");
        }
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> configuredMembers = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>(4);
        for (Map.Entry<String, JSONRequest> requestMember : jsonRequestMember.entrySet()) {
            String[] httpMethods;
            String memberName = requestMember.getKey();
            for (String method : httpMethods = requestMember.getValue().httpMethods()) {
                HTTPMethod httpMethod = HTTPMethod.of((String)method);
                if (configuredMembers.containsKey(httpMethod)) {
                    throw new IllegalArgumentException("Action class [" + String.valueOf(actionClass) + "] contains multiple fields with the @JSONRequest annotation and they are not distinct for HTTPMethod [ " + String.valueOf(httpMethod) + "]. This annotation should only exist on a single field for a particular HTTP Method.");
                }
                JSONPatch jsonPatch = httpMethod == HTTPMethod.PATCH ? jsonPatchRequestMember.get(memberName) : null;
                configuredMembers.put(httpMethod, new JacksonActionConfiguration.RequestMember(memberName, ReflectionUtils.getMemberType(actionClass, memberName), jsonPatch));
            }
            if (!jsonPatchRequestMember.containsKey(memberName) || !Arrays.stream(httpMethods).noneMatch(m -> m.equals(HTTPMethod.PATCH.name()))) continue;
            throw new IllegalArgumentException("Action class [" + String.valueOf(actionClass) + "] contains a field annotated with the @JSONRequest annotation and the @JSONPatch annotation, and is not enabled for the PATCH HTTP Method. In order to use the @JSONPatch annotation, you will need to enable the PATCH HTTP Method on the @JSONRequest annotation.");
        }
        Map.Entry<String, JSONResponse> entry = jsonResponseMembers.size() == 1 ? jsonResponseMembers.entrySet().iterator().next() : null;
        JacksonActionConfiguration.ResponseMember responseMember = null;
        if (entry != null) {
            responseMember = new JacksonActionConfiguration.ResponseMember(entry.getValue(), entry.getKey());
        }
        JacksonActionConfiguration.JSONPropertyFilterConfig jsonFilterConfig = null;
        if (jsonFilterMethods.size() > 0) {
            Method method = jsonFilterMethods.get(0);
            JSONPropertyFilter annotation = method.getAnnotation(JSONPropertyFilter.class);
            jsonFilterConfig = new JacksonActionConfiguration.JSONPropertyFilterConfig(method, annotation.value(), annotation.mixinSource(), annotation.mixinTarget());
        }
        if (!configuredMembers.isEmpty() || responseMember != null) {
            return new JacksonActionConfiguration(configuredMembers, responseMember, jsonFilterConfig);
        }
        return null;
    }
}

