/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.guice;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.content.guice.JacksonModule;

public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final MVCConfiguration configuration;
    private final Set<Module> jacksonModules;

    @Inject
    public ObjectMapperProvider(Set<Module> jacksonModules, MVCConfiguration configuration) {
        this.configuration = configuration;
        this.jacksonModules = jacksonModules;
    }

    public ObjectMapper get() {
        ObjectMapper objectMapper = new ObjectMapper();
        if (this.jacksonModules.size() > 0) {
            objectMapper.registerModules(this.jacksonModules);
        }
        objectMapper.registerModule((Module)new JacksonModule());
        return this.configure(objectMapper);
    }

    protected boolean allowUnknownParameters() {
        return !this.configuration.allowUnknownParameters();
    }

    protected ObjectMapper configure(ObjectMapper objectMapper) {
        return objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).setDefaultMergeable(Boolean.valueOf(true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.allowUnknownParameters()).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }
}

