/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Textarea;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.testng.annotations.Test;

public class TextareaTest
extends ControlBaseTest {
    @Inject
    public Textarea textarea;

    @Test
    public void action() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Brian");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/textarea", null, null));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"textarea input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><textarea id=\"user_name\" name=\"user.name\">Brian</textarea></div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/textarea", null, null));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "test").attr("class", "css-class").go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-textarea css-class-input css-class-control textarea input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\"><textarea class=\"css-class\" id=\"test\" name=\"test\"></textarea></div>\n</div>\n");
    }

    @Test
    public void defaultValue() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/textarea", null, null));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "user.name").attr("defaultValue", "John").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"textarea input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><textarea id=\"user_name\" name=\"user.name\">John</textarea></div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Barry");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/textarea", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.name", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.name", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"textarea input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\"><span class=\"error\">Your name (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\"><textarea id=\"user_name\" name=\"user.name\">Barry</textarea></div>\n</div>\n");
    }

    @Test
    public void hardCodedValue() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Brian");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/textarea", null, null));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "user.name").attr("value", "Barry").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"textarea input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><textarea id=\"user_name\" name=\"user.name\">Barry</textarea></div>\n</div>\n");
    }

    @Test
    public void html() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("<b>brian</b>");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/textarea", null, null));
        new ControlBaseTest.ControlTester((Control)this.textarea).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"textarea input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><textarea id=\"user_name\" name=\"user.name\">&lt;b&gt;brian&lt;/b&gt;</textarea></div>\n</div>\n");
    }
}

