/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import io.fusionauth.http.HTTPMethod;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.easymock.EasyMock;
import org.example.action.ExecuteMethodThrowsCheckedException;
import org.example.action.ExecuteMethodThrowsExceptionAction;
import org.example.action.ExtensionInheritanceAction;
import org.example.action.HeadAction;
import org.example.action.PostAction;
import org.example.action.SimpleAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.DefaultActionInvocationWorkflow;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultActionInvocationWorkflowTest
extends PrimeBaseTest {
    @Test
    public void action() throws Exception {
        SimpleAction simpleAction = new SimpleAction();
        SimpleAction.invoked = false;
        ActionInvocation actionInvocation = this.makeActionInvocation(simpleAction, HTTPMethod.POST, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("success");
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)SimpleAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void actionExtension() throws Exception {
        ExtensionInheritanceAction extensionInheritanceAction = new ExtensionInheritanceAction();
        ActionInvocation actionInvocation = this.makeActionInvocation(extensionInheritanceAction, HTTPMethod.POST, "post");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("child");
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        Assert.assertFalse((boolean)extensionInheritanceAction.baseInvoked);
        Assert.assertTrue((boolean)extensionInheritanceAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void actionExtensionInheritance() throws Exception {
        ExtensionInheritanceAction extensionInheritanceAction = new ExtensionInheritanceAction();
        ActionInvocation actionInvocation = this.makeActionInvocation(extensionInheritanceAction, HTTPMethod.GET, "get");
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("parent");
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)extensionInheritanceAction.baseInvoked);
        Assert.assertFalse((boolean)extensionInheritanceAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void actionLess() throws Exception {
        ActionInvocation actionInvocation = new ActionInvocation(null, null, "/foo/bar", null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void actionThatThrowsCheckedException() throws Exception {
        ExecuteMethodThrowsCheckedException executeMethodThrowsCheckedException = new ExecuteMethodThrowsCheckedException();
        ActionInvocation actionInvocation = this.makeActionInvocation(executeMethodThrowsCheckedException, HTTPMethod.POST, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        try {
            defaultActionInvocationWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException runtimeException) {
            Assert.assertTrue((boolean)(runtimeException.getCause() instanceof InvocationTargetException));
            Assert.assertTrue((boolean)(((InvocationTargetException)runtimeException.getCause()).getTargetException() instanceof IOException));
        }
        Assert.assertTrue((boolean)executeMethodThrowsCheckedException.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void actionThatThrowsRuntimeException() throws Exception {
        ExecuteMethodThrowsExceptionAction executeMethodThrowsExceptionAction = new ExecuteMethodThrowsExceptionAction();
        ActionInvocation actionInvocation = this.makeActionInvocation(executeMethodThrowsExceptionAction, HTTPMethod.POST, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        try {
            defaultActionInvocationWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)executeMethodThrowsExceptionAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void httpHeadMethod() throws Exception {
        HeadAction headAction = new HeadAction();
        ActionInvocation actionInvocation = this.makeActionInvocation(headAction, HTTPMethod.HEAD, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("success");
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)headAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void httpMethod() throws Exception {
        PostAction postAction = new PostAction();
        PostAction.invoked = false;
        ActionInvocation actionInvocation = this.makeActionInvocation(postAction, HTTPMethod.POST, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("success");
        EasyMock.replay((Object[])new Object[]{resultStore});
        DefaultActionInvocationWorkflow defaultActionInvocationWorkflow = new DefaultActionInvocationWorkflow(actionInvocationStore, resultStore);
        defaultActionInvocationWorkflow.perform(workflowChain);
        Assert.assertTrue((boolean)PostAction.invoked);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Override
    protected ActionInvocation makeActionInvocation(Object object, HTTPMethod hTTPMethod, String string) {
        DefaultActionConfigurationBuilder defaultActionConfigurationBuilder = (DefaultActionConfigurationBuilder)injector.getInstance(DefaultActionConfigurationBuilder.class);
        ActionConfiguration actionConfiguration = defaultActionConfigurationBuilder.build(object.getClass());
        return new ActionInvocation(object, (ExecuteMethodConfiguration)actionConfiguration.executeMethods.get(hTTPMethod), actionConfiguration.uri, string, actionConfiguration);
    }
}

