/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.jwt.domain.JWT;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.JWTMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.security.JWTConstraintsValidator;
import org.primeframework.mvc.security.JWTSecurityContext;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.UnauthorizedException;
import org.primeframework.mvc.util.ReflectionUtils;

public class JWTSecurityScheme
implements SecurityScheme {
    protected final ActionInvocationStore actionInvocationStore;
    protected final JWTConstraintsValidator constraintsValidator;
    protected final HTTPRequest request;
    private final JWTSecurityContext jwtSecurityContext;

    @Inject
    public JWTSecurityScheme(ActionInvocationStore actionInvocationStore, JWTConstraintsValidator constraintsValidator, JWTSecurityContext jwtSecurityContext, HTTPRequest request) {
        this.actionInvocationStore = actionInvocationStore;
        this.constraintsValidator = constraintsValidator;
        this.jwtSecurityContext = jwtSecurityContext;
        this.request = request;
    }

    @Override
    public void handle(String[] constraints) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        JWT jwt = this.jwtSecurityContext.getJWT();
        if (!this.constraintsValidator.validate(jwt, constraints)) {
            throw new UnauthorizedException();
        }
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        HTTPMethod method = this.request.getMethod();
        if (actionConfiguration.jwtAuthorizationMethods.containsKey(method)) {
            for (JWTMethodConfiguration methodConfig : actionConfiguration.jwtAuthorizationMethods.get(method)) {
                try {
                    Boolean authorized = (Boolean)ReflectionUtils.invoke(methodConfig.method, actionInvocation.action, jwt);
                    if (authorized.booleanValue()) continue;
                    throw new UnauthorizedException();
                }
                catch (ExpressionException e) {
                    throw new PrimeException("Unable to invoke @JWTAuthorizeMethod on the class [" + String.valueOf(actionConfiguration.actionClass) + "]", e);
                }
            }
        }
    }
}

