/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.el.Accessor;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.MissingPropertyExpressionException;
import org.primeframework.mvc.parameter.el.ReadExpressionException;
import org.primeframework.mvc.parameter.el.UpdateExpressionException;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.util.TypeTools;

public class MemberAccessor
extends Accessor {
    final Class<?> declaringClass;
    final Field field;
    final ReflectionUtils.PropertyInfo propertyInfo;
    private final List<Class<? extends Annotation>> unWrappedAnnotations;

    public MemberAccessor(ConverterProvider converterProvider, MemberAccessor accessor, MVCConfiguration configuration) {
        super(converterProvider, accessor);
        this.field = accessor.field;
        this.propertyInfo = accessor.propertyInfo;
        this.declaringClass = this.field != null ? this.field.getDeclaringClass() : this.propertyInfo.getDeclaringClass();
        this.unWrappedAnnotations = configuration != null ? configuration.unwrapAnnotations() : Collections.emptyList();
    }

    public MemberAccessor(ConverterProvider converterProvider, Class<?> currentClass, String name, String expression, MVCConfiguration configuration) {
        super(converterProvider);
        this.unWrappedAnnotations = configuration != null ? configuration.unwrapAnnotations() : Collections.emptyList();
        this.currentClass = currentClass;
        Map<String, ReflectionUtils.PropertyInfo> properties = ReflectionUtils.findPropertyInfo(this.currentClass);
        ReflectionUtils.PropertyInfo bpi = properties.get(name);
        if (bpi == null) {
            Map<String, Field> fields = this.findFields();
            this.propertyInfo = null;
            this.field = fields.get(name);
        } else {
            this.propertyInfo = bpi;
            this.field = null;
        }
        if (this.field == null && this.propertyInfo == null) {
            throw new MissingPropertyExpressionException("While evaluating the expression [" + expression + "]. The property/field [" + name + "] does not exist in the class [" + String.valueOf(currentClass) + "]", name, currentClass, expression);
        }
        this.declaringClass = this.field != null ? this.field.getDeclaringClass() : this.propertyInfo.getDeclaringClass();
        Type type = this.type = bpi != null ? bpi.getGenericType() : this.field.getGenericType();
        if (this.type instanceof TypeVariable) {
            this.type = TypeTools.resolveGenericType(this.declaringClass, this.currentClass, (TypeVariable)this.type);
        }
    }

    @Override
    public Object get(Expression expression) {
        if (this.propertyInfo != null) {
            Method getter = this.propertyInfo.getMethods().get("get");
            if (getter == null) {
                throw new ReadExpressionException("Missing getter for property [" + this.propertyInfo.getName() + "] in class [" + String.valueOf(this.currentClass) + "]");
            }
            return ReflectionUtils.invokeGetter(getter, this.object);
        }
        return this.getField();
    }

    @Override
    public MemberAccessor getMemberAccessor() {
        return this;
    }

    @Override
    public boolean isIndexed() {
        return this.propertyInfo != null && this.propertyInfo.isIndexed();
    }

    @Override
    public void set(Object value, Expression expression) {
        if (this.propertyInfo != null) {
            Method setter = this.propertyInfo.getMethods().get("set");
            if (setter == null) {
                throw new UpdateExpressionException("Missing setter for property [" + this.propertyInfo.getName() + "] in class [" + String.valueOf(this.currentClass) + "]");
            }
            ReflectionUtils.invokeSetter(setter, this.object, value);
        } else {
            this.setField(value, expression);
        }
    }

    @Override
    public void set(String[] values, Expression expression) {
        this.set(this.convert(expression, this.field, values), expression);
    }

    @Override
    public String toString() {
        return this.propertyInfo != null ? this.propertyInfo.toString() : "Field [" + this.field.toString() + "] in class [" + String.valueOf(this.field.getDeclaringClass()) + "]";
    }

    @Override
    protected <T extends Annotation> T getAnnotation(Class<T> type) {
        if (this.propertyInfo != null) {
            Map<String, Method> methods = this.propertyInfo.getMethods();
            for (Method method : methods.values()) {
                if (!method.isAnnotationPresent(type)) continue;
                return method.getAnnotation(type);
            }
            String name = this.propertyInfo.getName();
            Field field = ReflectionUtils.findFields(this.currentClass).get(name);
            if (field != null && field.isAnnotationPresent(type)) {
                return field.getAnnotation(type);
            }
        }
        if (this.field != null && this.field.isAnnotationPresent(type)) {
            return this.field.getAnnotation(type);
        }
        return null;
    }

    @Override
    protected Object newInstance(Object key, Class<?> clazz) throws IllegalAccessException, InstantiationException {
        Object object = clazz.newInstance();
        Set<String> fieldNames = ReflectionUtils.findFields(clazz).keySet();
        if (fieldNames.contains(key.toString())) {
            return object;
        }
        for (Field annotatedField : ReflectionUtils.findAllFieldsWithAnnotations(object.getClass(), this.unWrappedAnnotations)) {
            Object thisField = annotatedField.get(object);
            if (thisField != null) continue;
            annotatedField.set(object, this.newInstance(key, annotatedField.getType()));
        }
        return object;
    }

    private Map<String, Field> findFields() {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Map.Entry<String, Field> entry : ReflectionUtils.findFields(this.currentClass).entrySet()) {
            if (ReflectionUtils.areAnyAnnotationsPresent(entry.getValue(), this.unWrappedAnnotations)) {
                fields.putAll(ReflectionUtils.findFields(entry.getValue().getType()));
                continue;
            }
            fields.put(entry.getKey(), entry.getValue());
        }
        return fields;
    }

    private Object getField() {
        if (this.field.getDeclaringClass().isAssignableFrom(this.object.getClass())) {
            return ReflectionUtils.getField(this.field, this.object);
        }
        try {
            for (Field f : ReflectionUtils.findAllFieldsWithAnnotations(this.object.getClass(), this.unWrappedAnnotations)) {
                if (!f.getType().equals(this.field.getDeclaringClass())) continue;
                return ReflectionUtils.getField(this.field, f.get(this.object));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private void setField(Object value, Expression expression) {
        if (this.field.getDeclaringClass().isAssignableFrom(this.object.getClass())) {
            ReflectionUtils.setField(this.field, this.object, value);
            return;
        }
        for (Field f : ReflectionUtils.findAllFieldsWithAnnotations(this.object.getClass(), this.unWrappedAnnotations)) {
            if (!f.getType().equals(this.field.getDeclaringClass())) continue;
            try {
                ReflectionUtils.setField(this.field, f.get(this.object), value);
            }
            catch (IllegalAccessException e) {
                throw new UpdateExpressionException("Unexpected failure setting expression [" + expression.getExpression() + "]", e);
            }
        }
    }
}

