/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import freemarker.core.TemplateMarkupOutputModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.control.form.AbstractInput;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public abstract class AbstractListInput
extends AbstractInput {
    protected ExpressionEvaluator expressionEvaluator;

    protected AbstractListInput(boolean labeled) {
        super(labeled);
    }

    @Inject
    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    protected Map<String, Object> makeParameters() {
        Map<String, Object> parameters = super.makeParameters();
        LinkedHashMap<String, Option> options = new LinkedHashMap<String, Option>();
        Object beanValue = this.currentAction() != null ? this.expressionEvaluator.getValue((String)this.attributes.get("name"), this.currentAction()) : null;
        String headerValue = (String)this.attributes.remove("headerValue");
        String headerL10n = (String)this.attributes.remove("headerL10n");
        if (headerValue != null) {
            String message = "";
            if (headerL10n != null) {
                message = this.messageProvider.getMessage(headerL10n, new Object[0]);
            }
            options.put(headerValue, new Option(message, headerValue.equals("") && beanValue == null, null));
        }
        String valueExpr = (String)this.attributes.remove("valueExpr");
        String textExpr = (String)this.attributes.remove("textExpr");
        String l10nExpr = (String)this.attributes.remove("l10nExpr");
        Object items = this.attributes.remove("items");
        if (items != null) {
            if (items instanceof Collection) {
                Collection c = (Collection)items;
                for (Object o : c) {
                    Object value = this.makeValue(o, null, valueExpr);
                    options.put(value.toString(), this.makeOption(o, value, beanValue, textExpr, l10nExpr));
                }
            } else if (items instanceof Map) {
                Map m = (Map)items;
                for (Map.Entry entry : m.entrySet()) {
                    Object value = this.makeValue(entry.getValue(), entry.getKey(), valueExpr);
                    Option option = this.makeOption(entry.getValue(), value, beanValue, textExpr, l10nExpr);
                    options.put(value.toString(), option);
                }
            } else if (items.getClass().isArray()) {
                int length = Array.getLength(items);
                for (int i = 0; i < length; ++i) {
                    Object itemsValue = Array.get(items, i);
                    Object value = this.makeValue(itemsValue, null, valueExpr);
                    Option option = this.makeOption(itemsValue, value, beanValue, textExpr, l10nExpr);
                    options.put(value.toString(), option);
                }
            }
        }
        parameters.put("options", options);
        return parameters;
    }

    private Option makeOption(Object item, Object value, Object beanValue, String textExpr, String l10nExpr) {
        Object l10nKey;
        if (item == null) {
            return new Option("", false, null);
        }
        String text = null;
        if (l10nExpr != null && (l10nKey = this.expressionEvaluator.getValue(l10nExpr, item)) != null) {
            text = this.messageProvider.getMessage(l10nKey.toString(), new Object[0]);
        }
        if (text == null && textExpr != null) {
            text = this.expressionEvaluator.getValue(textExpr, item).toString();
        }
        if (text == null && item instanceof Enum) {
            try {
                text = this.messageProvider.getMessage(item.getClass().getSimpleName() + "." + String.valueOf(item), new Object[0]);
            }
            catch (MissingMessageException e) {
                try {
                    text = this.messageProvider.getMessage(item.toString(), new Object[0]);
                }
                catch (MissingMessageException missingMessageException) {
                    // empty catch block
                }
            }
        }
        if (text == null && item instanceof TemplateMarkupOutputModel) {
            try {
                text = ((TemplateMarkupOutputModel)item).getOutputFormat().getMarkupString((TemplateMarkupOutputModel)item);
            }
            catch (TemplateModelException e) {
                throw new PrimeException(e);
            }
        }
        if (text == null) {
            text = item.toString();
        }
        if (beanValue == null) {
            return new Option(text, false, item);
        }
        if (beanValue instanceof Collection) {
            return new Option(text, ((Collection)beanValue).contains(value), item);
        }
        if (beanValue.getClass().isArray()) {
            int length = Array.getLength(beanValue);
            for (int i = 0; i < length; ++i) {
                Object arrayValue = Array.get(beanValue, i);
                if (arrayValue == null || !arrayValue.equals(value)) continue;
                return new Option(text, true, item);
            }
        }
        boolean equal = value != null ? (beanValue.getClass().isInstance(value) ? beanValue.equals(value) : beanValue.toString().equals(value.toString())) : (beanValue.getClass().isInstance(item) ? beanValue.equals(item) : beanValue.toString().equals(item.toString()));
        return new Option(text, equal, item);
    }

    private Object makeValue(Object itemsValue, Object key, String valueExpr) {
        Object value;
        if (itemsValue == null) {
            return "";
        }
        if (valueExpr != null && (value = this.expressionEvaluator.getValue(valueExpr, itemsValue)) != null) {
            return value;
        }
        if (key != null) {
            return key;
        }
        return itemsValue;
    }

    public static class Option {
        private final Object object;
        private final boolean selected;
        private final String text;

        public Option(String text, boolean selected, Object object) {
            this.text = text;
            this.selected = selected;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public String getText() {
            return this.text;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

