/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class StatusResult
extends AbstractResult<Status> {
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPResponse response;

    @Inject
    public StatusResult(ExpressionEvaluator expressionEvaluator, HTTPResponse response, ActionInvocationStore actionInvocationStore) {
        super(expressionEvaluator);
        this.response = response;
        this.actionInvocationStore = actionInvocationStore;
    }

    @Override
    public boolean execute(Status status) throws IOException {
        Object action = this.actionInvocationStore.getCurrent().action;
        this.setStatus(status.status(), status.statusStr(), action, this.response);
        for (Status.Header header : status.headers()) {
            this.response.setHeader(header.name(), header.value());
        }
        this.addCacheControlHeader(status, this.response);
        return true;
    }

    @Override
    protected String getCacheControl(Status result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(Status result) {
        return result.disableCacheControl();
    }

    public static class StatusImpl
    implements Status {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final int status;
        private final String statusStr;

        public StatusImpl(String code, int status) {
            this.cacheControl = "no-cache";
            this.code = code;
            this.disableCacheControl = false;
            this.status = status;
            this.statusStr = "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Status.class;
        }

        @Override
        public String cacheControl() {
            return this.cacheControl;
        }

        @Override
        public String code() {
            return this.code;
        }

        @Override
        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        @Override
        public Status.Header[] headers() {
            return new Status.Header[0];
        }

        @Override
        public int status() {
            return this.status;
        }

        @Override
        public String statusStr() {
            return this.statusStr;
        }
    }
}

