/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileUploadPolicy;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.util.Map;
import org.primeframework.mvc.NotAllowedException;
import org.primeframework.mvc.NotImplementedException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.action.ActionMappingWorkflow;
import org.primeframework.mvc.http.HTTPTools;
import org.primeframework.mvc.parameter.fileupload.annotation.FileUpload;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionMappingWorkflow
implements ActionMappingWorkflow {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActionMappingWorkflow.class);
    private final ActionInvocationStore actionInvocationStore;
    private final ActionMapper actionMapper;
    private final HTTPRequest request;
    private final HTTPResponse response;
    @Inject(optional=true)
    private MetricRegistry metricRegistry;

    @Inject
    public DefaultActionMappingWorkflow(HTTPRequest request, HTTPResponse response, ActionInvocationStore actionInvocationStore, ActionMapper actionMapper) {
        this.request = request;
        this.response = response;
        this.actionInvocationStore = actionInvocationStore;
        this.actionMapper = actionMapper;
    }

    @Override
    public void perform(WorkflowChain chain) throws IOException {
        String uri = this.determineURI();
        if (logger.isDebugEnabled()) {
            logger.debug("METHOD: [{}]; URI: [{}]" + uri, (Object)this.request.getMethod(), (Object)uri);
        }
        HTTPMethod method = this.request.getMethod();
        ActionInvocation actionInvocation = this.actionMapper.map(method, uri);
        if (actionInvocation.redirect) {
            this.response.sendRedirect(actionInvocation.uri());
            this.response.setStatus(301);
            return;
        }
        this.actionInvocationStore.setCurrent(actionInvocation);
        if (actionInvocation.action != null && actionInvocation.method == null) {
            Class<?> actionClass = actionInvocation.configuration.actionClass;
            logger.debug("The action class [{}] does not have a valid execute method for the HTTP method [{}]", (Object)actionClass.getCanonicalName(), (Object)method);
            if (HTTPMethod.StandardMethods.containsKey(method.name())) {
                throw new NotAllowedException();
            }
            throw new NotImplementedException();
        }
        this.handleMultiPartConfiguration(actionInvocation);
        Timer.Context perPathTimer = null;
        Timer.Context aggregateTimer = null;
        Meter perPathErrorMeter = null;
        Meter aggregateErrorMeter = null;
        try {
            if (this.metricRegistry != null && actionInvocation.action != null) {
                perPathTimer = this.metricRegistry.timer("prime-mvc.[" + actionInvocation.uri() + "].requests").time();
                aggregateTimer = this.metricRegistry.timer("prime-mvc.[*].requests").time();
                perPathErrorMeter = this.metricRegistry.meter("prime-mvc.[" + actionInvocation.uri() + "].errors");
                aggregateErrorMeter = this.metricRegistry.meter("prime-mvc.[*].errors");
            }
            chain.continueWorkflow();
            this.actionInvocationStore.removeCurrent();
        }
        catch (IOException | Error | RuntimeException e) {
            if (perPathErrorMeter != null) {
                perPathErrorMeter.mark();
            }
            if (aggregateErrorMeter != null) {
                aggregateErrorMeter.mark();
            }
            throw e;
        }
        finally {
            if (aggregateTimer != null) {
                aggregateTimer.stop();
            }
            if (perPathTimer != null) {
                perPathTimer.stop();
            }
        }
    }

    private String determineURI() {
        Object uri = HTTPTools.getRequestURI(this.request);
        if (!((String)uri).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        return uri;
    }

    private void handleMultiPartConfiguration(ActionInvocation actionInvocation) {
        boolean expectingFileUploads;
        if (actionInvocation.configuration == null) {
            return;
        }
        boolean bl = expectingFileUploads = !actionInvocation.configuration.fileUploadMembers.isEmpty();
        if (!expectingFileUploads) {
            return;
        }
        MultipartConfiguration multipartConfiguration = this.request.getMultiPartStreamProcessor().getMultiPartConfiguration();
        multipartConfiguration.withFileUploadPolicy(MultipartFileUploadPolicy.Allow);
        long configuredMaxFileSize = multipartConfiguration.getMaxFileSize();
        Map<String, FileUpload> fileUploadMembers = actionInvocation.configuration.fileUploadMembers;
        long maxFileSize = fileUploadMembers.values().stream().map(FileUpload::maxSize).filter(m -> m != -1L).max(Long::compareTo).orElse(configuredMaxFileSize);
        multipartConfiguration.withMaxFileSize(maxFileSize);
        long expectedFileSizes = fileUploadMembers.values().stream().map(FileUpload::maxSize).filter(m -> m != -1L).count();
        long calculatedExpectedFileSize = maxFileSize * (long)fileUploadMembers.size();
        long adjustedMaxRequestSize = Math.max(expectedFileSizes, calculatedExpectedFileSize) + 0x100000L;
        if (Math.max(expectedFileSizes, calculatedExpectedFileSize) > multipartConfiguration.getMaxRequestSize()) {
            multipartConfiguration.withMaxRequestSize(adjustedMaxRequestSize);
        }
    }
}

