/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.validation;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import java.util.Collection;
import java.util.List;
import org.example.action.ValidationMethods;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.validation.DefaultValidationProcessor;
import org.primeframework.mvc.validation.ValidationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultValidationProcessorTest
extends PrimeBaseTest {
    @Inject
    public MessageStore messageStore;
    @Inject
    public ActionInvocationStore store;

    @Test
    public void disabled() {
        this.request.setMethod(HTTPMethod.POST);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        Assert.assertFalse((boolean)validationMethods.preValidation);
        Assert.assertFalse((boolean)validationMethods.postValidation);
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.POST, ""));
        DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
        defaultValidationProcessor.validate();
        Assert.assertFalse((boolean)validationMethods.preValidation);
        Assert.assertFalse((boolean)validationMethods.postValidation);
    }

    @Test
    public void failureFromPrevious() {
        this.request.setMethod(HTTPMethod.PUT);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.PUT, ""));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "test", "code", "failure"));
        try {
            DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
            defaultValidationProcessor.validate();
            Assert.fail((String)"Should have failed");
        }
        catch (ValidationException validationException) {
            Assert.assertEquals((Collection)this.messageStore.get(), List.of(new SimpleFieldMessage(MessageType.ERROR, "test", "code", "failure")));
        }
    }

    @Test
    public void success() throws Exception {
        this.request.setMethod(HTTPMethod.PUT);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.PUT, ""));
        DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
        defaultValidationProcessor.validate();
    }

    @Test
    public void validatable() {
        this.request.setMethod(HTTPMethod.PUT);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        validationMethods.addInterfaceErrors = true;
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.PUT, ""));
        try {
            DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
            defaultValidationProcessor.validate();
            Assert.fail((String)"Should have failed");
        }
        catch (ValidationException validationException) {
            Assert.assertEquals((Collection)this.messageStore.get(), List.of(new SimpleMessage(MessageType.ERROR, "interface-general-code", "interface-general-message"), new SimpleFieldMessage(MessageType.ERROR, "interface-field", "interface-field-code", "interface-field-message")));
        }
    }

    @Test
    public void validateGet() {
        for (HTTPMethod hTTPMethod : List.of(HTTPMethod.GET, HTTPMethod.HEAD)) {
            this.request.setMethod(hTTPMethod);
            ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
            this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.GET, ""));
            DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
            defaultValidationProcessor.validate();
            Assert.assertTrue((boolean)validationMethods.getValidationCalled);
        }
    }

    @Test
    public void validationMethod() {
        this.request.setMethod(HTTPMethod.PUT);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        validationMethods.addMethodErrors = true;
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.PUT, ""));
        try {
            DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
            defaultValidationProcessor.validate();
            Assert.fail((String)"Should have failed");
        }
        catch (ValidationException validationException) {
            Assert.assertEquals((Collection)this.messageStore.get(), List.of(new SimpleMessage(MessageType.ERROR, "method-general-code", "method-general-message"), new SimpleFieldMessage(MessageType.ERROR, "method-field", "method-field-code", "method-field-message")));
        }
    }

    @Test
    public void validationMethodNotExecutedForGET() {
        this.request.setMethod(HTTPMethod.GET);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        validationMethods.addMethodErrors = true;
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.GET, ""));
        DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
        defaultValidationProcessor.validate();
    }

    @Test
    public void validationMethods() {
        this.request.setMethod(HTTPMethod.GET);
        ValidationMethods validationMethods = new ValidationMethods(this.messageStore);
        Assert.assertFalse((boolean)validationMethods.preValidation);
        Assert.assertFalse((boolean)validationMethods.postValidation);
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.GET, ""));
        DefaultValidationProcessor defaultValidationProcessor = new DefaultValidationProcessor(this.request, this.store, this.messageStore);
        defaultValidationProcessor.validate();
        Assert.assertTrue((boolean)validationMethods.preValidation);
        Assert.assertTrue((boolean)validationMethods.postValidation);
        validationMethods = new ValidationMethods(this.messageStore);
        Assert.assertFalse((boolean)validationMethods.preValidation);
        Assert.assertFalse((boolean)validationMethods.postValidation);
        this.messageStore.add((Message)new SimpleMessage(MessageType.ERROR, "code", "message"));
        this.store.setCurrent(this.makeActionInvocation(validationMethods, HTTPMethod.GET, ""));
        try {
            defaultValidationProcessor.validate();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)validationMethods.preValidation);
        Assert.assertTrue((boolean)validationMethods.postValidation);
    }
}

