/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

public class URITools {
    private static final String URL_PATH_OTHER_SAFE_CHARS = "-._~!$'()*,;&=+@:ABCDEFGHIJKLMNOPQRSTVUWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final boolean[] URL_PATH_SAFE_CHARS_ARRAY;

    public static String decodeURIPathSegment(Object value) {
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toString().toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '%') {
                String hex = new String(new char[]{chars[i + 1], chars[i + 2]});
                sb.append(URITools.unHex(hex));
                i += 3;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String determineExtension(String uri) {
        String extension = null;
        int index = uri.lastIndexOf(46);
        if (index >= 0) {
            extension = uri.substring(index + 1);
            boolean good = false;
            for (int i = 0; i < extension.length() && (good = Character.isLetter(extension.charAt(i))); ++i) {
            }
            if (!good || extension.contains("/")) {
                extension = null;
            }
        }
        return extension;
    }

    public static String encodeURIPathSegment(Object value) {
        StringBuilder sb = new StringBuilder();
        for (char ch : value.toString().toCharArray()) {
            if (ch <= URL_PATH_SAFE_CHARS_ARRAY.length && URL_PATH_SAFE_CHARS_ARRAY[ch]) {
                sb.append(ch);
                continue;
            }
            sb.append('%');
            sb.append(URITools.toHex(ch / 16));
            sb.append(URITools.toHex(ch % 16));
        }
        return sb.toString();
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static String unHex(String s) {
        return String.valueOf((char)Integer.parseInt(s, 16));
    }

    static {
        char[] safeCharArray;
        int maxChar = -1;
        for (char c : safeCharArray = URL_PATH_OTHER_SAFE_CHARS.toCharArray()) {
            maxChar = Math.max(c, maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c : safeCharArray) {
            octets[c] = true;
        }
        URL_PATH_SAFE_CHARS_ARRAY = octets;
    }
}

