/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.control.AbstractControl;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.l10n.MessageProvider;

public abstract class AbstractInput
extends AbstractControl {
    private final boolean labeled;
    protected MessageProvider messageProvider;
    protected MessageStore messageStore;

    protected AbstractInput(boolean labeled) {
        this.labeled = labeled;
    }

    @Inject
    public void setMessageProvider(MessageProvider messageProvider, MessageStore messageStore) {
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
    }

    @Override
    protected void addAdditionalAttributes() {
        String id = (String)this.attributes.get("id");
        if (id == null) {
            id = this.makeID((String)this.attributes.get("name"));
            this.attributes.put("id", id);
        }
    }

    protected String makeID(String name) {
        return name.replace('.', '_');
    }

    @Override
    protected Map<String, Object> makeParameters() {
        Map<String, Object> map = super.makeParameters();
        if (this.labeled) {
            String name = (String)this.attributes.get("name");
            String labelKey = (String)this.attributes.remove("labelKey");
            String label = (String)this.attributes.remove("labelValue");
            if (label == null) {
                if (labelKey != null) {
                    label = this.messageProvider.getMessage(labelKey, new Object[0]);
                }
                if (label == null) {
                    label = this.messageProvider.getMessage(name, new Object[0]);
                }
                if (label == null) {
                    throw new PrimeException("Missing localized label for the field named [" + name + "]. You must define the label in the resource bundle under under the key [" + name + "], which is the name of the field, or using the [labelKey] attribute " + (String)(labelKey != null ? "(which is currently set to [" + labelKey + "] but there is no label in for that key in the resource bundle) " : "") + "to specify an alternate key into the resource bundle.");
                }
            }
            map.put("label", label);
            List<FieldMessage> fieldMessages = this.messageStore.getFieldMessages().get(name);
            if (fieldMessages == null) {
                fieldMessages = Collections.emptyList();
            }
            map.put("messages", this.messageStore.get());
            map.put("fieldMessages", fieldMessages);
            map.put("required", this.attributes.remove("required"));
        }
        return map;
    }

    @Override
    protected String startTemplateName() {
        return null;
    }
}

