/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control;

import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.FreeMarkerBodyProxy;

public class FreeMarkerControlProxy
implements TemplateDirectiveModel {
    private final Control control;
    private final ObjectWrapper objectWrapper;

    public FreeMarkerControlProxy(Control control, ObjectWrapper objectWrapper) {
        this.control = control;
        this.objectWrapper = objectWrapper;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException {
        Map<String, String> dynamicAttributes = this.makeDynamicAttributes(params);
        Map<String, Object> attributes = this.makeAttributes(params);
        this.control.renderStart(env.getOut(), attributes, dynamicAttributes);
        this.control.renderBody(env.getOut(), new FreeMarkerBodyProxy(body));
        this.control.renderEnd(env.getOut());
    }

    protected void executeBody(Environment env, TemplateDirectiveBody body) throws IOException, TemplateException {
        if (body != null) {
            body.render(env.getOut());
        }
    }

    protected Map<String, Object> makeAttributes(Map<Object, Object> params) throws TemplateModelException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(params.size());
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            attributes.put((String)entry.getKey(), ((BeansWrapper)this.objectWrapper).unwrap((TemplateModel)value));
        }
        return attributes;
    }

    protected Map<String, String> makeDynamicAttributes(Map<String, Object> params) {
        HashMap<String, String> dynamicAttributes = new HashMap<String, String>();
        Iterator<String> i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (!key.startsWith("_")) continue;
            Object value = params.get(key);
            dynamicAttributes.put(key.substring(1), value.toString());
            i.remove();
        }
        return dynamicAttributes;
    }
}

