/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Injector;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.Closeable;
import org.primeframework.mvc.action.result.MVCWorkflowFinalizer;
import org.primeframework.mvc.guice.GuiceBootstrap;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.workflow.MVCWorkflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimeMVCRequestHandler
implements HTTPHandler,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PrimeMVCRequestHandler.class);
    protected volatile Injector injector;

    public PrimeMVCRequestHandler(Injector injector) {
        logger.info("Initializing Prime");
        this.injector = injector;
    }

    @Override
    public void close() {
        logger.info("Shutting down Prime MVC");
        GuiceBootstrap.shutdown(this.injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HTTPRequest request, HTTPResponse response) throws Exception {
        String methodOverride = request.getHeader("X-HTTP-Method-Override");
        if (methodOverride == null) {
            methodOverride = request.getHeader("X-Method-Override");
        }
        if (methodOverride != null) {
            request.setMethod(HTTPMethod.of((String)methodOverride));
        }
        HTTPObjectsHolder.setRequest(request);
        HTTPObjectsHolder.setResponse(response);
        try {
            ((MVCWorkflow)this.injector.getInstance(MVCWorkflow.class)).perform(null);
        }
        finally {
            HTTPObjectsHolder.clearRequest();
            HTTPObjectsHolder.clearResponse();
            ((MVCWorkflowFinalizer)this.injector.getInstance(MVCWorkflowFinalizer.class)).run();
        }
    }

    public void updateInjector(Injector injector) {
        this.injector = injector;
    }
}

