/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.message;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.example.action.user.EditAction;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.message.Message;
import org.primeframework.mvc.util.DefaultURIBuilder;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MessageTest
extends ControlBaseTest {
    private static final ActionConfiguration userEditActionConfiguration = new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), Set.of()).build(EditAction.class);
    @Inject
    Message message;

    @Test
    public void defaultMessage() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/user/edit", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.message).attr("key", "bad").attr("default", "Message").go("Message");
    }

    @Test
    public void messageAction() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/user/edit", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.message).attr("key", "key").go("American English Message");
    }

    @Test
    public void messageBundleWithParams() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/user/edit", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.message).attr("key", "params").attr("values", List.of("Params")).go("Params Message");
    }

    @Test
    public void messageFailure() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/user/edit", null, userEditActionConfiguration));
        try {
            new ControlBaseTest.ControlTester((Control)this.message).attr("key", "bad").go("Bundle message");
            Assert.fail((String)"Should have failed");
        }
        catch (PrimeException primeException) {
            // empty catch block
        }
    }
}

