/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.security.MockStaticClasspathResourceFilter;
import org.primeframework.mvc.security.MockStaticResourceFilter;
import org.testng.annotations.Test;

public class StaticResourceTest
extends PrimeBaseTest {
    @Test
    public void get_classpath_resolution() {
        simulator.test("/control-templates/button.ftl").get().assertStatusCode(404);
        MockStaticClasspathResourceFilter.TestFunction = string -> string.endsWith(".ftl");
        simulator.test("/control-templates/button.ftl").get().assertStatusCode(200).assertContentType("content/unknown").assertBodyContains("[#ftl/]").assertContentLength(368L);
        simulator.test("/org/primeframework/mvc/PrimeMVCRequestHandler.class").get().assertStatusCode(404);
        MockStaticClasspathResourceFilter.TestFunction = string -> string.endsWith(".class");
        simulator.test("/org/primeframework/mvc/PrimeMVCRequestHandler.class").get().assertStatusCode(200).assertContentLength(2613L);
    }

    @Test
    public void get_large_resource() {
        simulator.test("/css/fusionauth-style.css").get().assertStatusCode(200).assertContentType("text/css").assertContentLength(162726L);
    }

    @Test
    public void get_preventEscape() {
        simulator.test("/../../resources/logging.properties").get().assertStatusCode(404);
        simulator.test("/../../resources/logging.properties").get().assertStatusCode(404);
    }

    @Test
    public void get_resource() {
        simulator.test("/js/test.js").get().assertStatusCode(200).assertContentType("text/javascript").assertBodyContains("{};").assertContentLength(3L);
        MockStaticResourceFilter.TestFunction = string -> !string.endsWith(".js");
        simulator.test("/js/test.js").get().assertStatusCode(404);
    }
}

