/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.primeframework.mvc.BasePrimeMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPrimeMainThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(TestPrimeMainThread.class);
    private final BasePrimeMain main;

    public TestPrimeMainThread(BasePrimeMain basePrimeMain) {
        super("Prime HTTP server thread for testing");
        this.main = basePrimeMain;
        this.setDaemon(true);
        this.start();
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 10000L) {
            HTTPServerConfiguration[] hTTPServerConfigurationArray;
            if (basePrimeMain.injector == null) {
                TestPrimeMainThread.sleep();
                continue;
            }
            TestPrimeMainThread.sleep();
            for (HTTPServerConfiguration hTTPServerConfiguration : hTTPServerConfigurationArray = basePrimeMain.configuration()) {
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress("localhost", ((HTTPListenerConfiguration)hTTPServerConfiguration.getListeners().get(0)).getPort()), 5);
                    if (socket.isConnected()) {
                        logger.info("Prime HTTP server started");
                        return;
                    }
                    TestPrimeMainThread.sleep();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.main.start();
    }

    public void shutdown() {
        this.main.shutdown();
    }
}

