/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.scope.AbstractCookieScope;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.CookieTools;
import org.primeframework.mvc.util.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseManagedCookieScope<T extends Annotation>
extends AbstractCookieScope<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseManagedCookieScope.class);
    protected final Encryptor encryptor;
    protected final ObjectMapper objectMapper;

    protected BaseManagedCookieScope(HTTPRequest request, HTTPResponse response, Encryptor encryptor, ObjectMapper objectMapper) {
        super(request, response);
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
    }

    @Override
    protected Cookie buildCookie(String fieldName, Object value, T scope) {
        Cookie cookie = new Cookie((Cookie)value);
        boolean compress = this.compress(scope);
        boolean encrypt = this.encrypt(scope);
        String cookieValue = cookie.value;
        if (value == null || cookie.value == null) {
            return null;
        }
        byte[] result = cookieValue.getBytes(StandardCharsets.UTF_8);
        try {
            cookie.value = CookieTools.toCookie(result, compress, encrypt, this.encryptor);
        }
        catch (Exception e) {
            throw new ErrorException("error", (Throwable)e, new Object[0]);
        }
        this.setCookieValues(cookie, scope);
        return cookie;
    }

    protected abstract boolean compress(T var1);

    protected abstract boolean encrypt(T var1);

    protected abstract boolean neverNull(T var1);

    protected Cookie processCookie(Cookie cookie, String fieldName, Class<?> type, T scope) {
        String cookieValue;
        boolean compress = this.compress(scope);
        boolean encrypt = this.encrypt(scope);
        boolean neverNull = this.neverNull(scope);
        String cookieName = this.getCookieName(fieldName, scope);
        String string = cookieValue = cookie != null ? cookie.value : null;
        if (cookieValue == null || "".equals(cookieValue)) {
            return cookie != null ? cookie : (neverNull ? new Cookie(cookieName, null) : null);
        }
        try {
            ThrowingFunction<byte[], String> oldFunction = r -> (String)this.objectMapper.readerFor(String.class).readValue(r);
            ThrowingFunction<byte[], String> newFunction = r -> new String((byte[])r, StandardCharsets.UTF_8);
            if (compress || encrypt) {
                cookie.value = CookieTools.fromCookie(cookieValue, encrypt, encrypt, this.encryptor, oldFunction, newFunction);
            } else {
                try {
                    cookie.value = CookieTools.fromCookie(cookieValue, false, false, this.encryptor, oldFunction, newFunction);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return cookie;
        }
        catch (Exception e) {
            String message = e.getClass().getCanonicalName() + " " + e.getMessage();
            if (encrypt) {
                logger.debug("Failed to decrypt cookie. This may be expected if the cookie was encrypted using a different key.\n\tCause: " + message);
            } else {
                logger.debug("Failed to decode cookie. This is not expected.\n\tCause: " + message);
            }
            cookie.value = null;
            return neverNull ? cookie : null;
        }
    }

    protected abstract void setCookieValues(Cookie var1, T var2);
}

