/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.example.action.Extension;
import org.example.action.ExtensionInheritanceAction;
import org.example.domain.InvalidJavaBeanGetter;
import org.example.domain.InvalidJavaBeanSetter;
import org.primeframework.mvc.parameter.annotation.PostParameterMethod;
import org.primeframework.mvc.util.ReflectionUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReflectionUtilsTest {
    @Test
    public void badGetter() {
        try {
            ReflectionUtils.findPropertyInfo(InvalidJavaBeanGetter.class);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void badSetter() {
        try {
            ReflectionUtils.findPropertyInfo(InvalidJavaBeanSetter.class);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void findMethodsWithAnnotation() {
        List list = ReflectionUtils.findAllMethodsWithAnnotation(C1.class, Foo.class);
        Assert.assertEquals((String)((Method)list.get(0)).getName(), (String)"method3");
        Assert.assertEquals((String)((Method)list.get(1)).getName(), (String)"method1");
        Assert.assertEquals((String)((Method)list.get(2)).getName(), (String)"method2");
    }

    @Test
    public void localeIssues() {
        try {
            ReflectionUtils.findPropertyInfo(Locale.class);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void methodOrdering() throws Exception {
        List list = ReflectionUtils.findAllMethodsWithAnnotation(ExtensionInheritanceAction.class, PostParameterMethod.class);
        System.out.println(list);
        Assert.assertEquals((Collection)list, Arrays.asList(Extension.class.getMethod("method", new Class[0]), Extension.class.getMethod("method1", new Class[0]), ExtensionInheritanceAction.class.getMethod("method2", new Class[0]), ExtensionInheritanceAction.class.getMethod("method3", new Class[0])));
    }

    @Test
    public void setNull() throws Exception {
        Field field;
        User user = new User();
        try {
            field = User.class.getField("roles");
            ReflectionUtils.setField((Field)field, (Object)user, null);
            Assert.fail((String)"Should have thrown an exception, you can't set a final collection null!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        field = User.class.getField("notFinalRoles");
        ReflectionUtils.setField((Field)field, (Object)user, null);
        Assert.assertNull(user.notFinalRoles);
    }

    @Test
    public void setSortedSet() throws Exception {
        Field field = User.class.getField("roles");
        User user = new User();
        ReflectionUtils.setField((Field)field, (Object)user, (Object)new String[]{"admin"});
        Assert.assertEquals((int)user.roles.size(), (int)1);
        Assert.assertEquals((String)((String)user.roles.iterator().next()), (String)"admin");
        user = new User();
        ReflectionUtils.setField((Field)field, (Object)user, new ArrayList<String>(Collections.singletonList("admin")));
        Assert.assertEquals((int)user.roles.size(), (int)1);
        Assert.assertEquals((String)((String)user.roles.iterator().next()), (String)"admin");
        user = new User();
        ReflectionUtils.setField((Field)field, (Object)user, new HashSet<String>(Collections.singletonList("admin")));
        Assert.assertEquals((int)user.roles.size(), (int)1);
        Assert.assertEquals((String)((String)user.roles.iterator().next()), (String)"admin");
        user = new User();
        ReflectionUtils.setField((Field)field, (Object)user, new TreeSet<String>(Collections.singletonList("admin")));
        Assert.assertEquals((int)user.roles.size(), (int)1);
        Assert.assertEquals((String)((String)user.roles.iterator().next()), (String)"admin");
    }

    public static class C1
    extends C2
    implements I1 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Foo {
    }

    private static class User {
        public final SortedSet<String> roles = new TreeSet<String>();
        public SortedSet<String> notFinalRoles = new TreeSet<String>();

        private User() {
        }
    }

    public static class C2
    implements I3 {
    }

    public static interface I3 {
        @Foo
        default public void method3() {
        }
    }

    public static interface I2 {
        @Foo
        default public void method2() {
        }
    }

    public static interface I1
    extends I2 {
        @Foo
        default public void method1() {
        }
    }
}

