/*
 * Decompiled with CFR 0.152.
 */
package org.example.action;

import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.util.List;
import org.example.action.BaseCookieAction;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.result.annotation.Redirect;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.scope.annotation.BrowserActionSession;

@Action
@Status
@Redirect(code="redirect", uri="/cookie")
public class CookieAction
extends BaseCookieAction<BaseCookieAction.Foo> {
    private final MessageStore messageStore;
    public boolean addMessage;
    public boolean blowChunks;
    public boolean clearSaveMe;
    public List<Cookie> cookies;
    public String name;
    @Inject
    public HTTPRequest request;
    @Inject
    public HTTPResponse response;
    @BrowserActionSession
    public String saveMe;
    public String value;

    @Inject
    public CookieAction(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public String get() {
        if (this.blowChunks) {
            throw new CookieErrorException();
        }
        this.cookies = this.request.getCookies();
        return "input";
    }

    public String post() {
        if (this.value != null) {
            Cookie cookie = new Cookie(this.name, this.value);
            this.response.addCookie(cookie);
        }
        if (this.clearSaveMe) {
            this.saveMe = null;
        }
        if (this.addMessage) {
            this.messageStore.add((Message)new SimpleMessage(MessageType.INFO, "[NobodyDrinkTheBeer]", "Nobody drink the beer, the beer has gone bad!"));
            return "redirect";
        }
        return "success";
    }

    public static class CookieErrorException
    extends ErrorException {
        public CookieErrorException() {
            super("input");
        }
    }
}

