/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.util.function.Consumer;
import org.primeframework.mvc.util.QueryStringBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryStringBuilderTest {
    @Test
    public void one() {
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com?foo=bar");
    }

    @Test
    public void testBuilder() {
        this.test(null, queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "foo=bar");
        this.test((QueryStringBuilder queryStringBuilder) -> queryStringBuilder.with("foo", (Object)"bar"), "foo=bar");
        this.test((QueryStringBuilder queryStringBuilder) -> queryStringBuilder.with("foo", (Object)"bar").with("bing", (Object)"baz"), "foo=bar&bing=baz");
        this.test((QueryStringBuilder queryStringBuilder) -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").with("bing", (Object)"baz"), "?foo=bar&bing=baz");
        this.test((QueryStringBuilder queryStringBuilder) -> queryStringBuilder.beginFragment().with("foo", (Object)"bar").with("bing", (Object)"baz"), "#foo=bar&bing=baz");
        this.test(null, queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").with("bing", (Object)"baz").beginFragment().with("joe", (Object)"mama").with("boom", (Object)"dynamite"), "?foo=bar&bing=baz#joe=mama&boom=dynamite");
        this.test((QueryStringBuilder queryStringBuilder) -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").with("bing", (Object)"baz").beginFragment().with("joe", (Object)"mama").with("boom", (Object)"dynamite"), "?foo=bar&bing=baz#joe=mama&boom=dynamite");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com?foo=bar");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar"), "http://acme.com?foo=bar");
        this.test("http://acme.com?foo=bar", queryStringBuilder -> queryStringBuilder.with("bing", (Object)"baz"), "http://acme.com?foo=bar&bing=baz");
        this.test("http://acme.com?foo=bar&bing=baz", queryStringBuilder -> queryStringBuilder.with("boom", (Object)"dynamite"), "http://acme.com?foo=bar&bing=baz&boom=dynamite");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.with("foo", (Object)null), "http://acme.com");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.beginFragment().with("foo", (Object)"bar"), "http://acme.com#foo=bar");
        this.test("http://acme.com#foo=bar", queryStringBuilder -> queryStringBuilder.with("bing", (Object)"baz"), "http://acme.com#foo=bar&bing=baz");
        this.test("http://acme.com#foo=bar&bing=baz", queryStringBuilder -> queryStringBuilder.with("boom", (Object)"dynamite"), "http://acme.com#foo=bar&bing=baz&boom=dynamite");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com?foo=bar#bing=baz");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").with("bing", (Object)"baz").beginFragment().with("joe", (Object)"mama").with("lorem", (Object)"ipsum"), "http://acme.com?foo=bar&bing=baz#joe=mama&lorem=ipsum");
        this.test("http://acme.com?foo=bar", queryStringBuilder -> queryStringBuilder.beginFragment().with("bing", (Object)"baz"), "http://acme.com?foo=bar#bing=baz");
        this.test("http://acme.com?foo=bar#bing=baz", "http://acme.com?foo=bar#bing=baz");
        this.test("http://acme.com?foo=bar&lorem=ipsum#bing=baz&joe=mama", "http://acme.com?foo=bar&lorem=ipsum#bing=baz&joe=mama");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "http://acme.com/bar?foo=bar");
        this.test("http://acme.com/", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "http://acme.com/bar?foo=bar");
        this.test("http://acme.com/", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").withSegment(null).with("foo", (Object)"bar"), "http://acme.com/bar?foo=bar");
        this.test("http://acme.com/", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").withSegment((Object)"baz").with("foo", (Object)"bar"), "http://acme.com/bar/baz?foo=bar");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").beginQuery().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com/bar?foo=bar#bing=baz");
        this.test("http://acme.com/", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").beginQuery().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com/bar?foo=bar#bing=baz");
        this.test("http://acme.com/", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").withSegment((Object)"baz").beginQuery().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com/bar/baz?foo=bar#bing=baz");
        this.test("http://acme.com?test=data", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com?test=data&foo=bar");
        this.test("http://acme.com?test=data", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar"), "http://acme.com?test=data&foo=bar");
        this.test("http://acme.com?test=data", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").beginQuery().with("bing", (Object)"baz"), "http://acme.com?test=data&foo=bar&bing=baz");
        this.test("http://acme.com?test=data", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com?test=data&foo=bar#bing=baz");
        this.test("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com#frag&foo=bar");
        this.test("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar").with("bing", (Object)"baz"), "http://acme.com#frag&foo=bar&bing=baz");
        this.test("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.beginFragment().with("foo", (Object)"bar").with("bing", (Object)"baz"), "http://acme.com#frag&foo=bar&bing=baz");
        this.test("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.beginFragment().with("foo", (Object)"bar").beginFragment().with("bing", (Object)"baz"), "http://acme.com#frag&foo=bar&bing=baz");
        this.test("http://acme.com", queryStringBuilder -> queryStringBuilder.beginQuery().beginFragment().with("foo", (Object)"bar"), "http://acme.com?#foo=bar");
        this.test("http://acme.com?", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com?foo=bar");
        this.test("http://acme.com#test&", queryStringBuilder -> queryStringBuilder.beginFragment().with("foo", (Object)"bar"), "http://acme.com#test&foo=bar");
        this.test("http://acme.com?test=data&", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar"), "http://acme.com?test=data&foo=bar");
        this.test("http://acme.com#test&", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com#test&foo=bar");
        this.test("http://acme.com?test=data&", queryStringBuilder -> queryStringBuilder.with("foo", (Object)"bar"), "http://acme.com?test=data&foo=bar");
        this.test("http://acme.com", QueryStringBuilder::beginQuery, "http://acme.com?");
        this.test("http://acme.com", QueryStringBuilder::beginFragment, "http://acme.com#");
        this.testInvalid("http://acme.com#", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "You cannot add a URL segment after you have appended a # to the end of the URL");
        this.testInvalid("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "You cannot add a URL segment after you have appended a # to the end of the URL");
        this.testInvalid("http://acme.com#frag", queryStringBuilder -> queryStringBuilder.beginQuery().with("foo", (Object)"bar"), "You cannot add a query after a fragment");
        this.testInvalid("http://acme.com?", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "You cannot add a URL segment after you have appended a ? to the end of the URL");
        this.testInvalid("http://acme.com?test=data", queryStringBuilder -> queryStringBuilder.withSegment((Object)"bar").with("foo", (Object)"bar"), "You cannot add a URL segment after you have appended a ? to the end of the URL");
    }

    private void test(String string, String string2) {
        QueryStringBuilder queryStringBuilder = QueryStringBuilder.builder((String)string);
        Assert.assertEquals((String)queryStringBuilder.build(), (String)string2);
    }

    private void test(String string, Consumer<QueryStringBuilder> consumer, String string2) {
        QueryStringBuilder queryStringBuilder = QueryStringBuilder.builder((String)string);
        consumer.accept(queryStringBuilder);
        Assert.assertEquals((String)queryStringBuilder.build(), (String)string2);
    }

    private void test(Consumer<QueryStringBuilder> consumer, String string) {
        QueryStringBuilder queryStringBuilder = QueryStringBuilder.builder();
        consumer.accept(queryStringBuilder);
        Assert.assertEquals((String)queryStringBuilder.build(), (String)string);
    }

    private void testInvalid(String string, Consumer<QueryStringBuilder> consumer, String string2) {
        try {
            QueryStringBuilder queryStringBuilder = QueryStringBuilder.builder((String)string);
            consumer.accept(queryStringBuilder);
            Assert.fail((String)"Expected this to fail.");
        }
        catch (Exception exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)string2);
        }
    }
}

