/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.inject.Injector;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.primeframework.mock.MockUserAgent;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.message.scope.CookieFlashScope;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.test.BodyTools;
import org.primeframework.mvc.test.CookieAsserter;
import org.primeframework.mvc.test.HTTPResponseWrapper;
import org.primeframework.mvc.test.RequestBuilder;
import org.primeframework.mvc.test.ZonedDateTimeToMilliSeconds;
import org.primeframework.mvc.util.CookieTools;
import org.primeframework.mvc.util.QueryStringBuilder;
import org.primeframework.mvc.util.QueryStringTools;
import org.primeframework.mvc.util.ThrowingFunction;
import org.primeframework.mvc.util.ThrowingRunnable;

public class RequestResult {
    public final Injector injector;
    public final TestMessageObserver messageObserver;
    public final int port;
    public final HTTPRequest request;
    public final HTTPResponseWrapper response;
    public final MockUserAgent userAgent;
    private final Set<String> IgnoredHeadersOnRedirect = Set.of("authorization", "referer", "X-Observer-MessageStoreId".toLowerCase());
    public LinkedList<RequestResult> chained;
    private String body;

    public RequestResult(Injector injector, HTTPRequest hTTPRequest, HTTPResponseWrapper hTTPResponseWrapper, MockUserAgent mockUserAgent, TestMessageObserver testMessageObserver, int n) {
        this.request = hTTPRequest;
        this.injector = injector;
        this.response = hTTPResponseWrapper;
        this.userAgent = mockUserAgent;
        this.messageObserver = testMessageObserver;
        this.port = n;
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.setRequest((HTTPRequest)hTTPRequest);
        HTTPObjectsHolder.clearResponse();
        HTTPObjectsHolder.setResponse((HTTPResponse)new HTTPResponse());
    }

    public static void assertJSONEquals(ObjectMapper objectMapper, String string, String string2) throws IOException {
        RequestResult._assertJSONEquals(objectMapper, string, string2, true, null);
    }

    public static void assertSortedJSONEquals(ObjectMapper objectMapper, String string, String string2) throws IOException {
        RequestResult._assertJSONEquals(objectMapper, string, string2, false, null);
    }

    private static void _assertJSONEquals(ObjectMapper objectMapper, String string, String string2, boolean bl, Path path) throws IOException {
        if (string == null || string.isEmpty()) {
            throw new AssertionError((Object)"The actual response body is empty or is equal to an empty string without any JSON. This was unexpected since you are trying to assert on JSON.");
        }
        Map<String, Object> map = (Map<String, Object>)objectMapper.readerFor(Map.class).readValue(string);
        Map<Object, Object> map2 = new HashMap();
        if (string2 != null && !string2.equals("{}")) {
            map2 = (Map)objectMapper.readerFor(Map.class).readValue(string2);
        }
        if (path != null && map2.containsKey("prime-mvc-auto-generated")) {
            map2 = (Map)objectMapper.readerFor(Map.class).readValue(string);
            Files.write(path.toAbsolutePath(), objectMapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT}).with((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter())).writeValueAsBytes(map2), new OpenOption[0]);
        }
        if (map == null) {
            throw new AssertionError((Object)("The actual JSON was empty or once deserialize returned a null JsonNode object. Actual [" + string + "]"));
        }
        if (map2 == null) {
            throw new AssertionError((Object)("The expected JSON was empty or once deserialize returned a null JsonNode object. Expected [" + string2 + "]"));
        }
        ObjectMapper objectMapper2 = objectMapper.copy().configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        if (!(map = RequestResult.deepSort(map, objectMapper2, bl)).equals(map2 = RequestResult.deepSort(map2, objectMapper2, bl))) {
            String string3 = objectMapper2.writeValueAsString(map);
            String string4 = objectMapper2.writeValueAsString(map2);
            throw new AssertionError((Object)("The body doesn't match the expected JSON output. Expected [" + string4 + "] but found [" + string3 + "]"));
        }
    }

    private static Map<String, Object> deepSort(Map<String, Object> map, ObjectMapper objectMapper, boolean bl) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        map.forEach((string, object) -> {
            if (object instanceof Map) {
                treeMap.put((String)string, RequestResult.deepSort((Map)object, objectMapper, bl));
            } else if (object instanceof List) {
                treeMap.put((String)string, RequestResult.deepSort((List)object, objectMapper, bl));
            } else {
                treeMap.put((String)string, object);
            }
        });
        return treeMap;
    }

    private static List<Object> deepSort(List<Object> list, ObjectMapper objectMapper, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        list.forEach(object -> {
            if (object instanceof Map) {
                arrayList.add(RequestResult.deepSort((Map)object, objectMapper, bl));
            } else if (object instanceof List) {
                arrayList.add(RequestResult.deepSort((List)object, objectMapper, bl));
            } else {
                arrayList.add(object);
            }
        });
        if (bl) {
            arrayList.sort(Comparator.comparing(object -> {
                try {
                    return objectMapper.writeValueAsString(object);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new RuntimeException(jsonProcessingException);
                }
            }));
        }
        return arrayList;
    }

    public RequestResult assertBody(String string) {
        String string2 = this.getBodyAsString();
        if (!string2.equals(string)) {
            throw new AssertionError((Object)("The body doesn't match the expected output. Expected [" + string + "] but found [" + string2 + "]"));
        }
        return this;
    }

    public RequestResult assertBodyContains(String ... stringArray) {
        return this._assertBodyContains(false, stringArray);
    }

    public RequestResult assertBodyContainsEscaped(String ... stringArray) {
        return this._assertBodyContains(true, stringArray);
    }

    public RequestResult assertBodyContainsEscapedMessagesFromKey(String string, Object ... objectArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        return this._assertBodyContainsMessagesFromKey(messageProvider, true, string, true, objectArray);
    }

    public RequestResult assertBodyContainsEscapedMessagesFromKeys(String ... stringArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        for (String string : stringArray) {
            this._assertBodyContainsMessagesFromKey(messageProvider, true, string, true, new Object[0]);
        }
        return this;
    }

    public RequestResult assertBodyContainsMessagesFromKey(String string, Object ... objectArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        return this._assertBodyContainsMessagesFromKey(messageProvider, true, string, false, objectArray);
    }

    public RequestResult assertBodyContainsMessagesFromKeys(String ... stringArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        for (String string : stringArray) {
            this._assertBodyContainsMessagesFromKey(messageProvider, true, string, false, "foo", "bar", "baz");
        }
        return this;
    }

    public RequestResult assertBodyDoesNotContain(String ... stringArray) {
        String string = this.getBodyAsString();
        for (String string2 : stringArray) {
            if (string.contains(string2)) {
                throw new AssertionError((Object)("Body shouldn't contain [" + string2 + "]\nRedirect: [" + this.response.getHeader("Location") + "]\nBody:\n" + string));
            }
        }
        return this;
    }

    public RequestResult assertBodyDoesNotContainMessagesFromKey(String string, Object ... objectArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        return this._assertBodyContainsMessagesFromKey(messageProvider, false, string, false, objectArray);
    }

    public RequestResult assertBodyDoesNotContainMessagesFromKeys(String ... stringArray) {
        MessageProvider messageProvider = this.getMessageProviderToLookupMessages();
        for (String string : stringArray) {
            this._assertBodyContainsMessagesFromKey(messageProvider, false, string, false, "foo", "bar", "baz");
        }
        return this;
    }

    public RequestResult assertBodyFile(Path path, Object ... objectArray) throws IOException {
        if (objectArray.length == 0) {
            return this.assertBody(Files.readString(path));
        }
        return this.assertBody(BodyTools.processTemplateForAssertion(path, objectArray));
    }

    public RequestResult assertBodyIsEmpty() {
        String string = this.getBodyAsString();
        if (!string.isEmpty()) {
            throw new AssertionError((Object)("Body is not empty.\nBody:\n" + string));
        }
        return this;
    }

    public RequestResult assertContainsAtLeastTheseFieldErrors(String ... stringArray) {
        Map<String, List<FieldMessage>> map = this.messageObserver.getFieldMessages();
        for (String string2 : stringArray) {
            List<FieldMessage> list = map.get(string2);
            if (list == null) {
                StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
                map.keySet().stream().sorted().forEach(string -> stringBuilder.append("\t\t" + string + "\n"));
                throw new AssertionError((Object)("The MessageStore does not contain a error for the field [" + string2 + "]" + String.valueOf(stringBuilder)));
            }
            boolean bl = false;
            for (FieldMessage fieldMessage2 : list) {
                bl |= fieldMessage2.getType() == MessageType.ERROR;
            }
            if (bl) continue;
            StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
            list.sort(Comparator.comparing(FieldMessage::getField));
            list.forEach(fieldMessage -> stringBuilder.append("\t\t[" + String.valueOf(fieldMessage.getType()) + "]\n"));
            throw new AssertionError((Object)("The MessageStore contains messages but no errors for the field [" + string2 + "]" + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertContainsCookie(String string) {
        this.getCookieOrThrow(string);
        return this;
    }

    public RequestResult assertContainsErrors(String ... stringArray) {
        return this.assertContainsMessages(MessageType.ERROR, stringArray);
    }

    public RequestResult assertContainsFieldErrors(String ... stringArray) {
        this.assertContainsAtLeastTheseFieldErrors(stringArray);
        Map<String, List<FieldMessage>> map = this.messageObserver.getFieldMessages();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        List<String> list = map.keySet().stream().filter(string -> !hashSet.contains(string)).toList();
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder("The MessageStore contains additional field messages that you did not assert.\n");
            stringBuilder.append("\nYou asserted the following field errors exist:\n");
            hashSet.forEach(string -> stringBuilder.append("\t\tField: " + string + "\n"));
            stringBuilder.append("\nYou are missing the following field errors from your assertion:\n");
            list.stream().sorted().forEach(string -> stringBuilder.append("\t\tField: ").append((String)string).append("\n"));
            stringBuilder.append("\nThe MessageStore contains the following field errors:\n");
            map.keySet().stream().sorted().forEach(string -> {
                StringBuilder stringBuilder2 = new StringBuilder();
                ((List)map.get(string)).forEach(fieldMessage -> stringBuilder2.append("\t\t\t[" + String.valueOf(fieldMessage.getType()) + "] " + fieldMessage.getCode()));
                stringBuilder.append("\t\tField: " + string + "\n" + String.valueOf(stringBuilder2) + "\n");
            });
            throw new AssertionError(stringBuilder);
        }
        return this;
    }

    public RequestResult assertContainsGeneralErrorMessageCodes(String ... stringArray) {
        return this.assertContainsGeneralMessageCodes(MessageType.ERROR, stringArray);
    }

    public RequestResult assertContainsGeneralInfoMessageCodes(String ... stringArray) {
        return this.assertContainsGeneralMessageCodes(MessageType.INFO, stringArray);
    }

    public RequestResult assertContainsGeneralMessageCodes(MessageType messageType, String ... stringArray) {
        List<Message> list = this.messageObserver.getGeneralMessages();
        for (String string : stringArray) {
            Message message2 = list.stream().filter(message -> message.getCode().equals(string)).findFirst().orElse(null);
            if (message2 == null) {
                StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
                list.forEach(message -> stringBuilder.append("\t\t" + String.valueOf(message.getType()) + " " + message.getCode() + "\t" + (message instanceof SimpleMessage ? ((SimpleMessage)message).message : "") + "\n"));
                throw new AssertionError((Object)("The MessageStore does not contain the general message [" + string + "] Type: " + String.valueOf(messageType) + String.valueOf(stringBuilder)));
            }
            if (message2.getType() == messageType) continue;
            StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
            list.forEach(message -> stringBuilder.append("\t\t" + String.valueOf(message.getType()) + " " + message.getCode() + "\t" + (message instanceof SimpleMessage ? ((SimpleMessage)message).message : "") + "\n"));
            throw new AssertionError((Object)("The MessageStore contains message for code  [" + message2.getCode() + "], but it is of type [" + String.valueOf(message2.getType()) + "]" + String.valueOf(stringBuilder)));
        }
        long l = list.stream().filter(message -> message.getType() == messageType).count();
        if (l != (long)stringArray.length) {
            StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
            list.stream().filter(message -> message.getType() == messageType).forEach(message -> stringBuilder.append("\t\t" + String.valueOf(message.getType()) + " " + message.getCode() + "\t" + (message instanceof SimpleMessage ? ((SimpleMessage)message).message : "") + "\n"));
            throw new AssertionError((Object)("The MessageStore contains additional messages of type [" + String.valueOf(messageType) + "] that were not expected." + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertContainsInfos(String ... stringArray) {
        return this.assertContainsMessages(MessageType.INFO, stringArray);
    }

    public RequestResult assertContainsMessages(MessageType messageType, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        List<Message> list = this.messageObserver.getGeneralMessages();
        for (Message message2 : list) {
            if (message2.getType() != messageType) continue;
            hashSet.add(message2.toString());
        }
        if (!hashSet.containsAll(Arrays.asList(stringArray))) {
            StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
            list.forEach(message -> stringBuilder.append("\t\t[" + String.valueOf(message) + "]\n"));
            throw new AssertionError((Object)("The MessageStore does not contain the [" + String.valueOf(messageType) + "] message " + String.valueOf(Arrays.asList(stringArray)) + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertContainsNoFieldMessages() {
        return this.assertContainsNoFieldMessages(MessageType.ERROR);
    }

    public RequestResult assertContainsNoFieldMessages(MessageType messageType) {
        List<FieldMessage> list = this.messageObserver.getFieldMessages().values().stream().flatMap(Collection::stream).filter(fieldMessage -> fieldMessage.getType() == messageType).collect(Collectors.toList());
        if (list.isEmpty()) {
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
        list.sort(Comparator.comparing(FieldMessage::getField));
        list.forEach(fieldMessage -> stringBuilder.append("\t\t").append(fieldMessage.getType()).append("\tField: ").append(fieldMessage.getField()).append(" Code: ").append(fieldMessage.getCode()).append("\t").append(fieldMessage instanceof SimpleFieldMessage ? ((SimpleFieldMessage)fieldMessage).message : "").append("\n"));
        throw new AssertionError((Object)("The MessageStore contains the following field errors.]" + String.valueOf(stringBuilder)));
    }

    public RequestResult assertContainsNoGeneralErrors() {
        return this.assertContainsNoMessages(MessageType.ERROR);
    }

    public RequestResult assertContainsNoInfos() {
        return this.assertContainsNoMessages(MessageType.INFO);
    }

    public RequestResult assertContainsNoMessages(MessageType messageType) {
        List<Message> list = this.messageObserver.getGeneralMessages().stream().filter(message -> message.getType() == messageType).toList();
        if (list.isEmpty()) {
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder("\n\tMessageStore contains:\n");
        list.forEach(message -> stringBuilder.append("\t\t" + String.valueOf(message.getType()) + "\t" + message.getCode() + "\t" + (message instanceof SimpleMessage ? ((SimpleMessage)message).message : "") + "\n"));
        throw new AssertionError((Object)("The MessageStore contains the following general errors.]" + String.valueOf(stringBuilder)));
    }

    public RequestResult assertContainsNoWarnings() {
        return this.assertContainsNoMessages(MessageType.WARNING);
    }

    public RequestResult assertContainsWarnings(String ... stringArray) {
        return this.assertContainsMessages(MessageType.WARNING, stringArray);
    }

    public RequestResult assertContentLength(long l) {
        String string = this.response.getHeader("Content-Length");
        if (string == null || Long.parseLong(string) != l) {
            throw new AssertionError((Object)("Content-Length [" + string + "] is not equal to the expected value [" + l + "]"));
        }
        return this;
    }

    public RequestResult assertContentType(String string) {
        String string2 = this.response.getHeader("Content-Type");
        if (string2 == null || !string2.equals(string)) {
            throw new AssertionError((Object)("Content-Type [" + string2 + "] is not equal to the expected value [" + string + "]"));
        }
        return this;
    }

    public RequestResult assertCookie(String string, ThrowingConsumer<CookieAsserter> throwingConsumer) throws Exception {
        Cookie cookie = this.getCookieOrThrow(string);
        if (throwingConsumer != null) {
            throwingConsumer.accept(new CookieAsserter(cookie));
        }
        return this;
    }

    public RequestResult assertCookie(String string, String string2) {
        Cookie cookie = this.getCookieOrThrow(string);
        if (!string2.equals(cookie.value)) {
            throw new AssertionError((Object)("Cookie [" + string + "] with value [" + cookie.value + "] was not equal to the expected value [" + string2 + "]\nActual cookie:\n" + this.cookieToString(cookie)));
        }
        return this;
    }

    public RequestResult assertCookieWasDeleted(String string) {
        Cookie cookie = this.getCookieOrThrow(string);
        if (cookie.value != null && (cookie.maxAge == null || cookie.maxAge != 0L)) {
            throw new AssertionError((Object)("Cookie [" + string + "] was not deleted. The value is [" + cookie.value + "] and the maxAge is [" + cookie.maxAge + "]\nActual cookie:\n" + this.cookieToString(cookie)));
        }
        return this;
    }

    public RequestResult assertDoesNotContainsCookie(String string) {
        Cookie cookie = this.getCookie(string);
        if (cookie != null) {
            throw new AssertionError((Object)("Cookie [" + string + "] was not expected to be found in the response.\nCookies found:\n" + this.response.getCookies().stream().map(this::cookieToString).collect(Collectors.joining("\n"))));
        }
        return this;
    }

    public RequestResult assertEncoding(Charset charset) {
        Charset charset2 = this.getCharset();
        if (charset2 != null && !charset2.equals(charset)) {
            throw new AssertionError((Object)("Character Encoding [" + String.valueOf(charset2) + "] is not equal to the expected value [" + String.valueOf(charset) + "]"));
        }
        return this;
    }

    public RequestResult assertEncryptedCookie(String string, ThrowingConsumer<Cookie> throwingConsumer) throws Exception {
        Cookie cookie = this.getCookieOrThrow(string);
        Encryptor encryptor = (Encryptor)this.injector.getInstance(Encryptor.class);
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        ThrowingFunction throwingFunction = byArray -> (String)objectMapper.readerFor(String.class).readValue(byArray);
        ThrowingFunction throwingFunction2 = byArray -> new String((byte[])byArray, StandardCharsets.UTF_8);
        cookie.value = (String)CookieTools.fromCookie((String)cookie.value, (boolean)true, (boolean)true, (Encryptor)encryptor, (ThrowingFunction)throwingFunction, (ThrowingFunction)throwingFunction2);
        if (throwingConsumer != null) {
            throwingConsumer.accept(cookie);
        }
        return this;
    }

    public RequestResult assertEncryptedCookie(String string, String string2) throws Exception {
        ThrowingFunction throwingFunction;
        ObjectMapper objectMapper;
        ThrowingFunction throwingFunction2;
        Cookie cookie = this.getCookieOrThrow(string);
        Encryptor encryptor = (Encryptor)this.injector.getInstance(Encryptor.class);
        String string3 = (String)CookieTools.fromCookie((String)cookie.value, (boolean)true, (boolean)true, (Encryptor)encryptor, (ThrowingFunction)(throwingFunction2 = arg_0 -> RequestResult.lambda$assertEncryptedCookie$23(objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class), arg_0)), (ThrowingFunction)(throwingFunction = byArray -> new String((byte[])byArray, StandardCharsets.UTF_8)));
        if (!Objects.equals(string2, string3)) {
            throw new AssertionError((Object)("Cookie [" + string + "] with decrypted value [" + string3 + "] was not equal to the expected value [" + string2 + "]\nActual cookie:\n" + this.cookieToString(cookie)));
        }
        return this;
    }

    public RequestResult assertHTML(ThrowingConsumer<HTMLAsserter> throwingConsumer) throws Exception {
        throwingConsumer.accept(new HTMLAsserter(this));
        return this;
    }

    public RequestResult assertHeaderContains(String string2, String string3) {
        String string4 = this.response.getHeader(string2);
        if (string4 == null && string3 != null || string4 != null && !string4.contains(string3)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.response.headers.forEach((string, list) -> stringBuilder.append("\t").append((String)string).append(": ").append(list).append("\n"));
            throw new AssertionError((Object)("Header [" + string2 + "] with value [" + (string4 == null ? null : String.join((CharSequence)", ", string4)) + "] was not equal to the expected value [" + string3 + "].\n\nResponse Headers:\n" + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertHeaderDoesNotContain(String string2) {
        List<String> list2 = null;
        for (String string3 : this.response.headers.keySet()) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            list2 = this.response.headers.get(string3);
            break;
        }
        if (list2 != null && !list2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.response.headers.forEach((string, list) -> stringBuilder.append("\t").append((String)string).append(": ").append(list).append("\n"));
            throw new AssertionError((Object)("Header [" + string2 + "] with value [" + String.join((CharSequence)", ", list2) + "] was not expected in the HTTP response.\n\nResponse Headers:\n" + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertHeaderExists(String string2) {
        List<String> list2 = null;
        for (String string3 : this.response.headers.keySet()) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            list2 = this.response.headers.get(string3);
            break;
        }
        if (list2 == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.response.headers.forEach((string, list) -> stringBuilder.append("\t").append((String)string).append(": ").append(list).append("\n"));
            throw new AssertionError((Object)("Header [" + string2 + "] is missing from the response.\n\nResponse Headers:\n" + String.valueOf(stringBuilder)));
        }
        return this;
    }

    public RequestResult assertJSON(Object object) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        String string = objectMapper.writeValueAsString(object);
        return this.assertJSON(string);
    }

    public <T> RequestResult assertJSON(Class<T> clazz, Consumer<T> consumer) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        Object object = objectMapper.readValue(this.getBodyAsString(), clazz);
        consumer.accept(object);
        return this;
    }

    public RequestResult assertJSON(String string) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        RequestResult.assertJSONEquals(objectMapper, this.getBodyAsString(), string);
        return this;
    }

    public RequestResult assertJSONFile(Path path, Object ... objectArray) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        String string = BodyTools.processTemplateForAssertion(path, this.appendArray(objectArray, "_to_milli", new ZonedDateTimeToMilliSeconds()));
        RequestResult._assertJSONEquals(objectMapper, this.getBodyAsString(), string, true, path);
        return this;
    }

    public <T> RequestResult assertJSONFileWithActual(Class<T> clazz, Path path, Object ... objectArray) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        Object object = objectMapper.readValue(this.getBodyAsString(), clazz);
        return this.assertJSONFile(path, this.appendArray(objectArray, "actual", object, "_to_milli", new ZonedDateTimeToMilliSeconds()));
    }

    public RequestResult assertJSONValuesAt(Object ... objectArray) throws IOException {
        if (objectArray.length % 2 != 0) {
            String string = objectArray[objectArray.length - 1].toString();
            throw new IllegalArgumentException("Invalid mapping values. Must have a multiple of 2. Missing value for key [" + string + "]");
        }
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        JsonNode jsonNode = objectMapper.readTree(this.getBodyAsString());
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = objectArray[i].toString();
            JsonNode jsonNode2 = jsonNode.at(string);
            String string2 = null;
            if (jsonNode2.isArray()) {
                var8_9 = (List)objectMapper.readerForListOf(String.class).readValue(jsonNode2);
                if (!Objects.equals(var8_9, var9_10 = (List)objectArray[i + 1])) {
                    string2 = "Expected [" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)var9_10) + "] but found [" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)var8_9) + "]";
                }
            } else {
                var8_9 = jsonNode.at(string);
                var9_10 = objectArray[i + 1];
                if (var9_10 == null) {
                    if (!var8_9.isMissingNode()) {
                        string2 = "Expected a missing node but found [" + var8_9.asText() + "]";
                    }
                } else if (!Objects.equals(var8_9.asText(), var9_10.toString())) {
                    string2 = "Expected [" + String.valueOf(var9_10) + "] but found [" + var8_9.asText() + "]";
                }
            }
            if (string2 != null) {
                throw new AssertionError((Object)("Actual JSON body:\n" + objectMapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT}).with((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter())).writeValueAsString((Object)jsonNode) + "\n" + string2));
            }
        }
        return this;
    }

    public RequestResult assertNormalizedBody(String string) {
        String string2 = this.getBodyAsString();
        if (!this.normalize(string2).equals(string)) {
            throw new AssertionError((Object)("The body doesn't match the expected output. Expected [" + string + "] but found [" + string2.trim().replace("\r\n", "\n").replace("\r", "\n") + "]"));
        }
        return this;
    }

    public RequestResult assertNormalizedBodyFile(Path path, Object ... objectArray) throws IOException {
        if (objectArray.length == 0) {
            return this.assertNormalizedBody(this.normalize(Files.readString(path)));
        }
        return this.assertNormalizedBody(this.normalize(BodyTools.processTemplateForAssertion(path, objectArray)));
    }

    public RequestResult assertOnJSONValueAt(String string, Consumer<JSONAsserter> consumer) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        JsonNode jsonNode = objectMapper.readTree(this.getBodyAsString());
        JsonNode jsonNode2 = jsonNode.at(string);
        JSONAsserter jSONAsserter = new JSONAsserter(jsonNode2);
        consumer.accept(jSONAsserter);
        if (jSONAsserter.errorMessage != null) {
            throw new AssertionError((Object)("Actual JSON body:\n" + objectMapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT}).with((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter())).writeValueAsString((Object)jsonNode) + "\n" + jSONAsserter.errorMessage));
        }
        return this;
    }

    public RequestResult assertRedirect(String string, Consumer<TestURIBuilder> consumer) {
        String string2 = this.response.getHeader("Location");
        if (string2 == null) {
            throw new AssertionError((Object)("\nActual redirect was null. Why do you want to assert on it? Status code was [" + this.response.getStatus() + "]"));
        }
        TestURIBuilder testURIBuilder = TestURIBuilder.builder(string);
        consumer.accept(testURIBuilder);
        String string3 = testURIBuilder.build();
        this.assertRedirectEquality(string3);
        return this;
    }

    public RequestResult assertRedirect(String string) {
        String string2 = this.response.getHeader("Location");
        if (string2 == null) {
            throw new AssertionError((Object)("\nActual redirect was null. \nExpected:\t" + string));
        }
        this.assertRedirectEquality(string);
        return this;
    }

    public RequestResult assertSortedJSON(Object object) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        String string = objectMapper.writeValueAsString(object);
        return this.assertSortedJSON(string);
    }

    public RequestResult assertSortedJSON(String string) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        RequestResult.assertSortedJSONEquals(objectMapper, this.getBodyAsString(), string);
        return this;
    }

    public RequestResult assertSortedJSONFile(Path path, Object ... objectArray) throws IOException {
        return this.assertSortedJSON(BodyTools.processTemplate(path, this.appendArray(objectArray, "_to_milli", new ZonedDateTimeToMilliSeconds())));
    }

    public <T> RequestResult assertSortedJSONFileWithActual(Class<T> clazz, Path path, Object ... objectArray) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        Object object = objectMapper.readValue(this.getBodyAsString(), clazz);
        return this.assertSortedJSONFile(path, this.appendArray(objectArray, "actual", object, "_to_milli", new ZonedDateTimeToMilliSeconds()));
    }

    public RequestResult assertStatusCode(int n) {
        if (this.response.getStatus() != n) {
            StringBuilder stringBuilder = new StringBuilder("Status code [" + this.response.getStatus() + "] was not equal to [" + n + "]\n");
            List<Message> list = this.messageObserver.getGeneralMessages();
            if (!list.isEmpty()) {
                stringBuilder.append("\nThe following general error messages were returned in the message store:\n\n");
            }
            list.forEach(message -> stringBuilder.append("\t\t").append(message.getType()).append("\t").append(message.getCode()).append("\t").append(message instanceof SimpleMessage ? ((SimpleMessage)message).message : "").append("\n"));
            List list2 = this.messageObserver.getFieldMessages().values().stream().flatMap(Collection::stream).toList();
            if (!list2.isEmpty()) {
                stringBuilder.append("\nThe following field error messages were returned in the message store:\n\n");
            }
            list2.forEach(fieldMessage -> stringBuilder.append("\t\t" + String.valueOf(fieldMessage.getType()) + "\tField: " + fieldMessage.getField() + " Code: " + fieldMessage.getCode() + "\t" + (fieldMessage instanceof SimpleFieldMessage ? ((SimpleFieldMessage)fieldMessage).message : "") + "\n"));
            String string = this.response.getHeader("Location");
            stringBuilder.append("\nRedirect: [").append(string).append("]\n").append("Response body: \n").append(this.getBodyAsString());
            if (this.response.exception != null) {
                stringBuilder.append("\nException:\n").append(this.response.exception);
            }
            throw new AssertionError((Object)stringBuilder.toString());
        }
        return this;
    }

    public RequestResult custom(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        throwingConsumer.accept(this);
        return this;
    }

    public RequestResult custom(ThrowingRunnable throwingRunnable) throws Exception {
        throwingRunnable.run();
        return this;
    }

    public RequestResult delegate(ThrowingFunction<RequestResult, RequestResult> throwingFunction) throws Exception {
        return (RequestResult)throwingFunction.apply((Object)this);
    }

    public RequestResult delegateIfFalse(boolean bl, ThrowingFunction<RequestResult, RequestResult> throwingFunction) throws Exception {
        if (!bl) {
            return (RequestResult)throwingFunction.apply((Object)this);
        }
        return this;
    }

    public RequestResult delegateIfTrue(boolean bl, ThrowingFunction<RequestResult, RequestResult> throwingFunction) throws Exception {
        if (bl) {
            return (RequestResult)throwingFunction.apply((Object)this);
        }
        return this;
    }

    public RequestResult executeFormPostInResponseBody(String string, ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        this._submitForm(string, null, throwingConsumer);
        return this;
    }

    public RequestResult executeFormPostInResponseBody(String string, ThrowingConsumer<DOMHelper> throwingConsumer, ThrowingConsumer<RequestResult> throwingConsumer2) throws Exception {
        this._submitForm(string, throwingConsumer, throwingConsumer2);
        return this;
    }

    public RequestResult executeFormPostInResponseBodyReturnPostResult(String string, ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this._submitForm(string, null, throwingConsumer);
    }

    public RequestResult executeFormPostInResponseBodyReturnPostResult(String string, ThrowingConsumer<DOMHelper> throwingConsumer, ThrowingConsumer<RequestResult> throwingConsumer2) throws Exception {
        return this._submitForm(string, throwingConsumer, throwingConsumer2);
    }

    public RequestResult executeMetaRefreshReturnResult(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this.handleFollowMetaRefresh(throwingConsumer);
    }

    public RequestResult executeRedirect(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        this._followRedirect(throwingConsumer);
        return this;
    }

    public RequestResult executeRedirectReturnResult(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this._followRedirect(throwingConsumer);
    }

    public RequestResult followMetaRefresh(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this.handleFollowMetaRefresh(throwingConsumer);
    }

    public RequestResult followMetaRefresh() throws Exception {
        return this.handleFollowMetaRefresh(null);
    }

    public RequestResult followRedirect(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this._followRedirect(throwingConsumer);
    }

    public RequestResult followRedirect() throws Exception {
        return this._followRedirect(null);
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    public byte[] getBody() {
        return this.response.getBody();
    }

    public String getBodyAsString() {
        if (this.body == null) {
            Charset charset;
            byte[] byArray = this.getBody();
            this.body = byArray != null && byArray.length > 0 ? new String(byArray, (charset = this.getCharset()) != null ? charset : StandardCharsets.UTF_8) : "";
        }
        return this.body;
    }

    public Cookie getCookie(String string) {
        List<Cookie> list = this.response.getCookies(string);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new AssertionError((Object)("Expected a single cookie with name [" + string + "] but found [" + list.size() + "].\nCookies found:\n" + list.stream().map(this::cookieToString).collect(Collectors.joining("\n"))));
        }
        return list.getFirst();
    }

    public List<Cookie> getCookies(String string) {
        return this.response.getCookies(string);
    }

    public RequestResult ifFalse(boolean bl, ThrowingRunnable throwingRunnable) throws Exception {
        if (!bl) {
            throwingRunnable.run();
        }
        return this;
    }

    public RequestResult ifFalse(boolean bl, ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        if (!bl) {
            throwingConsumer.accept(this);
        }
        return this;
    }

    public RequestResult ifThenElse(boolean bl, ThrowingConsumer<RequestResult> throwingConsumer, ThrowingConsumer<RequestResult> throwingConsumer2) throws Exception {
        if (bl) {
            throwingConsumer.accept(this);
        } else {
            throwingConsumer2.accept(this);
        }
        return this;
    }

    public RequestResult ifTrue(boolean bl, ThrowingRunnable throwingRunnable) throws Exception {
        if (bl) {
            throwingRunnable.run();
        }
        return this;
    }

    public RequestResult ifTrue(boolean bl, ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        if (bl) {
            throwingConsumer.accept(this);
        }
        return this;
    }

    public RequestResult repeat(int n, ThrowingConsumer<Integer> throwingConsumer) {
        IntStream.rangeClosed(1, n).forEach(n2 -> {
            try {
                throwingConsumer.accept(n2);
            }
            catch (Throwable throwable) {
                throw new AssertionError("Iteration [" + n + "]\n" + throwable.getMessage(), throwable.getCause());
            }
        });
        return this;
    }

    public RequestResult setup(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        throwingConsumer.accept(this);
        return this;
    }

    public RequestResult setup(ThrowingRunnable throwingRunnable) throws Exception {
        throwingRunnable.run();
        return this;
    }

    public RequestResult submitForm(String string, ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        return this._submitForm(string, null, throwingConsumer);
    }

    public RequestResult submitForm(String string, ThrowingConsumer<DOMHelper> throwingConsumer, ThrowingConsumer<RequestResult> throwingConsumer2) throws Exception {
        return this._submitForm(string, throwingConsumer, throwingConsumer2);
    }

    private RequestResult _assertBodyContains(boolean bl, String ... stringArray) {
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.escape(stringArray[i]);
            }
        }
        String string = this.getBodyAsString();
        for (String string2 : stringArray) {
            if (string.contains(string2)) continue;
            String string3 = this.response.getHeader("Location");
            throw new AssertionError((Object)("Body didn't contain [" + string2 + "]\nRedirect: [" + string3 + "]\nBody:\n" + string));
        }
        return this;
    }

    private RequestResult _assertBodyContainsMessagesFromKey(MessageProvider messageProvider, boolean bl, String string, boolean bl2, Object ... objectArray) {
        String string2;
        Object object;
        Object object2;
        String string3;
        block4: {
            try {
                string3 = messageProvider.getMessage(string, objectArray);
            }
            catch (MissingMessageException missingMessageException) {
                object2 = (CookieFlashScope)this.injector.getInstance(CookieFlashScope.class);
                object = object2.get();
                string3 = object.stream().filter(message -> message.getCode().equals(string)).findFirst().map(Object::toString).orElse(null);
                if (string3 != null) break block4;
                throw missingMessageException;
            }
        }
        if (bl2) {
            string3 = this.escape(string3);
        }
        if (bl != (string2 = this.getBodyAsString()).contains(string3)) {
            object2 = this.response.getHeader("Location");
            object = bl ? "didn't" : "does";
            throw new AssertionError((Object)("Body " + (String)object + " contain [" + string3 + "] for the key [" + string + "]\nRedirect: [" + (String)object2 + "]\nBody:\n" + string2));
        }
        return this;
    }

    private RequestResult _followRedirect(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        Object object;
        String string2 = this.response.getHeader("Location");
        Object object2 = string2.contains("?") ? string2.substring(0, string2.indexOf(63)) : string2;
        String string3 = object2;
        String string4 = string2;
        HashMap<String, List> hashMap = new HashMap<String, List>();
        this.request.getHeaders().keySet().stream().filter(string -> !this.IgnoredHeadersOnRedirect.contains(string.toLowerCase())).forEach(string -> hashMap.put((String)string, new ArrayList(this.request.getHeaders(string))));
        if (!((String)object2).startsWith("/")) {
            int n = this.request.getPath().lastIndexOf(47);
            object = this.request.getPath().substring(0, n);
            object2 = (String)object + "/" + (String)object2;
            string4 = string2.replace(string3, (CharSequence)object2);
        }
        RequestBuilder requestBuilder = new RequestBuilder((String)object2, this.injector, this.userAgent, this.messageObserver, this.port);
        if (((String)object2).length() != string4.length()) {
            object = string4.substring(string4.indexOf(63) + 1);
            QueryStringTools.parseQueryString((String)object).forEach(requestBuilder::withURLParameters);
        }
        requestBuilder.withHeader("Referer", this.request.getBaseURL() + (this.request.getPath() == null || this.request.getPath().equals("/") ? "" : this.request.getPath()) + (String)(this.request.getQueryString() == null || this.request.getQueryString().isEmpty() ? "" : "?" + this.request.getQueryString()));
        hashMap.forEach((string, list) -> list.forEach(string2 -> requestBuilder.withHeader((String)string, string2)));
        object = requestBuilder.get();
        if (this.chained == null) {
            this.chained = new LinkedList();
        }
        ((RequestResult)object).chained = this.chained;
        this.chained.add((RequestResult)object);
        if (throwingConsumer != null) {
            throwingConsumer.accept((RequestResult)object);
        }
        return this.chained.getLast();
    }

    private RequestResult _submitForm(String string, ThrowingConsumer<DOMHelper> throwingConsumer, ThrowingConsumer<RequestResult> throwingConsumer2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string2 = this.getBodyAsString();
        Document document = Jsoup.parse((String)string2);
        Element element = document.selectFirst(string);
        if (element == null) {
            throw new AssertionError((Object)("Unable to find a form in the body using the provided select [" + string + "]. Response body\n" + string2));
        }
        if (throwingConsumer != null) {
            throwingConsumer.accept(new DOMHelper(string2, document));
        }
        if (!((String)(object3 = element.attr("action"))).startsWith("/") && ((String)(object2 = this.request.getPath())).contains("/")) {
            object2 = this.request.getPath().substring(0, ((String)object2).lastIndexOf(47) + 1);
            object3 = (String)object2 + (String)object3;
        }
        object2 = new RequestBuilder((String)object3, this.injector, this.userAgent, this.messageObserver, this.port);
        String string3 = element.attr("method");
        for (Element element2 : element.select("input,select,textarea")) {
            if (!element2.hasAttr("name") || element2.hasAttr("disabled")) continue;
            if (element2.is("select")) {
                for (Element element3 : element2.select("option")) {
                    if (!element3.hasAttr("selected")) continue;
                    this.withParameter((RequestBuilder)object2, string3, element2.attr("name"), element3.val());
                }
                continue;
            }
            if (element2.is("[type=radio],[type=checkbox]")) {
                if (!element2.hasAttr("checked")) continue;
                if (element2.hasAttr("value")) {
                    this.withParameter((RequestBuilder)object2, string3, element2.attr("name"), element2.val());
                    continue;
                }
                this.withParameter((RequestBuilder)object2, string3, element2.attr("name"), "on");
                continue;
            }
            this.withParameter((RequestBuilder)object2, string3, element2.attr("name"), element2.val());
        }
        if (string3.equalsIgnoreCase("GET")) {
            object = ((RequestBuilder)object2).get();
        } else if (string3.equalsIgnoreCase("POST")) {
            object = ((RequestBuilder)object2).post();
        } else {
            throw new IllegalStateException("Unexpected method [" + string3 + "]");
        }
        if (this.chained == null) {
            this.chained = new LinkedList();
        }
        ((RequestResult)object).chained = this.chained;
        ((RequestResult)object).chained.add((RequestResult)object);
        if (throwingConsumer2 != null) {
            throwingConsumer2.accept((RequestResult)object);
        }
        return this.chained.getLast();
    }

    private Object[] appendArray(Object[] objectArray, Object ... objectArray2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        Collections.addAll(arrayList, objectArray2);
        return arrayList.toArray();
    }

    private void assertRedirectEquality(String string) {
        boolean bl;
        SortedMap<String, List<String>> sortedMap;
        String string2 = this.response.getHeader("Location");
        SortedMap<String, List<String>> sortedMap2 = this.uriToMap(string2);
        if (!(sortedMap2.equals(sortedMap = this.uriToMap(string)) || (bl = this.replaceWithActualValues(sortedMap2, sortedMap)) && sortedMap2.equals(sortedMap))) {
            throw new AssertionError((Object)("Actual redirect not equal to the expected. Expected [" + string + "] but found [" + string2 + "]"));
        }
    }

    private Cookie convert(Cookie cookie) {
        return (Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)new Cookie().with(cookie2 -> {
            cookie2.domain = cookie.domain;
        })).with(cookie2 -> {
            cookie2.expires = cookie.expires;
        })).with(cookie2 -> {
            cookie2.httpOnly = cookie.httpOnly;
        })).with(cookie2 -> {
            cookie2.maxAge = cookie.maxAge;
        })).with(cookie2 -> {
            cookie2.name = cookie.name;
        })).with(cookie2 -> {
            cookie2.path = cookie.path;
        })).with(cookie2 -> {
            cookie2.sameSite = cookie.sameSite != null ? Cookie.SameSite.valueOf((String)cookie.sameSite.name()) : null;
        })).with(cookie2 -> {
            cookie2.secure = cookie.secure;
        })).with(cookie2 -> {
            cookie2.value = cookie.value;
        });
    }

    private String cookieToString(Cookie cookie) {
        return "Set-Cookie: " + cookie.toResponseHeader();
    }

    private String escape(String string) {
        return string.replaceAll("\"", "&quot;").replaceAll("'", "&#39;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private Charset getCharset() {
        HTTPTools.HeaderValue headerValue = HTTPTools.parseHeaderValue((String)this.response.getHeader("Content-Type"));
        String string = (String)headerValue.parameters().get("charset");
        Charset charset = null;
        if (string != null) {
            charset = Charset.forName(string);
        }
        return charset;
    }

    private Cookie getCookieOrThrow(String string) {
        Cookie cookie = this.getCookie(string);
        if (cookie == null) {
            throw new AssertionError((Object)("Cookie [" + string + "] was not found in the response.\nCookies found:\n" + this.response.getCookies().stream().map(this::cookieToString).collect(Collectors.joining("\n"))));
        }
        return cookie;
    }

    private MessageProvider getMessageProviderToLookupMessages() {
        MessageProvider messageProvider = this.get(MessageProvider.class);
        ActionInvocationStore actionInvocationStore = this.get(ActionInvocationStore.class);
        ActionMapper actionMapper = this.get(ActionMapper.class);
        ActionInvocation actionInvocation = actionMapper.map(null, this.request.getPath());
        actionInvocationStore.setCurrent(actionInvocation);
        return messageProvider;
    }

    private RequestResult handleFollowMetaRefresh(ThrowingConsumer<RequestResult> throwingConsumer) throws Exception {
        String string = this.getBodyAsString();
        Document document = Jsoup.parse((String)string);
        Elements elements = document.head().getElementsByTag("meta");
        if (elements.isEmpty()) {
            throw new AssertionError((Object)("The <head> element does not contain any meta elements. Response body\n" + string));
        }
        Object var5_5 = null;
        for (Element element : elements) {
            String[] stringArray;
            String string2;
            if (!element.hasAttr("http-equiv") || !(string2 = element.attr("http-equiv")).equalsIgnoreCase("refresh")) continue;
            String string3 = element.attr("content");
            for (String string4 : stringArray = string3.split(";")) {
                Object object;
                String string5 = string4.trim();
                if (!string5.toLowerCase(Locale.ROOT).startsWith("url=")) continue;
                Object object2 = string5.substring(4);
                if (((String)object2).startsWith("'")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
                if (!((String)object2).startsWith("/") && ((String)(object = this.request.getPath())).contains("/")) {
                    object = this.request.getPath().substring(0, ((String)object).lastIndexOf(47) + 1);
                    object2 = (String)object + (String)object2;
                }
                object = new RequestBuilder((String)object2, this.injector, this.userAgent, this.messageObserver, this.port);
                RequestResult requestResult = ((RequestBuilder)object).get();
                if (this.chained == null) {
                    this.chained = new LinkedList();
                }
                requestResult.chained = this.chained;
                requestResult.chained.add(requestResult);
                if (throwingConsumer != null) {
                    throwingConsumer.accept(requestResult);
                }
                return requestResult.chained.getLast();
            }
        }
        throw new AssertionError((Object)("The <head> element does not contain any meta elements with an attribute of http-equiv=\"refresh\". Response body\n" + string));
    }

    private String normalize(String string) {
        return string.trim().replace("\r\n", "\n").replace("\r", "\n");
    }

    private boolean replaceWithActualValues(SortedMap<String, List<String>> sortedMap, Map<String, List<String>> map) {
        boolean bl = false;
        if (sortedMap.size() != map.size() && map.values().stream().noneMatch(list -> list.size() > 0 && ((String)list.getFirst()).equals("___optional___"))) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(sortedMap.keySet());
        ArrayList<String> arrayList2 = new ArrayList<String>(map.keySet());
        int n = 0;
        int n2 = 0;
        while (n < arrayList2.size()) {
            List<String> list2;
            if (!Objects.equals(arrayList.get(n2), arrayList2.get(n))) {
                list2 = map.get(arrayList2.get(n));
                if (list2.size() > 0 && list2.getFirst().equals("___optional___")) {
                    ++n;
                    continue;
                }
                return false;
            }
            list2 = map.get(arrayList2.get(n));
            if (list2 != null && list2.size() > 0 && (list2.getFirst().equals("___actual___") || list2.getFirst().equals("___optional___"))) {
                list2.clear();
                list2.addAll((Collection)sortedMap.get(arrayList.get(n2)));
                bl = true;
            }
            ++n2;
            ++n;
        }
        if (map.keySet().removeIf(string -> !arrayList.contains(string) && ((String)((List)map.get(string)).getFirst()).equals("___optional___"))) {
            bl = true;
        }
        return bl;
    }

    private SortedMap<String, List<String>> uriToMap(String string) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        int n = string.indexOf(63);
        int n2 = string.indexOf(35);
        if (n2 != -1 && n2 + 1 < string.length() && string.charAt(n2 + 1) == '/') {
            n2 = -1;
        }
        if (n == -1 && n2 == -1) {
            treeMap.put(string, Collections.emptyList());
            return treeMap;
        }
        if (n != -1) {
            treeMap.put(string.substring(0, n), Collections.singletonList("?"));
        } else {
            treeMap.put(string.substring(0, n2), Collections.singletonList("#"));
        }
        String string2 = n != -1 ? string.substring(n + 1, n2 == -1 ? string.length() : n2) : string.substring(n2 + 1);
        treeMap.putAll(QueryStringTools.parseQueryString((String)string2));
        if (n != -1 && n2 != -1) {
            string2 = string.substring(n2 + 1);
            treeMap.putAll(QueryStringTools.parseQueryString((String)string2));
        }
        treeMap.values().forEach(list -> list.sort(Comparator.naturalOrder()));
        return treeMap;
    }

    private void withParameter(RequestBuilder requestBuilder, String string, String string2, String string3) {
        if (string.equalsIgnoreCase("GET")) {
            requestBuilder.withURLParameter(string2, string3);
        } else {
            requestBuilder.withParameter(string2, string3);
        }
    }

    private static /* synthetic */ String lambda$assertEncryptedCookie$23(ObjectMapper objectMapper, byte[] byArray) throws Exception {
        return (String)objectMapper.readerFor(String.class).readValue(byArray);
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static class HTMLAsserter {
        public Document document;
        public RequestResult requestResult;

        public HTMLAsserter(RequestResult requestResult) {
            this.requestResult = requestResult;
            this.document = Jsoup.parse((String)requestResult.getBodyAsString());
        }

        public HTMLAsserter assertElementCount(String string, int n) {
            Elements elements = this.document.select(string);
            if (elements.size() != n) {
                throw new AssertionError((Object)("Expected [" + n + "] elements to match the selector " + string + " but found [" + elements.size() + "] elements instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementDoesNotExist(String string) {
            Elements elements = this.document.select(string);
            if (elements.size() > 0) {
                throw new AssertionError((Object)("Expected 0 elements to match the selector " + string + ". Found [" + elements.size() + "] elements.\n" + String.valueOf(elements) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementDoesNotHaveAttribute(String string, String string2) {
            Element element = this.selectExpectOne(string);
            if (element.hasAttr(string2)) {
                throw new AssertionError((Object)("Expected the element not to have attribute [" + string2 + "].\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementExists(String string) {
            this.selectExpectOne(string);
            return this;
        }

        public HTMLAsserter assertElementHasAttribute(String string, String string2) {
            Element element = this.selectExpectOne(string);
            if (!element.hasAttr(string2)) {
                throw new AssertionError((Object)("Expected the element to have attribute [" + string2 + "].\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementHasAttributeValue(String string, String string2, String string3) {
            Element element = this.selectExpectOne(string);
            if (!element.hasAttr(string2)) {
                throw new AssertionError((Object)("Expected the element to have attribute [" + string2 + "].\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            String string4 = element.attr(string2);
            if (!string3.equals(string4)) {
                throw new AssertionError((Object)("Attribute [" + string2 + "] value not equal to expected.\nExpected [" + string3 + "] but found [" + string4 + "]\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementInnerHTML(String string, String string2) {
            Elements elements = this.document.select(string);
            if (elements.size() != 1) {
                throw new AssertionError((Object)("Expected a single element to match the selector " + string + ". Found [" + elements.size() + "] elements instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            Element element = (Element)elements.getFirst();
            if (!string2.equals(element.html())) {
                throw new AssertionError((Object)("Expected a value of [" + string2 + "] to match the selector " + string + ". Found [" + element.html() + "] instead.\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementIsChecked(String string) {
            Elements elements = this.document.select(string);
            if (elements.size() != 1) {
                throw new AssertionError((Object)("Expected a single element to match the selector " + string + ". Found [" + elements.size() + "] elements instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            if (!((Element)elements.getFirst()).hasAttr("checked")) {
                throw new AssertionError((Object)("Expected the element to be checked.\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementIsNotChecked(String string) {
            Elements elements = this.document.select(string);
            if (elements.size() != 1) {
                throw new AssertionError((Object)("Expected a single element to match the selector " + string + ". Found [" + elements.size() + "] elements instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            if (((Element)elements.getFirst()).hasAttr("checked")) {
                throw new AssertionError((Object)("Expected the element NOT to be checked.\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertElementValue(String string, Object object) {
            Elements elements = this.document.select(string);
            if (elements.size() != 1) {
                throw new AssertionError((Object)("Expected a single element to match the selector " + string + ". Found [" + elements.size() + "] instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            Element element = (Element)elements.getFirst();
            if (!element.val().equals(object.toString())) {
                throw new AssertionError((Object)("Using the selector [" + string + "] expected [" + String.valueOf(object) + "] but found [" + element.val() + "]. Actual matched element: \n\n" + String.valueOf(element) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertOnElement(String string, Consumer<Element> consumer) {
            Element element = this.selectExpectOne(string);
            consumer.accept(element);
            return this;
        }

        public HTMLAsserter assertOptionIsNotSelected(String string) {
            Element element = this.selectExpectOne(string);
            if (!element.is("option")) {
                throw new AssertionError((Object)("Expected the element not be an [option] but found [" + element.tagName().toLowerCase(Locale.ROOT) + "].\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            if (element.hasAttr("selected")) {
                throw new AssertionError((Object)("Expected the element not to be selected.\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter assertOptionIsSelected(String string) {
            Element element = this.selectExpectOne(string);
            if (!element.is("option")) {
                throw new AssertionError((Object)("Expected the element not be an [option] but found [" + element.tagName().toLowerCase(Locale.ROOT) + "].\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            if (!element.hasAttr("selected")) {
                throw new AssertionError((Object)("Expected the element to be selected.\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return this;
        }

        public HTMLAsserter custom(ThrowingConsumer<Document> throwingConsumer) throws Exception {
            throwingConsumer.accept(this.document);
            return this;
        }

        private Element selectExpectOne(String string) {
            Elements elements = this.document.select(string);
            if (elements.size() != 1) {
                throw new AssertionError((Object)("Expected a single element to match the selector " + string + ". Found [" + elements.size() + "] elements instead." + (String)(elements.size() == 0 ? "" : "\n\n" + String.valueOf(elements)) + "\n\nActual body:\n" + this.requestResult.getBodyAsString()));
            }
            return (Element)elements.getFirst();
        }
    }

    public static class JSONAsserter {
        public String errorMessage;
        public JsonNode node;
        public Integer size;

        public JSONAsserter(JsonNode jsonNode) {
            this.node = jsonNode;
        }

        public JSONAsserter assertLength(int n) {
            if (this.node.size() != n) {
                this.errorMessage = "Expected an array of size [" + n + "] but found [" + this.node.size() + "]";
            }
            return this;
        }

        public JSONAsserter assertType(JsonNodeType jsonNodeType) {
            if (this.node.getNodeType() != jsonNodeType) {
                this.errorMessage = "Expected node to be of type [" + String.valueOf(jsonNodeType) + "] but found [" + String.valueOf(this.node.getNodeType()) + "]";
            }
            return this;
        }
    }

    public static class TestURIBuilder
    extends QueryStringBuilder {
        private TestURIBuilder() {
        }

        private TestURIBuilder(String string) {
            super(string);
        }

        public static TestURIBuilder builder() {
            return new TestURIBuilder();
        }

        public static TestURIBuilder builder(String string) {
            return new TestURIBuilder(string);
        }

        public TestURIBuilder uri(String string) {
            return (TestURIBuilder)super.uri(string);
        }

        public TestURIBuilder with(String string, Object object) {
            return (TestURIBuilder)super.with(string, object);
        }

        public TestURIBuilder with(String string, Consumer<QueryStringBuilder> consumer) {
            return (TestURIBuilder)super.with(string, consumer);
        }

        public TestURIBuilder withActual(String string) {
            this.with(string, "___actual___");
            return this;
        }

        public TestURIBuilder withConsumer(Consumer<TestURIBuilder> consumer) {
            if (consumer != null) {
                consumer.accept(this);
            }
            return this;
        }

        public TestURIBuilder withOptional(String string) {
            this.with(string, "___optional___");
            return this;
        }

        public TestURIBuilder withQueryString(String string2) {
            Map map = QueryStringTools.parseQueryString((String)string2);
            map.forEach((string, list) -> list.forEach(string2 -> super.with(string, string2)));
            return this;
        }

        public TestURIBuilder withSegment(Object object) {
            return (TestURIBuilder)super.withSegment(object);
        }
    }

    public static class DOMHelper {
        public String body;
        public Document document;

        public DOMHelper(String string, Document document) {
            this.body = string;
            this.document = document;
        }

        public DOMHelper custom(ThrowingRunnable throwingRunnable) throws Exception {
            throwingRunnable.run();
            return this;
        }

        public DOMHelper custom(ThrowingConsumer<Document> throwingConsumer) throws Exception {
            throwingConsumer.accept(this.document);
            return this;
        }

        public DOMHelper removeAttribute(String string, String string2) {
            Element element = this.document.selectFirst(string);
            if (element == null) {
                throw new AssertionError((Object)("Expected at least one element to match the selector " + string + ". Found [0] elements instead. Unable to set element value.\n\nActual body:\n" + this.body));
            }
            element.removeAttr(string2);
            return this;
        }

        public DOMHelper setAttribute(String string, String string2, String string3) {
            Element element = this.document.selectFirst(string);
            if (element == null) {
                throw new AssertionError((Object)("Expected at least one element to match the selector " + string + ". Found [0] elements instead. Unable to set element value.\n\nActual body:\n" + this.body));
            }
            element.attr(string2, string3);
            return this;
        }

        public DOMHelper setChecked(String string, boolean bl) {
            Element element = this.document.selectFirst(string);
            if (element == null) {
                throw new AssertionError((Object)("Expected at least one element to match the selector " + string + ". Found [0] elements instead. Unable to set element value.\n\nActual body:\n" + this.body));
            }
            if (element.is("input[type=radio]") && bl) {
                Elements elements = this.document.select(element.tagName().toLowerCase() + "[type=radio][name=" + element.attr("name") + "]");
                for (Element element2 : elements) {
                    element2.attr("checked", false);
                }
            }
            element.attr("checked", bl);
            return this;
        }

        public DOMHelper setValue(String string, Object object) {
            if (object != null) {
                Element element = this.document.selectFirst(string);
                if (element == null) {
                    throw new AssertionError((Object)("Expected at least one element to match the selector " + string + ". Found [0] elements instead. Unable to set element value.\n\nActual body:\n" + this.body));
                }
                if (element.is("select")) {
                    for (Element element2 : element.getElementsByTag("option")) {
                        if (element2.attr("value").equals(object.toString())) {
                            element2.attr("selected", "selected");
                            continue;
                        }
                        element2.removeAttr("selected");
                    }
                } else {
                    element.val(object.toString());
                }
            }
            return this;
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }
}

