/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import io.fusionauth.http.Cookie;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HTTPResponseWrapper {
    public Throwable exception;
    public Map<String, List<String>> headers;
    public HttpResponse<byte[]> response;
    public int status;

    public byte[] getBody() {
        return this.response != null ? this.response.body() : null;
    }

    public List<Cookie> getCookies(String string) {
        return this.getCookies().stream().filter(cookie -> cookie.name.equals(string)).toList();
    }

    public List<Cookie> getCookies() {
        if (this.response == null) {
            return List.of();
        }
        List<String> list = this.response.headers().allValues("Set-Cookie".toLowerCase());
        if (list != null && list.size() > 0) {
            return list.stream().map(Cookie::fromResponseHeader).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return List.of();
    }

    public String getHeader(String string) {
        return this.response != null ? (String)this.response.headers().firstValue(string.toLowerCase()).orElse(null) : null;
    }

    public int getStatus() {
        return this.status;
    }

    public void init() {
        this.status = this.response != null ? this.response.statusCode() : -1;
        this.headers = this.response != null ? this.response.headers().map() : Map.of();
    }
}

