/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.MockUserIdSessionContext;
import org.primeframework.mvc.security.UserIdSessionContext;
import org.primeframework.mvc.util.CookieTools;

public class SessionCookieKeyChanger {
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;

    @Inject
    SessionCookieKeyChanger(Encryptor encryptor, ObjectMapper objectMapper) {
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
    }

    public void changeIt(Cookie cookie) {
        try {
            UserIdSessionContext userIdSessionContext = (UserIdSessionContext)CookieTools.fromJSONCookie((String)cookie.value, MockUserIdSessionContext.class, (boolean)true, (boolean)true, (Encryptor)this.encryptor, (ObjectMapper)this.objectMapper);
            byte[] byArray = this.objectMapper.writeValueAsBytes((Object)userIdSessionContext);
            MockConfiguration mockConfiguration = new MockConfiguration();
            mockConfiguration.regenerateCookieEncryptionKey();
            CBCCipherProvider cBCCipherProvider = new CBCCipherProvider((MVCConfiguration)mockConfiguration);
            GCMCipherProvider gCMCipherProvider = new GCMCipherProvider((MVCConfiguration)mockConfiguration);
            DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)cBCCipherProvider, (CipherProvider)gCMCipherProvider);
            cookie.value = CookieTools.toCookie((byte[])byArray, (boolean)true, (boolean)true, (Encryptor)defaultEncryptor);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

