/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.result.SavedRequestTools;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.DefaultSavedRequestWorkflow;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.saved.SavedHttpRequest;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultSavedRequestWorkflowTest
extends PrimeBaseTest {
    @Test
    public void performNoSavedRequest() throws Exception {
        DefaultSavedRequestWorkflow defaultSavedRequestWorkflow = new DefaultSavedRequestWorkflow((MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), this.objectMapper, this.request, this.response);
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        defaultSavedRequestWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performSavedRequestPOST() throws Exception {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("test", List.of("value"));
        hashMap.put("test2", List.of("value2"));
        Cookie cookie = SavedRequestTools.toCookie((SavedHttpRequest)new SavedHttpRequest(HTTPMethod.POST, "/secure", hashMap), (MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), (ObjectMapper)this.objectMapper);
        cookie.setValue("ready_" + cookie.getValue());
        this.request.addCookies(new Cookie[]{cookie});
        this.request.setPath("/secure");
        DefaultSavedRequestWorkflow defaultSavedRequestWorkflow = new DefaultSavedRequestWorkflow((MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), this.objectMapper, this.request, this.response);
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        defaultSavedRequestWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
        Assert.assertEquals((String)this.request.getPath(), (String)"/secure");
        Assert.assertEquals((Collection)((Collection)this.request.getParameters().get("test")), List.of("value"));
        Assert.assertEquals((Collection)((Collection)this.request.getParameters().get("test2")), List.of("value2"));
    }
}

