/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import com.google.inject.internal.MoreTypes;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.converters.CollectionConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CollectionsConverterTest
extends PrimeBaseTest {
    @Inject
    public CollectionConverter converter;

    @Test
    public void fromStrings() {
        this.withValues("foo", "bar").withExpectedResult(new String[]{"foo", "bar"}).assertConversion();
        this.withValues("foo", "bar,baz").withExpectedResult(new String[]{"foo", "bar,baz"}).assertConversion();
        this.withValues(",foo,", "bar,baz").withExpectedResult(new String[]{",foo,", "bar,baz"}).assertConversion();
        this.withValues(",foo,").withExpectedResult(new String[]{",foo,"}).assertConversion();
        this.withValues("foo,bar").withExpectedResult(new String[]{"foo,bar"}).assertConversion();
        this.withValues("").withExpectedResult(new String[0]).assertConversion();
        this.withValues("foo", "").withExpectedResult(new String[]{"foo"}).assertConversion();
    }

    @Test
    public void toStrings() {
        CollectionsConverterTest.expectException(ConverterStateException.class, () -> this.converter.convertToString((Type)new MoreTypes.ParameterizedTypeImpl(null, Set.class, new Type[]{String.class}), null, "variations", (Object)new String[]{"foo", "bar"}));
    }

    private Builder withValues(String ... stringArray) {
        return new Builder(stringArray);
    }

    private class Builder {
        public Object[] expected;
        public String[] values;

        public Builder(String ... stringArray) {
            this.values = stringArray;
        }

        public Builder withExpectedResult(Object[] objectArray) {
            this.expected = objectArray;
            return this;
        }

        private void assertConversion() {
            if (this.expected == null) {
                this.expected = this.values;
            }
            Set set = (Set)CollectionsConverterTest.this.converter.convertFromStrings((Type)new MoreTypes.ParameterizedTypeImpl(null, Set.class, new Type[]{String.class}), null, "variations", this.values);
            Assert.assertEquals(new TreeSet(set), new TreeSet<Object>(Arrays.asList(this.expected)));
            set = (Set)CollectionsConverterTest.this.converter.convertFromStrings(HashSet.class, null, "variations", this.values);
            Assert.assertEquals(new TreeSet(set), new TreeSet<Object>(Arrays.asList(this.expected)));
            TreeSet treeSet = (TreeSet)CollectionsConverterTest.this.converter.convertFromStrings((Type)new MoreTypes.ParameterizedTypeImpl(null, TreeSet.class, new Type[]{String.class}), null, "variations", this.values);
            Assert.assertEquals((Set)treeSet, new TreeSet<Object>(Arrays.asList(this.expected)));
            treeSet = (TreeSet)CollectionsConverterTest.this.converter.convertFromStrings(TreeSet.class, null, "variations", this.values);
            Assert.assertEquals((Set)treeSet, new TreeSet<Object>(Arrays.asList(this.expected)));
            List list = (List)CollectionsConverterTest.this.converter.convertFromStrings((Type)new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{String.class}), null, "variations", this.values);
            Assert.assertEquals((Collection)list, new ArrayList<Object>(Arrays.asList(this.expected)));
            list = (List)CollectionsConverterTest.this.converter.convertFromStrings((Type)new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{String.class}), null, "variations", this.values);
            Assert.assertEquals((Collection)list, new ArrayList<Object>(Arrays.asList(this.expected)));
        }
    }
}

