/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mock;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MockUserAgent {
    public Map<String, Map<String, Cookie>> cookies = new ConcurrentHashMap<String, Map<String, Cookie>>();

    public void addCookie(Cookie cookie) {
        String string2 = cookie.path != null ? cookie.path : "/";
        Map map = this.cookies.computeIfAbsent(string2, string -> new ConcurrentHashMap());
        map.remove(cookie.name);
        if (!(cookie.maxAge != null && cookie.maxAge <= 0L || cookie.expires != null && !cookie.expires.isAfter(ZonedDateTime.now(ZoneOffset.UTC)))) {
            map.put(cookie.name, cookie);
        }
    }

    public void addCookies(Collection<Cookie> collection) {
        for (Cookie cookie : collection) {
            this.addCookie(cookie);
        }
    }

    public void clearAllCookies() {
        this.cookies.clear();
    }

    public void clearCookie(String string) {
        this.clearCookie("/", string);
    }

    public void clearCookie(String string, String string3) {
        if (this.cookies.containsKey(string)) {
            this.cookies.get(string).keySet().removeIf(string2 -> string2.equals(string3));
        }
    }

    public void clearCookies(String string) {
        this.cookies.remove(string);
    }

    public Cookie getCookie(String string) {
        return this.getCookie("/", string);
    }

    public Cookie getCookie(String string, String string2) {
        return this.getCookies(string).stream().filter(cookie -> cookie.name.equals(string2)).findFirst().orElse(null);
    }

    public Cookie getCookie(HTTPRequest hTTPRequest, String string) {
        return this.getCookie(hTTPRequest.getPath(), string);
    }

    public List<Cookie> getCookies() {
        return this.getCookies("/");
    }

    public List<Cookie> getCookies(String string) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        this.cookies.forEach((string2, map) -> {
            if (string.startsWith((String)string2)) {
                arrayList.addAll(map.values());
            }
        });
        return arrayList;
    }

    public List<Cookie> getCookies(HTTPRequest hTTPRequest) {
        return this.getCookies(hTTPRequest.getPath());
    }

    public void reset() {
        this.cookies.clear();
    }
}

