/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.AbstractPrimitiveConverter;

@GlobalConverter
public class NumberConverter
extends AbstractPrimitiveConverter {
    @Inject
    public NumberConverter(MVCConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Object defaultPrimitive(Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        if (convertTo == Byte.TYPE || convertTo == Byte.class) {
            return (byte)0;
        }
        if (convertTo == Short.TYPE || convertTo == Short.class) {
            return (short)0;
        }
        if (convertTo == Integer.TYPE || convertTo == Integer.class) {
            return 0;
        }
        if (convertTo == Long.TYPE || convertTo == Long.class) {
            return 0L;
        }
        if (convertTo == Float.TYPE || convertTo == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (convertTo == BigInteger.class) {
            return BigInteger.ZERO;
        }
        if (convertTo == BigDecimal.class) {
            return new BigDecimal("0.0");
        }
        if (convertTo == Double.TYPE || convertTo == Double.class) {
            return 0.0;
        }
        throw new ConverterStateException("Invalid type for NumberConverter [" + String.valueOf(convertTo) + "]");
    }

    @Override
    protected String primitiveToString(Object value, Class convertFrom, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        return value.toString();
    }

    @Override
    protected Object stringToPrimitive(String value, Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        try {
            if (convertTo == Byte.TYPE || convertTo == Byte.class) {
                return Byte.valueOf(value);
            }
            if (convertTo == Short.TYPE || convertTo == Short.class) {
                return Short.valueOf(value);
            }
            if (convertTo == Integer.TYPE || convertTo == Integer.class) {
                return Integer.valueOf(value);
            }
            if (convertTo == Long.TYPE || convertTo == Long.class) {
                return Long.valueOf(value);
            }
            if (convertTo == Float.TYPE || convertTo == Float.class) {
                return Float.valueOf(value);
            }
            if (convertTo == Double.TYPE || convertTo == Double.class) {
                return Double.valueOf(value);
            }
            if (convertTo == BigInteger.class) {
                return new BigInteger(value);
            }
            if (convertTo == BigDecimal.class) {
                return new BigDecimal(value);
            }
            throw new ConverterStateException("Invalid type for NumberConverter [" + String.valueOf(convertTo) + "]");
        }
        catch (NumberFormatException e) {
            throw new ConversionException(e);
        }
    }
}

