/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.guice;

import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(GuiceBootstrap.class);

    private GuiceBootstrap() {
    }

    public static Injector initialize(Module ... modules) {
        logger.debug("Initializing Guice");
        try {
            return Guice.createInjector((Module[])modules);
        }
        catch (CreationException e) {
            logger.debug("Unable to create Guice injector", (Throwable)e);
            Collection messages = e.getErrorMessages();
            HashSet errorMessages = new HashSet();
            messages.forEach(message -> {
                if (message.getCause() != null) {
                    errorMessages.add("[" + message.getMessage() + "] \n\t-> [" + String.valueOf(message.getCause().getClass()) + "] " + message.getCause().getMessage());
                } else {
                    errorMessages.add("[" + message.getMessage() + "]");
                }
            });
            logger.error("\n\n===================================================================================================\n\n  Unable to start the server. Here's why: \n\n\n{}\n\n===================================================================================================\n\n", (Object)String.join((CharSequence)"\n", errorMessages));
            logger.error("Unable to start the server. Exception: \n", (Throwable)e);
            throw new PrimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(Injector injector) {
        Map bindings = injector.getBindings();
        HashSet closed = new HashSet();
        for (Key key : bindings.keySet()) {
            Closeable closable;
            Class bindingType;
            Type type = key.getTypeLiteral().getType();
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (!(type instanceof Class) || !Closeable.class.isAssignableFrom(bindingType = (Class)type) || !Scopes.isSingleton((Binding)((Binding)bindings.get(key))) || (closable = (Closeable)injector.getInstance(key)) == null || closed.contains(closable.getClass())) continue;
            try {
                closable.close();
            }
            catch (Throwable t) {
                logger.error("Unable to shutdown Closeable [{}]", (Object)key);
            }
            finally {
                closed.add(closable.getClass());
            }
        }
    }
}

