/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.control.form.AbstractInput;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

@ControlAttributes(required={@ControlAttribute(name="name", types={String.class})}, optional={@ControlAttribute(name="cols", types={int.class, Number.class}), @ControlAttribute(name="disabled", types={boolean.class, Boolean.class}), @ControlAttribute(name="readonly", types={boolean.class, Boolean.class}), @ControlAttribute(name="required", types={boolean.class, Boolean.class}), @ControlAttribute(name="rows", types={int.class, Number.class}), @ControlAttribute(name="tabindex", types={int.class, Number.class})})
public class Textarea
extends AbstractInput {
    private final ExpressionEvaluator expressionEvaluator;

    @Inject
    public Textarea(ExpressionEvaluator expressionEvaluator) {
        super(true);
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    protected void addAdditionalAttributes() {
        super.addAdditionalAttributes();
        String name = (String)this.attributes.get("name");
        Object action = this.currentAction();
        if (!this.attributes.containsKey("value") && action != null) {
            String value = this.expressionEvaluator.getValue(name, action, this.dynamicAttributes);
            if (value == null) {
                value = (String)this.attributes.get("defaultValue");
            }
            if (value != null) {
                this.attributes.put("value", value);
            }
        }
        this.attributes.remove("defaultValue");
    }

    @Override
    protected String endTemplateName() {
        return "textarea.ftl";
    }
}

