/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import freemarker.template.Configuration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.UUID;
import org.example.action.JwtAuthorizedAction;
import org.example.action.LotsOfMessagesAction;
import org.example.action.OverrideMeAction;
import org.example.action.ParameterHandlerAction;
import org.example.action.store.BaseStoreAction;
import org.example.action.user.EditAction;
import org.example.action.user.FullFormAction;
import org.example.domain.UserField;
import org.primeframework.mvc.MockMVCWorkflowFinalizer;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.container.ContainerResolver;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.parameter.el.InvalidExpressionException;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.FileAssert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GlobalTest
extends PrimeBaseTest {
    private Path jsonDir;

    @BeforeClass
    public void beforeClass() {
        this.jsonDir = Path.of("src/test/resources/json", new String[0]);
    }

    @Test
    public void cache_control_disabled() throws Exception {
        this.test.simulate(() -> simulator.test("/cache-control-disabled").post().assertStatusCode(200).assertHeaderDoesNotContain("Cache-Control"));
    }

    @Test
    public void cache_control_override() throws Exception {
        this.test.simulate(() -> simulator.test("/cache-control-override").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-store"));
    }

    @Test
    public void custom_constraints() throws Exception {
        this.test.loginUserWithRole("delete-only").simulate(() -> simulator.test("/secure").delete().assertStatusCode(200)).simulate(() -> simulator.test("/secure").put().assertStatusCode(403));
        this.test.loginUserWithRole("put-only").simulate(() -> simulator.test("/secure").put().assertStatusCode(200)).simulate(() -> simulator.test("/secure").delete().assertStatusCode(403));
    }

    @Test
    public void embeddedFormHandling() throws Exception {
        this.test.simulate(() -> simulator.test("/scope/page-one").withURLSegment("IdOnlyForPageOne").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache"));
        this.test.createFile().simulate(() -> simulator.test("/scope/page-one").withFile("file", this.test.tempFile, "text/plain").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test
    public void escapePathSegmentsWithWildCard() throws Exception {
        this.test.simulate(() -> simulator.test("/escaped-path-segments").withURLSegment("foo bar").withURLSegment("foobar").withURLSegment("foo bar").withURLSegment("foo@bar").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Success!", "parm=foo bar", "theRest=foobar,foo bar,foo@bar"));
        this.test.simulate(() -> simulator.test("/escaped-path-segments").withURLSegment("<foo>").withURLSegment("foo bar").withURLSegment("foobar").withURLSegment("foo bar").withURLSegment("foo@bar").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Success!", "parm=&lt;foo&gt;", "theRest=foo bar,foobar,foo bar,foo@bar"));
    }

    @Test
    public void flash_scope_compatibility() throws Exception {
        SimpleMessage simpleMessage = new SimpleMessage(MessageType.INFO, "[FlashScopeMessageKey]", "This is a message!");
        byte[] byArray = this.objectMapper.writeValueAsBytes(List.of(simpleMessage));
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration));
        byte[] byArray2 = defaultEncryptor.encrypt(byArray);
        String string = Base64.getUrlEncoder().encodeToString(byArray2);
        simulator.test("/flash-scope/").withCookie(configuration.messageFlashScopeCookieName(), string).get().assertStatusCode(200).assertContainsGeneralMessageCodes(MessageType.INFO, "[FlashScopeMessageKey]").assertBodyContainsMessagesFromKey("[FlashScopeMessageKey]", new Object[0]).assertBody("This is an index page.\n\n  Info:This is a message!\n\n");
    }

    @Test
    public void follow_meta_refresh() throws Exception {
        this.test.forEach("lc", "uc").test(string -> this.test.simulate(() -> simulator.test("/meta/refresh").withURLParameter("test", string).get().assertStatusCode(200).assertBodyContains("<meta http-equiv=\"{refresh}\" content=\"0; {url}=/meta/target\">\n".replace("{refresh}", string.equals("uc") ? "Refresh" : "refresh").replace("{url}", string.equals("uc") ? "URL" : "url")).followMetaRefresh(requestResult -> requestResult.assertStatusCode(200).assertBody("We made it!\n"))));
    }

    @Test
    public void get() throws Exception {
        Assert.assertEquals((int)MockMVCWorkflowFinalizer.Called.get(), (int)0);
        simulator.test("/user/edit").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertHeaderContains("cache-control", "no-cache").assertHeaderDoesNotContain("Potato").assertBodyFile(Path.of("src/test/resources/html/edit.html", new String[0]), new Object[0]);
        Assert.assertEquals((int)MockMVCWorkflowFinalizer.Called.get(), (int)1);
        EditAction.getCalled = false;
        simulator.test("/user/edit").withHeader("X-HTTP-Method-Override", "GET").get().assertStatusCode(200);
        Assert.assertTrue((boolean)EditAction.getCalled);
        Assert.assertEquals((int)MockMVCWorkflowFinalizer.Called.get(), (int)2);
    }

    @Test
    public void get_ContentTypeOverride() {
        simulator.test("/content-type-override").get().assertStatusCode(200).assertContentType("application/json+scim");
        simulator.test("/content-type-override").withURLParameter("status", 400).get().assertStatusCode(400).assertContentType("application/json+error");
    }

    @Test
    public void get_JSONView() throws Exception {
        this.test.simulate(() -> simulator.test("/views/entry/api").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSONFile(this.jsonDir.resolve("views/entry/entry-api.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/views/entry/export").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSONFile(this.jsonDir.resolve("views/entry/entry-export.json"), new Object[0]));
        this.test.configureObjectMapper(objectMapper -> this.objectMapper.enable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION})).simulate(() -> simulator.test("/views/entry/no-view-defined").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSONFile(this.jsonDir.resolve("views/entry/entry-no-view-defined.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/views/entry/wrong-view-defined").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSON("{}"));
        this.test.configureObjectMapper(objectMapper -> this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION})).simulate(() -> simulator.test("/views/entry/no-view-defined").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSONFile(this.jsonDir.resolve("views/entry/entry-no-view-defined.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/views/entry/wrong-view-defined").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSON("{}"));
    }

    @Test
    public void get_action_backed_template_slashes() {
        simulator.test("/freemarker/action-backed").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Yo, nice template, I have an action.");
        simulator.test("/freemarker//action-backed").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Yo, nice template, I have an action.");
        simulator.test("/freemarker///action-backed").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Yo, nice template, I have an action.");
        try {
            simulator.test("///bing.com").get();
            FileAssert.fail((String)"Whoa!! We should have failed so hard it isn't even funny.");
        }
        catch (Throwable throwable) {
            Assert.assertEquals(throwable.getClass(), AssertionError.class);
        }
    }

    @Test
    public void get_action_package_collision() throws Exception {
        this.test.simulate(() -> simulator.test("/foo/view/bar/baz").withURLSegment("42").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("/foo/view/bar/baz!", "42")).simulate(() -> simulator.test("/foo/view/bar/baz").get().assertStatusCode(200).assertBodyContains("/foo/view/bar/baz!", "empty")).simulate(() -> simulator.test("/foo/view/bar").withURLSegment("42").get().assertStatusCode(200).assertBodyContains("/foo/view/bar!", "42")).simulate(() -> simulator.test("/foo/view/bar").get().assertStatusCode(200).assertBodyContains("/foo/view/bar!", "empty")).simulate(() -> simulator.test("/foo/view").withURLSegment("42").get().assertStatusCode(200).assertBodyContains("/foo/view!", "42")).simulate(() -> simulator.test("/foo/view").get().assertStatusCode(200).assertBodyContains("/foo/view!", "empty")).simulate(() -> simulator.test("/foo").withURLSegment("42").get().assertStatusCode(200).assertBodyContains("/foo!", "42")).simulate(() -> simulator.test("/foo").get().assertStatusCode(200).assertBodyContains("/foo!", "empty"));
    }

    @Test
    public void get_action_unknownParameters() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/allow-unknown-parameters").withURLParameter("foo", "bar").get().assertStatusCode(200));
    }

    @Test
    public void get_collectionConverter() throws Exception {
        this.test.simulate(() -> simulator.test("/collection-converter").withURLParameter("string", "foo,bar,baz").get().assertStatusCode(500));
        this.test.simulate(() -> simulator.test("/collection-converter").withURLParameter("string", "bar").withURLParameter("string", "baz").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(500));
        this.test.simulate(() -> simulator.test("/collection-converter").withURLParameter("strings", "bar").withURLParameter("strings", "baz").get().assertStatusCode(200).assertBodyDoesNotContain("__empty2__', '__empty3__").assertBodyContains("__empty1__").assertBodyContains("[bar, baz]").assertBodyContains("<input type=\"text\" id=\"string\" name=\"string\"/>").assertBodyContains("<input type=\"text\" id=\"strings\" name=\"strings\" value=\"bar\"/").assertBodyContains("<input type=\"text\" id=\"strings\" name=\"strings\" value=\"baz\"/"));
        this.test.simulate(() -> simulator.test("/collection-converter").withURLParameter("strings", "foo,bar,baz").get().assertStatusCode(200).assertBodyDoesNotContain("__empty2__', '__empty3__").assertBodyContains("__empty1__").assertBodyContains("[foo,bar,baz]").assertBodyContains("<input type=\"text\" id=\"string\" name=\"string\"/>").assertBodyContains("<input type=\"text\" id=\"strings\" name=\"strings\" value=\"foo,bar,baz\"/"));
    }

    @Test
    public void get_default_results() {
        simulator.test("/default-forward-result").get().assertStatusCode(200).assertBody("Default Forward");
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/default-forward-result").withURLParameter("resultCode", "foo").get().assertStatusCode(200).assertBody("Default Forward");
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/requested-default-status-result").get().assertStatusCode(200).assertBodyIsEmpty();
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/requested-default-status-result").withURLParameter("resultCode", "foo").get().assertStatusCode(201).assertBodyIsEmpty();
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/requested-default-forward-result").get().assertStatusCode(200).assertBody("Hi!\n");
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/requested-default-forward-result").withURLParameter("resultCode", "foo").get().assertStatusCode(201).assertBody("Hi!\n");
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        simulator.test("/requested-default-forward-result-no-template").withURLParameter("resultCode", "foo").get().assertStatusCode(500);
        PrimeBaseTest.TestUnhandledExceptionHandler.assertLastUnhandledException((Exception)new PrimeException("Missing result for action class [org.example.action.RequestedDefaultForwardResultNoTemplateAction] URI [/requested-default-forward-result-no-template] and result code [foo]"));
    }

    @Test
    public void get_developmentExceptions() {
        simulator.test("/invalid-api/42").get().assertStatusCode(500);
        simulator.test("/invalid-api").withURLParameter("bad-param", "42").get().assertStatusCode(500);
    }

    @Test
    public void get_execute_redirect() throws Exception {
        this.test.simulate(() -> simulator.test("/temp-redirect").get().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertRedirect("/temp-redirect-target").executeRedirect(requestResult -> requestResult.assertStatusCode(302).assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertRedirect("/temp-redirect-target-target").executeRedirect(requestResult2 -> requestResult2.assertStatusCode(200).assertBodyContains("Look Ma, I'm redirected.").assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertBodyContainsMessagesFromKey("[ERROR]", "[INFO]", "[WARNING]").assertBodyContains("Error 3", "Info 3", "Warning 3").executeFormPostInResponseBody("form", requestResult -> requestResult.assertStatusCode(200).assertBodyContains("textValue", "disabledEmpty", "hiddenValue", "noNameEmpty", "radioValue2", "checkboxValue2", "selectedValueOptionB", "textareaValue").assertBodyDoesNotContain("disabledValue", "radioValue1", "checkboxValue1", "noNameValue", "selectEmpty")))));
    }

    @Test
    public void get_execute_relativeRedirect() throws Exception {
        this.test.simulate(() -> simulator.test("/temp-relative-redirect").get().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertRedirect("temp-redirect-target").executeRedirect(requestResult -> requestResult.assertStatusCode(302).assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertRedirect("/temp-redirect-target-target").executeRedirect(requestResult2 -> requestResult2.assertStatusCode(200).assertBodyContains("Look Ma, I'm redirected.").assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]").assertBodyContainsMessagesFromKey("[ERROR]", "[INFO]", "[WARNING]").assertBodyContains("Error 3", "Info 3", "Warning 3").executeFormPostInResponseBody("form", requestResult -> requestResult.assertStatusCode(200).assertBodyContains("textValue", "disabledEmpty", "noNameEmpty", "hiddenValue", "radioValue", "checkboxValue", "textareaValue").assertBodyDoesNotContain("disabledValue", "noNameValue")))));
    }

    @Test(enabled=false)
    public void get_expressionEvaluatorSkippedUsesRequest() throws Exception {
        this.test.simulate(() -> simulator.test("/value-in-request").get().assertBodyContains("baz"));
    }

    @Test
    public void get_freemarker_double_escape() {
        simulator.test("/freemarker/double-escape").get().assertStatusCode(500);
    }

    @Test(dataProvider="get_freemarker_escape_parameters")
    public void get_freemarker_escape(String string, boolean bl) {
        if (bl) {
            simulator.test("/freemarker/escape").withURLParameter("mode", string).get().assertStatusCode(200).assertBodyContains("Output format: HTML", "Auto-escaping: true", "Select\u2026", ", ", "&lt;p&gt;Are you sure?&lt;/p&gt;", "Hello, to access your account go to &lt;a href=&quot;https://foo.com&quot;&gt;foo.com&lt;/a&gt;.", "Dismiss", "Ignore").assertBodyDoesNotContain("<p>Are you sure?</p>", "Hello, to access your account go to <a href=\"https://foo.com\">foo.com</a>.", "freemarker.core.TemplateHTMLOutputModel");
        } else {
            simulator.test("/freemarker/escape").withURLParameter("mode", string).get().assertStatusCode(200).assertBodyContains("Output format: HTML", "Auto-escaping: true", "Select\u2026", ", ", "<p>Are you sure?</p>", "Hello, to access your account go to <a href=\"https://foo.com\">foo.com</a>.", "Dismiss", "Ignore").assertBodyDoesNotContain("&lt;p&gt;Are you sure?&lt;/p&gt;", "Hello, to access your account go to &lt;a href=&quot;https://foo.com&quot;&gt;foo.com&lt;/a&gt;.", "freemarker.core.TemplateHTMLOutputModel");
        }
    }

    @DataProvider
    public Object[][] get_freemarker_escape_parameters() {
        return new Object[][]{{"message", false}, {"function", true}, {"functionUnescaped", false}, {"directProperties", true}, {"indirectProperties", true}};
    }

    @Test
    public void get_fullFormWithAllAttributes() throws Exception {
        simulator.test("/user/full-form").get().assertBody(Files.readString(Path.of("src/test/resources/html/full-form.html", new String[0])).trim());
    }

    @Test
    public void get_fuzzing_invalid_expression() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = true;
        this.test.simulate(() -> simulator.test("/vanilla").withURLParameter("class.method", "foo").get().assertStatusCode(200));
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/vanilla").withURLParameter("class.method", "foo").get().assertStatusCode(500));
        PrimeBaseTest.TestUnhandledExceptionHandler.assertLastUnhandledException((Exception)new InvalidExpressionException("The expression string [class.method] is invalid."));
    }

    @Test
    public void get_fuzzing_invalid_expression_2() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = true;
        this.test.simulate(() -> simulator.test("/user/edit").withURLParameter("user", "org.example.domain.User").get().assertStatusCode(200));
        PrimeBaseTest.TestUnhandledExceptionHandler.assertNoUnhandledException();
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/user/edit").withURLParameter("user", "org.example.domain.User").get().assertStatusCode(200));
        PrimeBaseTest.TestUnhandledExceptionHandler.assertLastUnhandledException((Exception)new ConverterStateException("While evaluating the expression [user] in class [org.example.action.user.EditAction]. No type converter found for the type [org.example.domain.User]."));
    }

    @Test
    public void get_index() throws Exception {
        this.test.simulate(() -> simulator.test("/user/").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Yeah!"));
        this.test.simulate(() -> simulator.test("/user").get().assertStatusCode(301).assertRedirect("/user/"));
    }

    @Test
    public void get_jwtAuthorized() throws Exception {
        JwtAuthorizedAction.authorized = true;
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "jWt eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "bEaReR eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "Bearer ").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "Bearer").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "Bearer Foo").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT ").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT Foo").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtDisabledJwtAuthentication() throws Exception {
        this.test.simulate(() -> simulator.test("/jwt-authorized-disabled").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertStatusCode(401));
        this.test.simulate(() -> simulator.test("/jwt-authorized-disabled").withHeader("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtExpired() throws Exception {
        this.test.simulate(() -> simulator.test("/jwt-authorized").withURLParameter("authorized", true).withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE0NDUxMDA3MzF9.K18gIegEBfxgj8rU4D2WDh3CzEmRUmy8qBS7SWAcG9w").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtInvalidSignature() throws Exception {
        this.test.simulate(() -> simulator.test("/jwt-authorized").withURLParameter("authorized", true).withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.aaabbbcccddd").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtMissingAuthorizeHeader() throws Exception {
        JwtAuthorizedAction.authorized = true;
        this.test.simulate(() -> simulator.test("/jwt-authorized").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtNotAuthorized() throws Exception {
        JwtAuthorizedAction.authorized = false;
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertStatusCode(401));
    }

    @Test
    public void get_jwtNotBefore() throws Exception {
        JwtAuthorizedAction.authorized = true;
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJuYmYiOjQ2MzIzOTY2NjV9.mRvvyJXvDD8RQ_PM1TadZdZNYXRa9CjOx62Tk866538").get().assertStatusCode(401));
    }

    @Test
    public void get_jwt_jwtEnabled_deprecated() throws Exception {
        this.test.simulate(() -> simulator.test("/jwt-authorized-deprecated").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200));
    }

    @Test
    public void get_jwt_other_scheme() throws Exception {
        this.test.simulate(() -> simulator.test("/jwt-authorized-other").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200));
    }

    @Test
    public void get_largeFTL() {
        simulator.test("/large-ftl").get().assertStatusCode(200).assertBodyContains("large FTL");
    }

    @Test
    public void get_message_callback() throws Exception {
        this.test.simulate(() -> simulator.test("/callback").get().assertStatusCode(200).assertContainsGeneralMessageCodes(MessageType.ERROR, "[ERROR]").assertContainsGeneralMessageCodes(MessageType.INFO, "[INFO]").assertContainsGeneralMessageCodes(MessageType.WARNING, "[WARNING]"));
    }

    @Test
    public void get_metrics() throws Exception {
        simulator.test("/user/full-form").get().assertBody(Files.readString(Path.of("src/test/resources/html/full-form.html", new String[0])).trim());
        SortedMap sortedMap = metricRegistry.getTimers();
        Assert.assertEquals((long)((Timer)sortedMap.get("prime-mvc.[/user/full-form].requests")).getCount(), (long)1L);
        Assert.assertEquals((long)((Timer)sortedMap.get("prime-mvc.[*].requests")).getCount(), (long)1L);
    }

    @Test
    public void get_metricsErrors() {
        simulator.test("/execute-method-throws-exception").get().assertStatusCode(500);
        SortedMap sortedMap = metricRegistry.getTimers();
        Assert.assertEquals((long)((Timer)sortedMap.get("prime-mvc.[/execute-method-throws-exception].requests")).getCount(), (long)1L);
        SortedMap sortedMap2 = metricRegistry.getMeters();
        Assert.assertEquals((long)((Meter)sortedMap2.get("prime-mvc.[/execute-method-throws-exception].errors")).getCount(), (long)1L);
        Assert.assertEquals((long)((Meter)sortedMap2.get("prime-mvc.[*].errors")).getCount(), (long)1L);
    }

    @Test
    public void get_modifyRequest() throws Exception {
        simulator.test("/foo").get().assertStatusCode(200).custom(requestResult -> Assert.assertEquals((String)requestResult.request.getHeader("X-Test-HTTP-Request-Consumer"), (String)"true"));
    }

    @Test
    public void get_nested_parameters() throws Exception {
        this.test.simulate(() -> simulator.test("/nested").withURLSegment("42").withURLSegment("99").withURLSegment("parameter").withURLSegment("foo").withURLSegment("bar").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200).assertBodyContains("Success!", "preParam1=42", "preParam2=99", "endParam1=foo", "endParam2=bar"));
    }

    @Test
    public void get_nonFormFields() throws Exception {
        simulator.test("/user/details-fields").get().assertBodyFile(Path.of("src/test/resources/html/details-fields.html", new String[0]), new Object[0]);
    }

    @Test
    public void get_objectMapValues() throws Exception {
        this.test.simulate(() -> simulator.test("/object-map-values").get().assertStatusCode(200).assertBodyContains("Name:foo.data.preferences.coffee.style", ":Value::Value:"));
    }

    @Test
    public void get_onlyKnownParameters() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/only-known-parameters").withParameter("foo", "bar").withParameter("foo", "baz").withParameter("foo.bar", "baz").withParameter("foo/0/bar/bam", "purple").post().assertStatusCode(500).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test
    public void get_overrideClassNameForURI() throws Exception {
        this.test.simulate(() -> simulator.test("/OverrideMe").get().assertStatusCode(200).assertBodyIsEmpty());
        Assert.assertTrue((boolean)OverrideMeAction.invoked);
        OverrideMeAction.invoked = false;
        boolean bl = false;
        try {
            this.test.simulate(() -> simulator.test("/override-me").get().assertStatusCode(404).assertBodyIsEmpty());
            bl = true;
        }
        catch (Error error) {
            // empty catch block
        }
        if (bl) {
            FileAssert.fail((String)"Expected a failure!");
        }
    }

    @Test
    public void get_percent_encoded_segment() throws Exception {
        this.test.simulate(() -> simulator.test("/foo/view").withURLSegment("<strong>foo</strong>").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("/foo/view!", "id=&lt;strong&gt;foo&lt;/strong&gt;"));
        this.test.simulate(() -> simulator.test("/foo/view/%3Cstrong%3Efoo%3C%2Fstrong%3E").get().assertStatusCode(200).assertBodyContains("/foo/view!", "id=&lt;strong&gt;foo&lt;/strong&gt;"));
    }

    @Test
    public void get_postParameterBeforeFormPrepare() throws Exception {
        this.test.simulate(() -> simulator.test("/scope/page-two").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("postParameterMethodCalled:first").assertBodyContains("formPrepareMethodCalled:second")).simulate(() -> simulator.test("/scope/page-one").get().assertStatusCode(200).assertBodyContains("postParameterMethodCalled:first").assertBodyContains("formPrepareMethodCalled:second"));
    }

    @Test
    public void get_preRender() {
        simulator.test("/pre-render-method").withURLParameter("result", "forward").get().assertStatusCode(200).assertContentType("text/html; charset=UTF-8").assertBodyContains("Forward_Yep!", "JSON_Nope!", "Noop_Nope!");
        simulator.test("/pre-render-method").withURLParameter("result", "json").get().assertStatusCode(200).assertContentType("application/json; charset=UTF-8").assertBodyContains("trust me it is json");
        simulator.test("/pre-render-method").withURLParameter("result", "noop").get().assertStatusCode(201).assertContentType("application/potato").assertBodyContains("You've been no-oped!");
    }

    @Test
    public void get_redirect() throws Exception {
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo").get().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/foo"));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz").get().assertStatusCode(302).assertRedirect("/foo?bar=baz").assertRedirect("/foo", testURIBuilder -> testURIBuilder.with("bar", "baz")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz").get().assertStatusCode(302).assertRedirect("/foo?bar=baz").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginQuery().with("bar", (Object)"baz")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz&boom=dynamite").get().assertStatusCode(302).assertRedirect("/foo?bar=baz&boom=dynamite").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginQuery().with("bar", (Object)"baz").with("boom", (Object)"dynamite")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo#bar=baz").get().assertStatusCode(302).assertRedirect("/foo#bar=baz").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginFragment().with("bar", (Object)"baz")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo#bar=baz&boom=dynamite").get().assertStatusCode(302).assertRedirect("/foo#bar=baz&boom=dynamite").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginFragment().with("bar", (Object)"baz").with("boom", (Object)"dynamite")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz#middle=out").get().assertStatusCode(302).assertRedirect("/foo?bar=baz#middle=out").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginQuery().with("bar", (Object)"baz").beginFragment().with("middle", (Object)"out")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz&boom=dynamite#middle=out&not=hotdog").get().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/foo?bar=baz&boom=dynamite#middle=out&not=hotdog").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginQuery().with("bar", (Object)"baz").with("boom", (Object)"dynamite").beginFragment().with("middle", (Object)"out").with("not", (Object)"hotdog")));
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz&q=foo&code=bar").get().assertStatusCode(302).assertRedirect("/foo?bar=baz&q=foo&code=bar").assertRedirect("/foo", testURIBuilder -> testURIBuilder.beginQuery().with("bar", (Object)"baz").with("q", (Object)"foo").with("code", (Object)"bar")));
        try {
            this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bar=baz&q=foo&code=bar").get().assertStatusCode(302).assertRedirect("/foo"));
            FileAssert.fail((String)"Expected a failure.");
        }
        catch (Error error) {
            Assert.assertEquals(error.getClass(), AssertionError.class);
        }
    }

    @Test
    public void get_redirect_flash_scope_messageLookup() throws Exception {
        simulator.test("/flash-scope/redirect").get().assertStatusCode(302).assertContainsGeneralMessageCodes(MessageType.INFO, "[FlashScopeMessageKey]").assertRedirect("/flash-scope/").executeRedirectReturnResult(requestResult -> requestResult.assertStatusCode(200).assertContainsGeneralMessageCodes(MessageType.INFO, "[FlashScopeMessageKey]").assertBodyContainsMessagesFromKey("[FlashScopeMessageKey]", new Object[0]).assertBody("This is an index page.\n\n  Info:This is a message!\n\n"));
    }

    @Test
    public void get_redirect_withActual() throws Exception {
        this.test.simulate(() -> simulator.test("/complex-redirect").withURLParameter("redirectURI", "/foo?bing=bam&instant=" + System.currentTimeMillis()).get().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/foo", testURIBuilder -> testURIBuilder.withActual("instant").with("bing", "bam")));
    }

    @Test
    public void get_redirects_nested() throws Exception {
        this.test.simulate(() -> simulator.test("/router/redirect").get().assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/2").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/3").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/4").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/5").followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyIsEmpty()))))));
        this.test.simulate(() -> simulator.test("/router/redirect").get().assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/2")).followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/3")).followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/4")).followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/5")).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyIsEmpty()));
        this.test.simulate(() -> simulator.test("/router/redirect/").get().assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/2").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/3").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/4").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/5"))))).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyIsEmpty()));
        this.test.simulate(() -> simulator.test("/router/submit-form").get().assertStatusCode(200).assertHTML(hTMLAsserter -> hTMLAsserter.assertElementExists("form")).submitForm("form", requestResult3 -> requestResult3.assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/2").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/3").followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/4").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/5"))))).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyIsEmpty())));
        this.test.simulate(() -> simulator.test("/router/meta-refresh").get().assertStatusCode(200).assertHTML(hTMLAsserter -> hTMLAsserter.assertElementExists("meta[http-equiv=Refresh]")).followMetaRefresh(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult3 -> requestResult3.assertStatusCode(302).assertRedirect("/router/redirect/2").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/3")).followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/4").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/5")))).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyIsEmpty())));
        this.test.simulate(() -> simulator.test("/router/meta-refresh").get().assertStatusCode(200).assertHTML(hTMLAsserter -> hTMLAsserter.assertElementExists("meta[http-equiv=Refresh]")).followMetaRefresh().assertStatusCode(302).assertRedirect("/router/redirect/1").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/2").followRedirect().assertStatusCode(302).assertRedirect("/router/redirect/3")).followRedirect(requestResult2 -> requestResult2.assertStatusCode(302).assertRedirect("/router/redirect/4").followRedirect(requestResult -> requestResult.assertStatusCode(302).assertRedirect("/router/redirect/5"))).followRedirect().assertStatusCode(200).assertBodyIsEmpty());
    }

    @Test
    public void get_secure() throws Exception {
        this.test.simulate(() -> simulator.test("/secure").get().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(401));
    }

    @Test
    public void get_template_noAction() throws Exception {
        simulator.test("/freemarker/stand-alone-template").get().assertStatusCode(200).assertBodyContains("Yo, nice template.");
        simulator.test("/freemarker/missing-message-template").get().assertStatusCode(200).assertBodyContains("Yo, nice template.", "the default message");
        simulator.test("/freemarker//stand-alone-template").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Yo, nice template.");
        simulator.test("/freemarker///stand-alone-template").get().assertStatusCode(200).assertBodyContains("Yo, nice template.");
        simulator.test("/freemarker//sub//stand-alone-template").get().assertStatusCode(200).assertBodyContains("Yo, nice sub-directory template.");
        try {
            simulator.test("/freemarker//does-not-exist").get().assertStatusCode(301).assertRedirect("/freemarker/does-not-exist");
            FileAssert.fail((String)"Expected a failure.");
        }
        catch (Error error) {
            Assert.assertEquals(error.getClass(), AssertionError.class);
        }
        try {
            simulator.test("/freemarker/sub//").get().assertStatusCode(301).assertRedirect("/freemarker/sub/").assertHeaderDoesNotContain("Cache-Control").executeRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyContains("Yo, nice sub-directory index template."));
            FileAssert.fail((String)"Expected a failure.");
        }
        catch (Error error) {
            Assert.assertEquals(error.getClass(), AssertionError.class);
        }
    }

    @Test
    public void get_underscore() {
        simulator.test("/test_underscore").get().assertStatusCode(200);
    }

    @Test
    public void get_unknownParameters() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/unknown-parameters").withParameter("foo", "bar").withParameter("foo", "baz").withParameter("foo.bar", "baz").withParameter("foo/0/bar/bam", "purple").post().assertStatusCode(200).assertBodyContains("foo => [bar,baz]", "foo.bar => [baz]", "foo/0/bar/bam => [purple]"));
    }

    @Test
    public void get_url_rewrite() {
        simulator.test("/doesNotExist?__a_foo=/user/edit&foo=true").get().assertStatusCode(404).assertContainsNoFieldMessages().assertBodyContains("The page is missing!");
        AssertJUnit.assertFalse((boolean)EditAction.getCalled);
    }

    @Test
    public void get_wellKnownDotPrefixed() throws Exception {
        this.test.simulate(() -> simulator.test("/.well-known/openid-configuration").get().assertStatusCode(200).assertJSON("{\"called\": \"/.well-known/openid-configuration\"}"));
        this.test.simulate(() -> simulator.test("/.well-known/well-known/openid-configuration").get().assertStatusCode(200).assertJSON("{\"called\": \"/.well-known/well-known/openid-configuration\"}"));
        this.test.simulate(() -> simulator.test("/.well-known/well-known/.well-known/openid-configuration").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSON("{\"called\": \"/.well-known/well-known/potato/openid-configuration\"}"));
        this.test.simulate(() -> simulator.test("/.well-known/.well-known/openid-configuration").get().assertStatusCode(404));
    }

    @Test
    public void hacked() {
        simulator.test("/hacked").get().assertStatusCode(500).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Instantiating freemarker.template.utility.Execute is not allowed in the template for security reasons.");
    }

    @Test
    public void head() {
        simulator.test("/head").head().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyIsEmpty();
    }

    @Test
    public void head_jwtAuthorized() throws Exception {
        JwtAuthorizedAction.authorized = true;
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").head().assertHeaderContains("Cache-Control", "no-cache").assertStatusCode(200));
    }

    @Test
    public void head_jwtNotAuthorized() throws Exception {
        JwtAuthorizedAction.authorized = false;
        this.test.simulate(() -> simulator.test("/jwt-authorized").withHeader("Authorization", "JWT eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894").head().assertStatusCode(401).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test(enabled=false)
    public void manual_tooManyOpenFiles() throws Exception {
        int n;
        for (n = 0; n < 250000; ++n) {
            if (n % 5000 == 0) {
                System.out.println("Iteration [" + n + "]....");
            }
            try {
                Socket socket = new Socket();
                socket.setSoLinger(true, 0);
                socket.connect(new InetSocketAddress("localhost", 8080));
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write("POST /inform HTTP/1.1\r\nHost: 192.168.1.44:8080\r\nAccept: */*\r\nContent-Length: 8588\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                if (n % 100 != 0) continue;
                socket.close();
                continue;
            }
            catch (Exception exception) {
                System.out.println("[Test Exception] [" + exception.getMessage() + "]");
            }
        }
        n = 0;
        while (n == 0) {
            System.out.println("Waiting.... kill the test, or pause the debugger and set finish = true.");
            Thread.sleep(10000L);
        }
    }

    @Test
    public void missing() {
        simulator.test("/missing").get().assertStatusCode(404).assertBodyContains("The page is missing!");
        simulator.test("/also-missing").get().assertStatusCode(404).assertBodyContains("The page is missing!");
    }

    @Test
    public void multipleJSONRequestMembers() throws Exception {
        simulator.test("/multiple-json-request").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache");
        simulator.test("/multiple-json-request").withJSON(new Object()).post().assertStatusCode(201).assertHeaderContains("Cache-Control", "no-cache");
        simulator.test("/multiple-json-request").withJSON(new Object()).delete().assertStatusCode(202).assertHeaderContains("Cache-Control", "no-cache");
    }

    @Test
    public void notAllowed() {
        simulator.test("/not-allowed").get().assertStatusCode(405).assertHeaderContains("Cache-Control", "no-cache");
        simulator.test("/not-allowed").post().assertStatusCode(405);
        simulator.test("/not-allowed").put().assertStatusCode(405);
        simulator.test("/not-allowed").delete().assertStatusCode(405);
        simulator.test("/not-allowed").head().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache");
    }

    @Test
    public void notImplemented() {
        simulator.test("/not-allowed").method("POTATO").assertStatusCode(501).assertHeaderContains("Cache-Control", "no-cache");
    }

    @Test
    public void parameter_order_of_operation() throws Exception {
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLSegment("segment").withURLParameter("value", "parameter").withContentType("application/x-www-form-urlencoded").withBody("value=body\n").post().assertStatusCode(200).assertBodyContains("value:parameter,body"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLSegment("segment").withURLParameter("value", "parameter").post().assertStatusCode(200).assertBodyContains("value:parameter"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLSegment("segment").withContentType("application/x-www-form-urlencoded").withBody("value=body\n").post().assertStatusCode(200).assertBodyContains("value:body"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLParameter("value", "parameter").withContentType("application/x-www-form-urlencoded").withBody("value=body\n").post().assertStatusCode(200).assertBodyContains("value:parameter,body"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withContentType("application/x-www-form-urlencoded").withBody("value=body\n").post().assertStatusCode(200).assertBodyContains("value:body"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLSegment("segment").post().assertStatusCode(200).assertBodyContains("value:segment"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withURLParameter("value", "parameter").post().assertStatusCode(200).assertBodyContains("value:parameter"));
    }

    @Test
    public void post() {
        simulator.test("/post").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Brian Pontarelli", "35", "Broomfield", "CO");
    }

    @Test
    public void post_JSONWithActual() throws Exception {
        simulator.test("/api").withJSONFile(Path.of("src/test/resources/json/api-jsonWithActual-post.json", new String[0]), new Object[0]).post().assertHeaderContains("Cache-Control", "no-cache").assertJSONFileWithActual(UserField.class, Path.of("src/test/resources/json/api-jsonWithActual-post-response.ftl", new String[0]), new Object[0]);
        simulator.test("/api-final").withJSONFile(Path.of("src/test/resources/json/api-jsonWithActual-post.json", new String[0]), new Object[0]).post().assertJSONFileWithActual(UserField.class, Path.of("src/test/resources/json/api-jsonWithActual-post-response.ftl", new String[0]), new Object[0]);
    }

    @Test
    public void post_anyContentType() throws Exception {
        this.test.createFile("Hello World").simulate(() -> simulator.test("/file-upload").withFile("dataAnyType", this.test.tempFile, "text/plain").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache")).simulate(() -> simulator.test("/file-upload").withFile("dataAnyType", this.test.tempFile, "text/html").post().assertStatusCode(200)).simulate(() -> simulator.test("/file-upload").withFile("dataAnyType", this.test.tempFile, "application/octet-stream").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test
    public void post_apiJSONBothWays() throws Exception {
        Path path = Path.of("src/test/resources/json/api-jsonBothWays-post.json", new String[0]);
        simulator.test("/api").withJSONFile(path, new Object[0]).post().assertJSONFile(path, new Object[0]);
    }

    @Test
    public void post_binary() throws Exception {
        this.test.simulate(() -> simulator.test("/binary").withURLParameter("expected", "Hello World").withBody("Hello World").withContentType("application/octet-stream").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test
    public void post_binary_no_body() throws Exception {
        this.test.simulate(() -> simulator.test("/binary").withURLParameter("expectedNullFile", "true").withContentType("application/octet-stream").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache"));
    }

    @Test
    public void post_chunked_json() throws Exception {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.of(500L, ChronoUnit.MILLIS)).build();
        HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(URI.create("http://localhost:9080/api")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(this.readBytes("src/test/resources/json/api-jsonWithActual-post.json")))).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
        Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
    }

    @Test
    public void post_collectionConverter() throws Exception {
        this.test.simulate(() -> simulator.test("/collection-converter").withParameter("strings", "foo,bar,baz").post().assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/collection-converter").withParameter("strings", "bar").withParameter("strings", "baz").post().assertStatusCode(200));
    }

    @Test
    public void post_cookies() throws Exception {
        this.test.simulate(() -> simulator.test("/cookie").withParameter("name", "token").withParameter("value", "secret").withParameter("saveMe", "save a value").post().assertStatusCode(200).assertBodyIsEmpty().assertCookie("token", "secret").assertContainsCookie("org.example.action.CookieAction$saveMe")).simulate(() -> simulator.test("/cookie").get().assertStatusCode(200).assertBodyContains("Count:2", "token:secret", "org.example.action.CookieAction$saveMe:").assertDoesNotContainsCookie("token")).simulate(() -> simulator.test("/cookie").withParameter("clearSaveMe", true).post().assertStatusCode(200).assertBodyIsEmpty().assertContainsCookie("org.example.action.CookieAction$saveMe")).simulate(() -> simulator.test("/cookie").get().assertBodyContains("Count:1", "token:secret").assertBodyDoesNotContain("org.example.action.CookieAction$saveMe:").assertDoesNotContainsCookie("org.example.action.CookieAction$saveMe")).simulate(() -> simulator.test("/cookie").withParameter("u.bar", "baz").post().assertStatusCode(200).assertBodyIsEmpty().assertContainsCookie("org.example.action.CookieAction$u")).simulate(() -> simulator.test("/cookie").get().assertStatusCode(200).assertBodyContains("Count:2", "token:secret", "org.example.action.CookieAction$u:").assertDoesNotContainsCookie("token")).simulate(() -> simulator.test("/cookie").withParameter("list[0]bar", "bing").withParameter("list[1]bar", "boom").post().assertStatusCode(200).assertBodyIsEmpty().assertContainsCookie("org.example.action.CookieAction$list")).simulate(() -> simulator.test("/cookie").get().assertStatusCode(200).assertBodyContains("Count:3", "token:secret", "org.example.action.CookieAction$list:", "org.example.action.CookieAction$u:").assertDoesNotContainsCookie("token")).simulate(() -> simulator.test("/cookie").withURLParameter("blowChunks", true).get().assertStatusCode(200).assertContainsGeneralErrorMessageCodes("[CookieErrorException]").assertBodyContainsMessagesFromKey("[CookieErrorException]", new Object[0]).assertBodyContains("Error count:1")).simulate(() -> simulator.test("/cookie").withURLParameter("addMessage", true).post().assertStatusCode(302).assertRedirect("/cookie").assertContainsGeneralInfoMessageCodes("[NobodyDrinkTheBeer]").executeRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyContains("Count:3", "token:secret", "org.example.action.CookieAction$list:", "org.example.action.CookieAction$u:").assertContainsGeneralInfoMessageCodes("[NobodyDrinkTheBeer]")));
    }

    @Test
    public void post_couldNotConvert() throws Exception {
        this.test.simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap1['foo']", "bar").post().assertStatusCode(200).assertContainsFieldErrors("integerMap1['foo']").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerMap1[]")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap1['bar']", "baz").post().assertStatusCode(200).assertContainsFieldErrors("integerMap1['bar']").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerMap1['bar']")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap2['baz']", "bing").post().assertStatusCode(200).assertContainsFieldErrors("integerMap2['baz']").assertBodyContains("Value Baz (java.lang.NumberFormatException: For input string: &quot;bing&quot;")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap1[foo2]", "bar").post().assertStatusCode(200).assertContainsFieldErrors("integerMap1[foo2]").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerMap1[]")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap1[bar2]", "baz").post().assertStatusCode(200).assertContainsFieldErrors("integerMap1[bar2]").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerMap1[bar2]")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerMap2[baz2]", "bing").post().assertStatusCode(200).assertContainsFieldErrors("integerMap2[baz2]").assertBodyContains("Value Baz (java.lang.NumberFormatException: For input string: &quot;bing&quot;")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerList1[0]", "bar").post().assertStatusCode(200).assertContainsFieldErrors("integerList1[0]").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerList1[]")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerList1[1]", "baz").post().assertStatusCode(200).assertContainsFieldErrors("integerList1[1]").assertBodyContainsMessagesFromKeys("[couldNotConvert]integerList1[1]")).simulate(() -> simulator.test("/could-not-convert").withParameter("integerList2[0]", "bing").post().assertStatusCode(200).assertContainsFieldErrors("integerList2[0]").assertBodyContains("List 2 - Int 1 (java.lang.NumberFormatException: For input string: &quot;bing&quot;"));
    }

    @Test
    public void post_dateConversion() throws Exception {
        this.test.forEach("01-01-2018", "01-01-2018", "1-1-2018", "1/01/2018", "01/1/2018").test(string -> simulator.test("/date-time-converter").withParameter("localDate", string).withParameter("localDate@dateTimeFormat", "[MM/dd/yyyy][M/dd/yyyy][M/d/yyyy][MM-dd-yyyy][M-dd-yyyy][M-d-yyyy]").post().assertContainsNoFieldMessages().assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/date-time-converter").withParameter("localDate", "01/01/2018").withParameter("localDate@dateTimeFormat", "MM/dd/yyyy").post().assertContainsNoFieldMessages().assertStatusCode(200));
        this.test.forEach("07-08-2008 10:13:34 AM -0800", "07/08/2008 10:13:34 AM -0800", "7-8-2008 10:13:34 AM -0800", "7/8/2008 10:13:34 AM -0800").test(string -> simulator.test("/date-time-converter").withParameter("zonedDateTime", string).withParameter("zonedDateTime@dateTimeFormat", "[MM-dd-yyyy hh:mm:ss a Z][MM/dd/yyyy hh:mm:ss a Z][M/d/yyyy hh:mm:ss a Z][M-d-yyyy hh:mm:ss a Z]").post().assertContainsNoFieldMessages().assertStatusCode(200));
        this.test.simulate(() -> simulator.test("/date-time-converter").withParameter("zonedDateTime", "07-08-2008 10:13:34 AM -0800").withParameter("zonedDateTime@dateTimeFormat", "MM-dd-yyyy hh:mm:ss a Z").post().assertContainsNoFieldMessages().assertStatusCode(200));
    }

    @Test
    public void post_fieldNames() {
        GlobalTest.configuration.allowUnknownParameters = true;
        simulator.test("/field-name").withParameter("x-field", "value-field-a").withParameter("x-method", "value-method-a").withParameter("secondField", "value-field-b").withParameter("methodB", "value-method-b").withParameter("setfoo", "value-method-setfoo").withParameter("setBar", "value-method-setBar").withParameter("getBaz", "value-method-getBaz").withParameter("getboom", "value-method-getboom").withParameter("privateField", "value-private-field").withParameter("getValue", "value-method-getValue").withParameter("value2", "value-method-value2").withParameter("fieldA", "value-field-a-2").withParameter("fieldB", "value-field-b-2").post().assertStatusCode(200).assertBody("fieldA:null\nfieldB:null\nfieldB:value-field-b\nmethodA:value-method-a\nmethodB:value-method-b\nmethodC:null\nmethodC:null\nfoobar:null\nsomethingElse1:value-method-setfoo\nsomethingElse2:value-method-setBar\nsomethingElse3:value-method-getBaz\nsomethingElse4:value-method-getboom\nmethodE:value-method-getBaz\nmethodF:value-method-getboom\nmethodG:value-method-getValue\nmethodH:value-method-value2\n");
    }

    @Test
    public void post_fileUploadDisabled() throws Exception {
        this.test.createFile("Hello World").simulate(() -> simulator.test("/no-files").withFile("dataAnyType", this.test.tempFile, "text/plain").post().assertStatusCode(422)).createFile("Hello World").simulate(() -> simulator.test("/no-files-no-result-mapping").withFile("dataAnyType", this.test.tempFile, "text/plain").post().assertStatusCode(422));
    }

    @Test
    public void post_file_tooLarge() throws Exception {
        this.test.createFile("X".repeat(0x200000)).simulate(() -> simulator.test("/file-upload").withFile("dataAnyType", this.test.tempFile, "text/plain").post().assertStatusCode(413));
    }

    @Test
    public void post_freemarker_escape() throws Exception {
        simulator.test("/freemarker/escape").withParameter("listTest", "none").withParameter("listTest2", "none").post().assertStatusCode(200).assertHTML(hTMLAsserter -> hTMLAsserter.assertElementExists("input[name=listTest][value=none][checked]").assertElementExists("input[name=listTest2][value=none][checked]"));
    }

    @Test
    public void post_fuzzing_invalid_expression() throws Exception {
        GlobalTest.configuration.allowUnknownParameters = true;
        this.test.simulate(() -> simulator.test("/vanilla").withParameter("class.method", "foo").post().assertStatusCode(200));
        GlobalTest.configuration.allowUnknownParameters = false;
        this.test.simulate(() -> simulator.test("/vanilla").withParameter("class.method", "foo").post().assertStatusCode(500));
    }

    @Test
    public void post_generics() throws Exception {
        this.test.simulate(() -> simulator.test("/generics").withParameter("type", "one").withParameter("typedObject.mapOfTypes[49e0f299-a2b0-4439-b0d5-3e2cc8949675].one", "value").post().assertStatusCode(200).assertBodyContains("Map one = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.mapOfTypes[eee47c8b-4134-4c4d-ab28-cacaeed84cdb].two", "value").post().assertStatusCode(200).assertBodyContains("Map two = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.fullyGenericMapOfTypes[eee47c8b-4134-4c4d-ab28-cacaeed84cdb].two", "value").post().assertStatusCode(200).assertBodyContains("Map key/value = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.listOfStrings[0]", "value").post().assertStatusCode(200).assertBodyContains("List string = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.listOfTypes[0].two", "value").post().assertStatusCode(200).assertBodyContains("List two = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.singleString", "value").post().assertStatusCode(200).assertBodyContains("Single string = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.singleType.two", "value").post().assertStatusCode(200).assertBodyContains("Single two = value")).simulate(() -> simulator.test("/generics").withParameter("type", "one").withParameter("typedObject.privateMapOfTypes[49e0f299-a2b0-4439-b0d5-3e2cc8949675].one", "value").post().assertStatusCode(200).assertBodyContains("Private Map one = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateMapOfTypes[eee47c8b-4134-4c4d-ab28-cacaeed84cdb].two", "value").post().assertStatusCode(200).assertBodyContains("Private Map two = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateFullyGenericMapOfTypes[eee47c8b-4134-4c4d-ab28-cacaeed84cdb].two", "value").post().assertStatusCode(200).assertBodyContains("Private Map key/value = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateListOfStrings[0]", "value").post().assertStatusCode(200).assertBodyContains("Private List string = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateListOfTypes[0].two", "value").post().assertStatusCode(200).assertBodyContains("Private List two = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateSingleString", "value").post().assertStatusCode(200).assertBodyContains("Private Single string = value")).simulate(() -> simulator.test("/generics").withParameter("type", "two").withParameter("typedObject.privateSingleType.two", "value").post().assertStatusCode(200).assertBodyContains("Private Single two = value"));
    }

    @Test
    public void post_invalidJSON() throws Exception {
        this.test.simulate(() -> simulator.test("/invalid-json").withJSONFile(Path.of("src/test/resources/json/InvalidJsonAction.json", new String[0]), new Object[0]).post().assertStatusCode(400).assertContainsFieldErrors("active").assertContentType("application/json; charset=UTF-8").assertBodyContains("[invalidJSON]", "Unable to parse JSON. The property [active] was invalid. The error was [Possible conversion error]. The detailed exception was ["));
    }

    @Test
    public void post_jsonContentType() throws Exception {
        simulator.test("/json-content-type").withContentType("application/test+json").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[InvalidContentType]\",\n    \"message\" : \"Invalid [Content-Type] HTTP request header value of [application/test+json]. Supported values for this request include [application/json].\"\n  } ]\n}\n");
        simulator.test("/json-content-type-no-restriction").withContentType("application/json-patch+json").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[PatchNotSupported]\",\n    \"message\" : \"The [Content-Type] HTTP request header value of [application/json-patch+json] is not supported for this request.\"\n  } ]\n}\n");
        simulator.test("/json-content-type").withContentType("").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(400).assertJSON(" {\n   \"fieldErrors\" : { },\n   \"generalErrors\" : [ {\n     \"code\" : \"[MissingContentType]\",\n     \"message\" : \"Missing required [Content-Type] HTTP request header.\"\n   } ]\n }\n");
        simulator.test("/json-content-type").withContentType("application/x-www-form-urlencoded").post().assertStatusCode(200).assertBodyIsEmpty();
        simulator.test("/json-content-type").withContentType("application/klingon").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[InvalidContentType]\",\n    \"message\" : \"Invalid [Content-Type] HTTP request header value of [application/klingon]. Supported values for this request include [application/json].\"\n  } ]\n}\n");
        simulator.test("/json-content-type-no-restriction").withContentType("application/klingon").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(400).assertJSON(" {\n   \"fieldErrors\" : { },\n   \"generalErrors\" : [ {\n     \"code\" : \"[UnsupportedContentType]\",\n         \"message\" : \"Unsupported [Content-Type] HTTP request header value of [application/klingon].\"\n   } ]\n }\n");
        simulator.test("/hack-the-planet").withContentType("application/klingon").withBody("{\n  \"foo\": \"bar\"\n}\n").post().assertStatusCode(404).assertBodyContains("The page is missing!");
    }

    @Test
    public void post_lotsOfMessagesFromKeys() throws Exception {
        this.test.simulate(() -> simulator.test("/lots-of-messages").post().assertStatusCode(200).assertBodyContainsMessagesFromKeys("message1", "message2", "message3", "message4", "message5", "message6", "message7", "message8", "message9", "message10"));
        Assert.assertEquals((int)LotsOfMessagesAction.invocationCount.get(), (int)2);
    }

    @Test
    public void post_multipart_parameter_mix() throws Exception {
        this.test.createFile("Hello World").simulate(() -> simulator.test("/user/full-form").withParameter("roleIds", 21).withParameter("roleIds", 22).withURLParameter("ages", 42).withParameter("stringField", "hello with space").withFile("image", this.test.tempFile, "text/plain").post().assertStatusCode(200));
        Assert.assertEquals((int)FullFormAction.roleIdsFromLastPost.size(), (int)2);
        Assert.assertEquals((int)FullFormAction.agesFromLastPost.size(), (int)1);
        String string = Files.readString(FullFormAction.imageFromLastPost.getFile());
        Assert.assertEquals((String)string, (String)"Hello World");
        Assert.assertEquals((String)FullFormAction.stringFieldFromLastPost, (String)"hello with space");
    }

    @Test
    public void post_objectMapValues() throws Exception {
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.bar.baz", "bing").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-1-response.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.bar['baz']", "bing").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-2-response.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.bar['baz']", "bing").withParameter("foo.bar['baz']", "boom").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-3-response.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.bar[0]", "bing").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-4-response.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.bar[0]", "bing").withParameter("foo.bar[1]", "boom").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-5-response.json"), new Object[0]));
        this.test.simulate(() -> simulator.test("/object-map-values").withParameter("foo.data.preferences.coffee.style", "with cream").withParameter("foo.data.preferences.cars.count", 2).withParameter("foo.data.preferences.fruit", "oranges").withParameter("foo.data.preferences.fruit", "apples").withParameter("foo.data.preferences.fruit", "strawberries").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("ObjectMapValues-post-test-6-response.json"), new Object[0]));
    }

    @Test
    public void post_onlyAllowTextHTML() throws Exception {
        this.test.createFile("<strong>Hello World</strong>").simulate(() -> simulator.test("/file-upload").withFile("dataTextHtml", this.test.tempFile, "text/plain").post().assertStatusCode(400)).simulate(() -> simulator.test("/file-upload").withFile("dataTextHtml", this.test.tempFile, "text/html").post().assertStatusCode(200));
    }

    @Test
    public void post_savedRequest_cookieExpired_orCannotBeDeserialized() throws Exception {
        BaseStoreAction.loggedIn = false;
        this.test.simulate(() -> simulator.test("/store/purchase").withParameter("item", "beer").post().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/login").executeRedirect(requestResult -> requestResult.assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Login").setup(() -> configuration.regenerateCookieEncryptionKey()).executeFormPostInResponseBody("form", requestResult2 -> requestResult2.assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/").executeRedirect(requestResult -> requestResult.assertStatusCode(200).assertBodyContains("/store/index", "IsLoggedIn:true").assertBodyDoesNotContain("Buy:beer")))));
    }

    @Test(dataProvider="purchaseRoutes")
    public void post_savedRequest_crossOrigin(String string) throws Exception {
        BaseStoreAction.loggedIn = false;
        this.test.simulate(() -> simulator.test(string).withParameter("item", "beer").withSingleHeader("Origin", "https://hacked.com").post().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/login").followRedirect(requestResult -> requestResult.assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Login")).submitForm("form", requestResult -> requestResult.assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/")).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBody("/store/index\nIsLoggedIn:true").assertBodyDoesNotContain("Buy:beer")));
    }

    @Test
    public void post_savedRequest_sameOriginAllowed() throws Exception {
        BaseStoreAction.loggedIn = false;
        this.test.simulate(() -> simulator.test("/store/allow-post-purchase").withParameter("item", "beer").post().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/login").followRedirect(requestResult -> requestResult.custom(() -> Assert.assertEquals((String)requestResult.request.getHeader("Referer"), (String)"http://localhost:9080/store/allow-post-purchase")).assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Login")).submitForm("form", requestResult -> requestResult.assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/allow-post-purchase")).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBody("/store/purchase\nBuy:beer")));
    }

    @Test
    public void post_savedRequest_sameOriginDenied() throws Exception {
        BaseStoreAction.loggedIn = false;
        this.test.simulate(() -> simulator.test("/store/purchase").withParameter("item", "beer").post().assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/login").followRedirect(requestResult -> requestResult.assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertBodyContains("Login")).submitForm("form", requestResult -> requestResult.assertStatusCode(302).assertHeaderContains("Cache-Control", "no-cache").assertRedirect("/store/")).followRedirect(requestResult -> requestResult.assertStatusCode(200).assertBody("/store/index\nIsLoggedIn:true").assertBodyDoesNotContain("Buy:beer")));
    }

    @Test
    public void post_scopeStorage() throws Exception {
        this.test.simulate(() -> simulator.test("/scope-storage").post()).assertContextAttributeNotNull("contextObject");
    }

    @Test
    public void post_scopeStorageInBaseClass() throws Exception {
        this.test.simulate(() -> simulator.test("/extended-scope-storage").post()).assertContextAttributeNotNull("contextObject").simulate(() -> simulator.test("/extended-scope-storage").get()).assertContextAttributeNotNull("contextObject").simulate(() -> simulator.test("/another-extended-scope-storage").get()).assertContextAttributeNotNull("contextObject");
    }

    @Test
    public void post_unsupported_multipleParameters() throws Exception {
        this.test.simulate(() -> simulator.test("/parameter-handler").withParameter("uuidValue", UUID.randomUUID()).withParameter("uuidValue", UUID.randomUUID()).post().assertStatusCode(500).assertBodyIsEmpty());
        PrimeBaseTest.TestUnhandledExceptionHandler.assertLastUnhandledException((Exception)new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type UUID. This isn't allowed. Action class [org.example.action.ParameterHandlerAction] Request URI [/parameter-handler] Parameter name [uuidValue]"));
        this.test.simulate(() -> simulator.test("/parameter-handler").withParameter("enumValue", (Object)ParameterHandlerAction.Fruit.Orange).withParameter("enumValue", (Object)ParameterHandlerAction.Fruit.Apple).post().assertStatusCode(500).assertBodyIsEmpty());
        PrimeBaseTest.TestUnhandledExceptionHandler.assertLastUnhandledException((Exception)new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type Enum. This isn't allowed. Action class [org.example.action.ParameterHandlerAction] Request URI [/parameter-handler] Parameter name [enumValue]"));
    }

    @Test
    public void post_withURLParameter_IndexAmbiguity() {
        simulator.test("/api/action-value/login/").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/login", "potato:null", "userId:null");
        simulator.test("/api/action-value/login/index").post().assertStatusCode(200).assertContainsFieldErrors("userId").assertBodyContains("/api/action-value/login", "potato:null", "userId:null");
        simulator.test("/api/action-value/login/").withParameter("userId", "index").post().assertStatusCode(200).assertContainsFieldErrors("userId").assertBodyContains("/api/action-value/login", "potato:null", "userId:null");
        simulator.test("/api/action-value/login").withParameter("userId", "index").post().assertStatusCode(200).assertContainsFieldErrors("userId").assertBodyContains("/api/action-value/login", "potato:null", "userId:null");
        simulator.test("/api/action-value/login/").withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/login", "potato:index", "userId:null");
        UUID uUID = UUID.randomUUID();
        simulator.test("/api/action-value/login").withURLSegment(uUID).withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/login", "potato:index", "userId:" + String.valueOf(uUID));
        simulator.test("/api/action-value/index").withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/index", "potato:index", "userId:null");
        simulator.test("/api/action-value/index/").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/index", "potato:null", "userId:null");
        simulator.test("/api/action-value/index/" + String.valueOf(uUID)).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/index", "potato:null", "userId:" + String.valueOf(uUID));
        simulator.test("/api/action-value/index/").withURLSegment(uUID).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/index", "potato:null", "userId:" + String.valueOf(uUID));
        simulator.test("/api/action-value/index").withURLSegment(uUID).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/action-value/index", "potato:null", "userId:" + String.valueOf(uUID));
    }

    @Test
    public void post_withoutURLParameter_IndexAmbiguity() {
        simulator.test("/api/no-action-value/login/").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/login/foo/bar/baz").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/login/index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/login/").withParameter("userId", "index").post().assertStatusCode(200).assertContainsFieldErrors("userId").assertBodyContains("/api/no-action-value/login", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/login").withParameter("userId", "index").post().assertStatusCode(200).assertContainsFieldErrors("userId").assertBodyContains("/api/no-action-value/login", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/login/").withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:index", "userId:null");
        UUID uUID = UUID.randomUUID();
        simulator.test("/api/no-action-value/login").withURLSegment(uUID).withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:index", "userId:null");
        simulator.test("/api/no-action-value/login").withURLSegment(uUID).withParameter("potato", "index").withParameter("userId", uUID).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/login", "potato:index", "userId:" + String.valueOf(uUID));
        simulator.test("/api/no-action-value/index").withParameter("potato", "index").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/index", "potato:index", "userId:null");
        simulator.test("/api/no-action-value/index/").post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/index", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/index/" + String.valueOf(uUID)).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/index", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/index/").withURLSegment(uUID).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/index", "potato:null", "userId:null");
        simulator.test("/api/no-action-value/index").withURLSegment(uUID).post().assertStatusCode(200).assertContainsNoFieldMessages().assertBodyContains("/api/no-action-value/index", "potato:null", "userId:null");
    }

    @DataProvider
    public Object[][] purchaseRoutes() {
        return new Object[][]{{"/store/purchase"}, {"/store/allow-post-purchase"}};
    }

    @Test
    public void singletons() {
        this.assertSingleton(ActionConfigurationProvider.class);
        this.assertSingleton(Configuration.class);
        this.assertSingleton(ResourceBundle.Control.class);
        this.assertSingleton(ResourceBundle.Control.class);
        this.assertSingleton(ContainerResolver.class);
        this.assertSingleton(ConverterProvider.class);
        this.assertSingleton(ExpressionEvaluator.class);
        this.assertSingleton(URIBuilder.class);
        this.assertSingletonConverter(Boolean.class);
        this.assertSingletonConverter(Boolean.TYPE);
        this.assertSingletonConverter(Character.class);
        this.assertSingletonConverter(Character.TYPE);
        this.assertSingletonConverter(Number.class);
        this.assertSingletonConverter(Integer.TYPE);
        this.assertSingletonConverter(Long.TYPE);
        this.assertSingletonConverter(Double.TYPE);
        this.assertSingletonConverter(Float.TYPE);
        this.assertSingletonConverter(BigDecimal.class);
        this.assertSingletonConverter(BigInteger.class);
        this.assertSingletonConverter(Collection.class);
        this.assertSingletonConverter(ZonedDateTime.class);
        this.assertSingletonConverter(Enum.class);
        this.assertSingletonConverter(File.class);
        this.assertSingletonConverter(LocalDate.class);
        this.assertSingletonConverter(Locale.class);
        this.assertSingletonConverter(String.class);
    }

    @Test
    public void uriParameters() throws Exception {
        this.test.simulate(() -> simulator.test("/complex-rest/brian/static/pontarelli/then/a/bunch/of/stuff").post().assertStatusCode(200).assertBodyContains("firstName=brian", "lastName=pontarelli", "theRest=then,a,bunch,of,stuff"));
    }

    private void assertSingleton(Class<?> clazz) {
        Assert.assertSame((Object)injector.getInstance(clazz), (Object)injector.getInstance(clazz));
    }

    private void assertSingletonConverter(Class<?> clazz) {
        Map map = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<?>, GlobalConverter>>(this){}));
        Assert.assertSame(map.get(clazz), map.get(clazz));
    }

    private byte[] readBytes(String string) {
        try {
            return Files.readAllBytes(Path.of(string, new String[0]));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

