/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import java.io.IOException;
import java.util.Iterator;
import org.primeframework.mvc.workflow.Workflow;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubWorkflowChain
implements WorkflowChain {
    private static final Logger logger = LoggerFactory.getLogger(SubWorkflowChain.class);
    private final Iterator<Workflow> iterator;
    private final WorkflowChain outer;

    public SubWorkflowChain(Iterable<Workflow> workflows, WorkflowChain outer) {
        this.outer = outer;
        this.iterator = workflows.iterator();
    }

    @Override
    public void continueWorkflow() throws IOException {
        if (this.iterator.hasNext()) {
            long start = System.currentTimeMillis();
            Workflow workflow = this.iterator.next();
            workflow.perform(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Workflow [{}]] took [{}]", workflow.getClass(), (Object)(System.currentTimeMillis() - start));
            }
        } else if (this.outer != null) {
            this.outer.continueWorkflow();
        }
    }
}

